/*
 * Decompiled with CFR 0.152.
 */
package spoon.reflect.path;

import java.util.LinkedList;
import java.util.List;
import spoon.reflect.declaration.CtElement;
import spoon.reflect.path.CtPath;
import spoon.reflect.path.CtPathRole;
import spoon.reflect.path.impl.CtNamedPathElement;
import spoon.reflect.path.impl.CtPathElement;
import spoon.reflect.path.impl.CtPathImpl;
import spoon.reflect.path.impl.CtRolePathElement;
import spoon.reflect.path.impl.CtTypedNameElement;

public class CtPathBuilder {
    private List<CtPathElement> elements = new LinkedList<CtPathElement>();

    public CtPathBuilder name(String name, String[] ... args) {
        CtNamedPathElement e = new CtNamedPathElement(name);
        if (args != null) {
            for (String[] arg : args) {
                e.addArgument(arg[0], arg[1]);
            }
        }
        this.elements.add(e);
        return this;
    }

    public CtPathBuilder wildcard() {
        return this.name("*", new String[0][]);
    }

    public CtPathBuilder recursiveWildcard() {
        return this.name("**", new String[0][]);
    }

    public <T extends CtElement> CtPathBuilder type(Class<T> type, String[] ... args) {
        CtTypedNameElement e = new CtTypedNameElement(type);
        if (args != null) {
            for (String[] arg : args) {
                e.addArgument(arg[0], arg[1]);
            }
        }
        this.elements.add(e);
        return this;
    }

    public CtPathBuilder role(CtPathRole role, String[] ... args) {
        CtRolePathElement e = new CtRolePathElement(role);
        if (args != null) {
            for (String[] arg : args) {
                e.addArgument(arg[0], arg[1]);
            }
        }
        this.elements.add(e);
        return this;
    }

    public CtPath build() {
        CtPathImpl path = new CtPathImpl();
        for (CtPathElement el : this.elements) {
            path.addLast(el);
        }
        return path;
    }
}

