/*
 * Decompiled with CFR 0.152.
 */
package spoon.reflect.path;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import spoon.reflect.path.CtPath;
import spoon.reflect.path.CtPathException;
import spoon.reflect.path.CtPathRole;
import spoon.reflect.path.impl.AbstractPathElement;
import spoon.reflect.path.impl.CtNamedPathElement;
import spoon.reflect.path.impl.CtPathImpl;
import spoon.reflect.path.impl.CtRolePathElement;
import spoon.reflect.path.impl.CtTypedNameElement;

public class CtPathStringBuilder {
    private final Pattern pathPattern = Pattern.compile("([/.#])([^/.#\\[]+)(\\[([^/.#]*)\\])?");
    private final Pattern argumentPattern = Pattern.compile("(\\w+)=([^=\\]]+)");

    private Class load(String name) throws CtPathException {
        try {
            return Class.forName(name);
        }
        catch (ClassNotFoundException classNotFoundException) {
            try {
                return Class.forName("spoon.reflect.declaration." + name);
            }
            catch (ClassNotFoundException classNotFoundException2) {
                try {
                    return Class.forName("spoon.reflect.code." + name);
                }
                catch (ClassNotFoundException ex) {
                    throw new CtPathException(String.format("Unable to locate element with name $s in Spoon model", name));
                }
            }
        }
    }

    public CtPath fromString(String pathStr) throws CtPathException {
        Matcher matcher = this.pathPattern.matcher(pathStr);
        CtPathImpl path = new CtPathImpl();
        while (matcher.find()) {
            String kind = matcher.group(1);
            AbstractPathElement pathElement = null;
            if (".".equals(kind)) {
                pathElement = new CtNamedPathElement(matcher.group(2));
            } else if ("/".equals(kind)) {
                pathElement = new CtTypedNameElement(this.load(matcher.group(2)));
            } else if ("#".equals(kind)) {
                pathElement = new CtRolePathElement(CtPathRole.fromName(matcher.group(2)));
            }
            String args = matcher.group(4);
            if (args != null) {
                for (String arg : args.split(";")) {
                    Matcher argmatcher = this.argumentPattern.matcher(arg);
                    if (!argmatcher.matches()) continue;
                    pathElement.addArgument(argmatcher.group(1), argmatcher.group(2));
                }
            }
            path.addLast(pathElement);
        }
        return path;
    }
}

