/*
 * Decompiled with CFR 0.152.
 */
package spoon.reflect.visitor;

import java.lang.annotation.Annotation;
import java.util.Collection;
import spoon.reflect.code.CtAnnotationFieldAccess;
import spoon.reflect.code.CtArrayAccess;
import spoon.reflect.code.CtArrayRead;
import spoon.reflect.code.CtArrayWrite;
import spoon.reflect.code.CtAssert;
import spoon.reflect.code.CtAssignment;
import spoon.reflect.code.CtBinaryOperator;
import spoon.reflect.code.CtBlock;
import spoon.reflect.code.CtBreak;
import spoon.reflect.code.CtCase;
import spoon.reflect.code.CtCatch;
import spoon.reflect.code.CtCatchVariable;
import spoon.reflect.code.CtCodeSnippetExpression;
import spoon.reflect.code.CtCodeSnippetStatement;
import spoon.reflect.code.CtConditional;
import spoon.reflect.code.CtConstructorCall;
import spoon.reflect.code.CtContinue;
import spoon.reflect.code.CtDo;
import spoon.reflect.code.CtExecutableReferenceExpression;
import spoon.reflect.code.CtExpression;
import spoon.reflect.code.CtFieldAccess;
import spoon.reflect.code.CtFieldRead;
import spoon.reflect.code.CtFieldWrite;
import spoon.reflect.code.CtFor;
import spoon.reflect.code.CtForEach;
import spoon.reflect.code.CtIf;
import spoon.reflect.code.CtInvocation;
import spoon.reflect.code.CtLambda;
import spoon.reflect.code.CtLiteral;
import spoon.reflect.code.CtLocalVariable;
import spoon.reflect.code.CtNewArray;
import spoon.reflect.code.CtNewClass;
import spoon.reflect.code.CtOperatorAssignment;
import spoon.reflect.code.CtReturn;
import spoon.reflect.code.CtStatementList;
import spoon.reflect.code.CtSuperAccess;
import spoon.reflect.code.CtSwitch;
import spoon.reflect.code.CtSynchronized;
import spoon.reflect.code.CtThisAccess;
import spoon.reflect.code.CtThrow;
import spoon.reflect.code.CtTry;
import spoon.reflect.code.CtTryWithResource;
import spoon.reflect.code.CtTypeAccess;
import spoon.reflect.code.CtUnaryOperator;
import spoon.reflect.code.CtVariableAccess;
import spoon.reflect.code.CtVariableRead;
import spoon.reflect.code.CtVariableWrite;
import spoon.reflect.code.CtWhile;
import spoon.reflect.declaration.CtAnnotation;
import spoon.reflect.declaration.CtAnnotationType;
import spoon.reflect.declaration.CtAnonymousExecutable;
import spoon.reflect.declaration.CtClass;
import spoon.reflect.declaration.CtConstructor;
import spoon.reflect.declaration.CtElement;
import spoon.reflect.declaration.CtEnum;
import spoon.reflect.declaration.CtField;
import spoon.reflect.declaration.CtInterface;
import spoon.reflect.declaration.CtMethod;
import spoon.reflect.declaration.CtPackage;
import spoon.reflect.declaration.CtParameter;
import spoon.reflect.declaration.CtTypeParameter;
import spoon.reflect.reference.CtArrayTypeReference;
import spoon.reflect.reference.CtCatchVariableReference;
import spoon.reflect.reference.CtExecutableReference;
import spoon.reflect.reference.CtFieldReference;
import spoon.reflect.reference.CtLocalVariableReference;
import spoon.reflect.reference.CtPackageReference;
import spoon.reflect.reference.CtParameterReference;
import spoon.reflect.reference.CtReference;
import spoon.reflect.reference.CtTypeParameterReference;
import spoon.reflect.reference.CtTypeReference;
import spoon.reflect.reference.CtUnboundVariableReference;
import spoon.reflect.visitor.CtVisitor;

public abstract class CtScanner
implements CtVisitor {
    protected void enter(CtElement e) {
    }

    protected void enterReference(CtReference e) {
    }

    protected void exit(CtElement e) {
    }

    protected void exitReference(CtReference e) {
    }

    public void scan(Collection<? extends CtElement> elements) {
        if (elements != null) {
            for (CtElement ctElement : elements) {
                this.scan(ctElement);
            }
        }
    }

    public void scan(CtElement element) {
        if (element != null) {
            element.accept(this);
        }
    }

    public void scan(CtReference reference) {
        if (reference != null) {
            reference.accept(this);
        }
    }

    public void scanReferences(Collection<? extends CtReference> references) {
        if (references != null) {
            for (CtReference ctReference : references) {
                this.scan(ctReference);
            }
        }
    }

    @Override
    public <A extends Annotation> void visitCtAnnotation(CtAnnotation<A> annotation) {
        this.enter(annotation);
        this.scan(annotation.getAnnotationType());
        this.scan(annotation.getAnnotations());
        for (Object o : annotation.getElementValues().values()) {
            this.scan(o);
        }
        this.exit(annotation);
    }

    public void scan(Object o) {
        if (o instanceof CtElement) {
            this.scan((CtElement)o);
        }
        if (o instanceof CtReference) {
            this.scan((CtReference)o);
        }
        if (o instanceof Collection) {
            for (Object obj : (Collection)o) {
                this.scan(obj);
            }
        }
    }

    @Override
    public <A extends Annotation> void visitCtAnnotationType(CtAnnotationType<A> annotationType) {
        this.enter(annotationType);
        this.scan(annotationType.getAnnotations());
        this.scan(annotationType.getNestedTypes());
        this.scan(annotationType.getFields());
        this.exit(annotationType);
    }

    @Override
    public void visitCtAnonymousExecutable(CtAnonymousExecutable anonymousExec) {
        this.enter(anonymousExec);
        this.scan(anonymousExec.getAnnotations());
        this.scan(anonymousExec.getBody());
        this.exit(anonymousExec);
    }

    @Override
    public <T, E extends CtExpression<?>> void visitCtArrayAccess(CtArrayAccess<T, E> arrayAccess) {
        this.enter(arrayAccess);
        this.scan(arrayAccess.getAnnotations());
        this.scan(arrayAccess.getType());
        this.scanReferences(arrayAccess.getTypeCasts());
        this.scan((CtElement)arrayAccess.getTarget());
        this.scan(arrayAccess.getIndexExpression());
        this.exit(arrayAccess);
    }

    @Override
    public <T> void visitCtArrayRead(CtArrayRead<T> arrayRead) {
        this.visitCtArrayAccess(arrayRead);
    }

    @Override
    public <T> void visitCtArrayWrite(CtArrayWrite<T> arrayWrite) {
        this.visitCtArrayAccess(arrayWrite);
    }

    @Override
    public <T> void visitCtArrayTypeReference(CtArrayTypeReference<T> reference) {
        this.enterReference(reference);
        this.scan(reference.getDeclaringType());
        this.scan(reference.getPackage());
        this.scan(reference.getComponentType());
        this.scanReferences(reference.getActualTypeArguments());
        this.exitReference(reference);
    }

    @Override
    public <T> void visitCtAssert(CtAssert<T> asserted) {
        this.enter(asserted);
        this.scan(asserted.getAnnotations());
        this.scan(asserted.getAssertExpression());
        this.scan(asserted.getExpression());
        this.exit(asserted);
    }

    @Override
    public <T, A extends T> void visitCtAssignment(CtAssignment<T, A> assignement) {
        this.enter(assignement);
        this.scan(assignement.getAnnotations());
        this.scan(assignement.getType());
        this.scanReferences(assignement.getTypeCasts());
        this.scan(assignement.getAssigned());
        this.scan(assignement.getAssignment());
        this.exit(assignement);
    }

    @Override
    public <T> void visitCtBinaryOperator(CtBinaryOperator<T> operator) {
        this.enter(operator);
        this.scan(operator.getAnnotations());
        this.scan(operator.getType());
        this.scanReferences(operator.getTypeCasts());
        this.scan(operator.getLeftHandOperand());
        this.scan(operator.getRightHandOperand());
        this.exit(operator);
    }

    @Override
    public <R> void visitCtBlock(CtBlock<R> block) {
        this.enter(block);
        this.scan(block.getAnnotations());
        this.scan(block.getStatements());
        this.exit(block);
    }

    @Override
    public void visitCtBreak(CtBreak breakStatement) {
        this.enter(breakStatement);
        this.scan(breakStatement.getAnnotations());
        this.exit(breakStatement);
    }

    @Override
    public <S> void visitCtCase(CtCase<S> caseStatement) {
        this.enter(caseStatement);
        this.scan(caseStatement.getAnnotations());
        this.scan(caseStatement.getCaseExpression());
        this.scan(caseStatement.getStatements());
        this.exit(caseStatement);
    }

    @Override
    public void visitCtCatch(CtCatch catchBlock) {
        this.enter(catchBlock);
        this.scan(catchBlock.getAnnotations());
        this.scan(catchBlock.getParameter());
        this.scan(catchBlock.getBody());
        this.exit(catchBlock);
    }

    @Override
    public <T> void visitCtClass(CtClass<T> ctClass) {
        this.enter(ctClass);
        this.scan(ctClass.getAnnotations());
        this.scan(ctClass.getSuperclass());
        this.scanReferences(ctClass.getSuperInterfaces());
        this.scanReferences(ctClass.getFormalTypeParameters());
        this.scan(ctClass.getAnonymousExecutables());
        this.scan(ctClass.getNestedTypes());
        this.scan(ctClass.getFields());
        this.scan(ctClass.getConstructors());
        this.scan(ctClass.getMethods());
        this.exit(ctClass);
    }

    @Override
    public <T> void visitCtConditional(CtConditional<T> conditional) {
        this.enter(conditional);
        this.scan(conditional.getAnnotations());
        this.scan(conditional.getCondition());
        this.scan(conditional.getThenExpression());
        this.scan(conditional.getElseExpression());
        this.exit(conditional);
    }

    @Override
    public <T> void visitCtConstructor(CtConstructor<T> c) {
        this.enter(c);
        this.scan(c.getAnnotations());
        this.scan(c.getParameters());
        this.scanReferences(c.getThrownTypes());
        this.scanReferences(c.getFormalTypeParameters());
        this.scan(c.getBody());
        this.exit(c);
    }

    @Override
    public void visitCtContinue(CtContinue continueStatement) {
        this.enter(continueStatement);
        this.scan(continueStatement.getAnnotations());
        this.scan(continueStatement.getLabelledStatement());
        this.exit(continueStatement);
    }

    @Override
    public void visitCtDo(CtDo doLoop) {
        this.enter(doLoop);
        this.scan(doLoop.getAnnotations());
        this.scan(doLoop.getLoopingExpression());
        this.scan(doLoop.getBody());
        this.exit(doLoop);
    }

    @Override
    public <T extends Enum<?>> void visitCtEnum(CtEnum<T> ctEnum) {
        this.enter(ctEnum);
        this.scan(ctEnum.getAnnotations());
        this.scan(ctEnum.getFields());
        this.scan(ctEnum.getConstructors());
        this.scan(ctEnum.getMethods());
        this.scan(ctEnum.getNestedTypes());
        this.exit(ctEnum);
    }

    @Override
    public <T> void visitCtExecutableReference(CtExecutableReference<T> reference) {
        this.enterReference(reference);
        this.scan(reference.getDeclaringType());
        this.scan(reference.getType());
        this.scanReferences(reference.getActualTypeArguments());
        this.exitReference(reference);
    }

    @Override
    public <T> void visitCtField(CtField<T> f) {
        this.enter(f);
        this.scan(f.getAnnotations());
        this.scan(f.getType());
        this.scan(f.getDefaultExpression());
        this.exit(f);
    }

    @Override
    public <T> void visitCtThisAccess(CtThisAccess<T> thisAccess) {
        this.enter(thisAccess);
        this.scan(thisAccess.getType());
        this.scanReferences(thisAccess.getTypeCasts());
        this.scan((CtElement)thisAccess.getTarget());
        this.exit(thisAccess);
    }

    @Override
    public <T> void visitCtAnnotationFieldAccess(CtAnnotationFieldAccess<T> annotationFieldAccess) {
        this.enter(annotationFieldAccess);
        this.scan(annotationFieldAccess.getAnnotations());
        this.scan(annotationFieldAccess.getType());
        this.scanReferences(annotationFieldAccess.getTypeCasts());
        this.scan((CtElement)annotationFieldAccess.getTarget());
        this.scan(annotationFieldAccess.getVariable());
        this.exit(annotationFieldAccess);
    }

    @Override
    public <T> void visitCtFieldReference(CtFieldReference<T> reference) {
        this.enterReference(reference);
        this.scan(reference.getDeclaringType());
        this.scan(reference.getType());
        this.exitReference(reference);
    }

    @Override
    public void visitCtFor(CtFor forLoop) {
        this.enter(forLoop);
        this.scan(forLoop.getAnnotations());
        this.scan(forLoop.getForInit());
        this.scan(forLoop.getExpression());
        this.scan(forLoop.getForUpdate());
        this.scan(forLoop.getBody());
        this.exit(forLoop);
    }

    @Override
    public void visitCtForEach(CtForEach foreach) {
        this.enter(foreach);
        this.scan(foreach.getAnnotations());
        this.scan(foreach.getVariable());
        this.scan(foreach.getExpression());
        this.scan(foreach.getBody());
        this.exit(foreach);
    }

    @Override
    public void visitCtIf(CtIf ifElement) {
        this.enter(ifElement);
        this.scan(ifElement.getAnnotations());
        this.scan(ifElement.getCondition());
        this.scan((CtElement)ifElement.getThenStatement());
        this.scan((CtElement)ifElement.getElseStatement());
        this.exit(ifElement);
    }

    @Override
    public <T> void visitCtInterface(CtInterface<T> intrface) {
        this.enter(intrface);
        this.scan(intrface.getAnnotations());
        this.scanReferences(intrface.getSuperInterfaces());
        this.scanReferences(intrface.getFormalTypeParameters());
        this.scan(intrface.getNestedTypes());
        this.scan(intrface.getFields());
        this.scan(intrface.getMethods());
        this.exit(intrface);
    }

    @Override
    public <T> void visitCtInvocation(CtInvocation<T> invocation) {
        this.enter(invocation);
        this.scan(invocation.getAnnotations());
        this.scan(invocation.getType());
        this.scanReferences(invocation.getTypeCasts());
        this.scan((CtElement)invocation.getTarget());
        this.scan(invocation.getExecutable());
        this.scan(invocation.getArguments());
        this.exit(invocation);
    }

    @Override
    public <T> void visitCtLiteral(CtLiteral<T> literal) {
        this.enter(literal);
        this.scan(literal.getAnnotations());
        this.scan(literal.getType());
        this.scanReferences(literal.getTypeCasts());
        T value = literal.getValue();
        if (value instanceof CtReference) {
            this.scan((CtReference)value);
        }
        this.exit(literal);
    }

    @Override
    public <T> void visitCtLocalVariable(CtLocalVariable<T> localVariable) {
        this.enter(localVariable);
        this.scan(localVariable.getAnnotations());
        this.scan(localVariable.getType());
        this.scan(localVariable.getDefaultExpression());
        this.exit(localVariable);
    }

    @Override
    public <T> void visitCtLocalVariableReference(CtLocalVariableReference<T> reference) {
        this.enterReference(reference);
        this.scan(reference.getType());
        this.exitReference(reference);
    }

    @Override
    public <T> void visitCtCatchVariable(CtCatchVariable<T> catchVariable) {
        this.enter(catchVariable);
        this.scan(catchVariable.getAnnotations());
        this.scan(catchVariable.getType());
        this.exit(catchVariable);
    }

    @Override
    public <T> void visitCtCatchVariableReference(CtCatchVariableReference<T> reference) {
        this.enterReference(reference);
        this.scan(reference.getType());
        this.exitReference(reference);
    }

    @Override
    public <T> void visitCtMethod(CtMethod<T> m) {
        this.enter(m);
        this.scan(m.getAnnotations());
        this.scan(m.getType());
        this.scan(m.getParameters());
        this.scanReferences(m.getThrownTypes());
        this.scanReferences(m.getFormalTypeParameters());
        this.scan(m.getBody());
        this.exit(m);
    }

    @Override
    public <T> void visitCtNewArray(CtNewArray<T> newArray) {
        this.enter(newArray);
        this.scan(newArray.getAnnotations());
        this.scan(newArray.getType());
        this.scanReferences(newArray.getTypeCasts());
        this.scan(newArray.getElements());
        this.scan(newArray.getDimensionExpressions());
        this.exit(newArray);
    }

    @Override
    public <T> void visitCtConstructorCall(CtConstructorCall<T> ctConstructorCall) {
        this.enter(ctConstructorCall);
        this.scan(ctConstructorCall.getAnnotations());
        this.scan(ctConstructorCall.getType());
        this.scanReferences(ctConstructorCall.getTypeCasts());
        this.scan(ctConstructorCall.getExecutable());
        this.scan((CtElement)ctConstructorCall.getTarget());
        this.scan(ctConstructorCall.getArguments());
        this.exit(ctConstructorCall);
    }

    @Override
    public <T> void visitCtNewClass(CtNewClass<T> newClass) {
        this.enter(newClass);
        this.scan(newClass.getAnnotations());
        this.scan(newClass.getType());
        this.scanReferences(newClass.getTypeCasts());
        this.scan(newClass.getExecutable());
        this.scan((CtElement)newClass.getTarget());
        this.scan(newClass.getArguments());
        this.scan(newClass.getAnonymousClass());
        this.exit(newClass);
    }

    @Override
    public <T> void visitCtLambda(CtLambda<T> lambda) {
        this.enter(lambda);
        this.scan(lambda.getAnnotations());
        this.scan(lambda.getType());
        this.scanReferences(lambda.getTypeCasts());
        this.scan(lambda.getParameters());
        this.scan(lambda.getBody());
        this.scan(lambda.getExpression());
        this.exit(lambda);
    }

    @Override
    public <T, E extends CtExpression<?>> void visitCtExecutableReferenceExpression(CtExecutableReferenceExpression<T, E> expression) {
        this.enter(expression);
        this.scan(expression.getType());
        this.scanReferences(expression.getTypeCasts());
        this.scan(expression.getExecutable());
        this.scan((CtElement)expression.getTarget());
        this.exit(expression);
    }

    @Override
    public <T, A extends T> void visitCtOperatorAssignment(CtOperatorAssignment<T, A> assignment) {
        this.enter(assignment);
        this.scan(assignment.getAnnotations());
        this.scan(assignment.getType());
        this.scanReferences(assignment.getTypeCasts());
        this.scan(assignment.getAssigned());
        this.scan(assignment.getAssignment());
        this.exit(assignment);
    }

    @Override
    public void visitCtPackage(CtPackage ctPackage) {
        this.enter(ctPackage);
        this.scan(ctPackage.getAnnotations());
        this.scan(ctPackage.getPackages());
        this.scan(ctPackage.getTypes());
        this.exit(ctPackage);
    }

    @Override
    public void visitCtPackageReference(CtPackageReference reference) {
        this.enterReference(reference);
        this.exitReference(reference);
    }

    @Override
    public <T> void visitCtParameter(CtParameter<T> parameter) {
        this.enter(parameter);
        this.scan(parameter.getAnnotations());
        this.scan(parameter.getType());
        this.exit(parameter);
    }

    @Override
    public <T> void visitCtParameterReference(CtParameterReference<T> reference) {
        this.enterReference(reference);
        this.scan(reference.getType());
        this.exitReference(reference);
    }

    @Override
    public <R> void visitCtReturn(CtReturn<R> returnStatement) {
        this.enter(returnStatement);
        this.scan(returnStatement.getAnnotations());
        this.scan(returnStatement.getReturnedExpression());
        this.exit(returnStatement);
    }

    @Override
    public <R> void visitCtStatementList(CtStatementList statements) {
        this.enter(statements);
        this.scan(statements.getAnnotations());
        this.scan(statements.getStatements());
        this.exit(statements);
    }

    @Override
    public <S> void visitCtSwitch(CtSwitch<S> switchStatement) {
        this.enter(switchStatement);
        this.scan(switchStatement.getAnnotations());
        this.scan(switchStatement.getSelector());
        this.scan(switchStatement.getCases());
        this.exit(switchStatement);
    }

    @Override
    public void visitCtSynchronized(CtSynchronized synchro) {
        this.enter(synchro);
        this.scan(synchro.getAnnotations());
        this.scan(synchro.getExpression());
        this.scan(synchro.getBlock());
        this.exit(synchro);
    }

    @Override
    public void visitCtThrow(CtThrow throwStatement) {
        this.enter(throwStatement);
        this.scan(throwStatement.getAnnotations());
        this.scan(throwStatement.getThrownExpression());
        this.exit(throwStatement);
    }

    @Override
    public void visitCtTry(CtTry tryBlock) {
        this.enter(tryBlock);
        this.scan(tryBlock.getAnnotations());
        this.scan(tryBlock.getBody());
        this.scan(tryBlock.getCatchers());
        this.scan(tryBlock.getFinalizer());
        this.exit(tryBlock);
    }

    @Override
    public void visitCtTryWithResource(CtTryWithResource tryWithResource) {
        this.enter(tryWithResource);
        this.scan(tryWithResource.getAnnotations());
        this.scan(tryWithResource.getResources());
        this.scan(tryWithResource.getBody());
        this.scan(tryWithResource.getCatchers());
        this.scan(tryWithResource.getFinalizer());
        this.exit(tryWithResource);
    }

    @Override
    public void visitCtTypeParameter(CtTypeParameter typeParameter) {
        this.enter(typeParameter);
        this.scan(typeParameter.getAnnotations());
        this.scanReferences(typeParameter.getBounds());
        this.exit(typeParameter);
    }

    @Override
    public void visitCtTypeParameterReference(CtTypeParameterReference ref) {
        this.enterReference(ref);
        this.scan(ref.getPackage());
        this.scan(ref.getDeclaringType());
        this.scanReferences(ref.getActualTypeArguments());
        this.scanReferences(ref.getBounds());
        this.exitReference(ref);
    }

    @Override
    public <T> void visitCtTypeReference(CtTypeReference<T> reference) {
        this.enterReference(reference);
        this.scan(reference.getPackage());
        this.scan(reference.getDeclaringType());
        this.scanReferences(reference.getActualTypeArguments());
        this.exitReference(reference);
    }

    @Override
    public <T> void visitCtTypeAccess(CtTypeAccess<T> typeAccess) {
        this.enter(typeAccess);
        this.scan(typeAccess.getAnnotations());
        this.scan(typeAccess.getType());
        this.scanReferences(typeAccess.getTypeCasts());
        this.exit(typeAccess);
    }

    @Override
    public <T> void visitCtUnaryOperator(CtUnaryOperator<T> operator) {
        this.enter(operator);
        this.scan(operator.getAnnotations());
        this.scan(operator.getType());
        this.scanReferences(operator.getTypeCasts());
        this.scan(operator.getOperand());
        this.exit(operator);
    }

    @Override
    public <T> void visitCtVariableAccess(CtVariableAccess<T> variableAccess) {
        this.enter(variableAccess);
        this.scan(variableAccess.getAnnotations());
        this.scan(variableAccess.getType());
        this.scanReferences(variableAccess.getTypeCasts());
        this.scan(variableAccess.getVariable());
        this.exit(variableAccess);
    }

    @Override
    public <T> void visitCtVariableRead(CtVariableRead<T> variableRead) {
        this.visitCtVariableAccess(variableRead);
    }

    @Override
    public <T> void visitCtVariableWrite(CtVariableWrite<T> variableWrite) {
        this.visitCtVariableAccess(variableWrite);
    }

    @Override
    public void visitCtWhile(CtWhile whileLoop) {
        this.enter(whileLoop);
        this.scan(whileLoop.getAnnotations());
        this.scan(whileLoop.getLoopingExpression());
        this.scan(whileLoop.getBody());
        this.exit(whileLoop);
    }

    @Override
    public <T> void visitCtCodeSnippetExpression(CtCodeSnippetExpression<T> expression) {
    }

    @Override
    public void visitCtCodeSnippetStatement(CtCodeSnippetStatement statement) {
    }

    @Override
    public <T> void visitCtUnboundVariableReference(CtUnboundVariableReference<T> reference) {
    }

    @Override
    public <T> void visitCtFieldAccess(CtFieldAccess<T> f) {
        this.enter(f);
        this.scan(f.getAnnotations());
        this.scan(f.getType());
        this.scanReferences(f.getTypeCasts());
        this.scan((CtElement)f.getTarget());
        this.scan(f.getVariable());
        this.exit(f);
    }

    @Override
    public <T> void visitCtFieldRead(CtFieldRead<T> fieldRead) {
        this.visitCtFieldAccess(fieldRead);
    }

    @Override
    public <T> void visitCtFieldWrite(CtFieldWrite<T> fieldWrite) {
        this.visitCtFieldAccess(fieldWrite);
    }

    @Override
    public <T> void visitCtSuperAccess(CtSuperAccess<T> f) {
        this.enter(f);
        this.scan(f.getAnnotations());
        this.scan(f.getType());
        this.scanReferences(f.getTypeCasts());
        this.scan((CtElement)f.getTarget());
        this.exit(f);
    }
}

