/*
 * Decompiled with CFR 0.152.
 */
package spoon.reflect.visitor;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import org.apache.log4j.Level;
import spoon.compiler.Environment;
import spoon.reflect.code.BinaryOperatorKind;
import spoon.reflect.code.CtAnnotationFieldAccess;
import spoon.reflect.code.CtArrayAccess;
import spoon.reflect.code.CtArrayRead;
import spoon.reflect.code.CtArrayWrite;
import spoon.reflect.code.CtAssert;
import spoon.reflect.code.CtAssignment;
import spoon.reflect.code.CtBinaryOperator;
import spoon.reflect.code.CtBlock;
import spoon.reflect.code.CtBreak;
import spoon.reflect.code.CtCase;
import spoon.reflect.code.CtCatch;
import spoon.reflect.code.CtCatchVariable;
import spoon.reflect.code.CtCodeElement;
import spoon.reflect.code.CtCodeSnippetExpression;
import spoon.reflect.code.CtCodeSnippetStatement;
import spoon.reflect.code.CtConditional;
import spoon.reflect.code.CtConstructorCall;
import spoon.reflect.code.CtContinue;
import spoon.reflect.code.CtDo;
import spoon.reflect.code.CtExecutableReferenceExpression;
import spoon.reflect.code.CtExpression;
import spoon.reflect.code.CtFieldAccess;
import spoon.reflect.code.CtFieldRead;
import spoon.reflect.code.CtFieldWrite;
import spoon.reflect.code.CtFor;
import spoon.reflect.code.CtForEach;
import spoon.reflect.code.CtIf;
import spoon.reflect.code.CtInvocation;
import spoon.reflect.code.CtLambda;
import spoon.reflect.code.CtLiteral;
import spoon.reflect.code.CtLocalVariable;
import spoon.reflect.code.CtNewArray;
import spoon.reflect.code.CtNewClass;
import spoon.reflect.code.CtOperatorAssignment;
import spoon.reflect.code.CtReturn;
import spoon.reflect.code.CtStatement;
import spoon.reflect.code.CtStatementList;
import spoon.reflect.code.CtSuperAccess;
import spoon.reflect.code.CtSwitch;
import spoon.reflect.code.CtSynchronized;
import spoon.reflect.code.CtTargetedExpression;
import spoon.reflect.code.CtThisAccess;
import spoon.reflect.code.CtThrow;
import spoon.reflect.code.CtTry;
import spoon.reflect.code.CtTryWithResource;
import spoon.reflect.code.CtTypeAccess;
import spoon.reflect.code.CtUnaryOperator;
import spoon.reflect.code.CtVariableAccess;
import spoon.reflect.code.CtVariableRead;
import spoon.reflect.code.CtVariableWrite;
import spoon.reflect.code.CtWhile;
import spoon.reflect.code.UnaryOperatorKind;
import spoon.reflect.cu.CompilationUnit;
import spoon.reflect.declaration.CtAnnotation;
import spoon.reflect.declaration.CtAnnotationType;
import spoon.reflect.declaration.CtAnonymousExecutable;
import spoon.reflect.declaration.CtClass;
import spoon.reflect.declaration.CtConstructor;
import spoon.reflect.declaration.CtElement;
import spoon.reflect.declaration.CtEnum;
import spoon.reflect.declaration.CtExecutable;
import spoon.reflect.declaration.CtField;
import spoon.reflect.declaration.CtInterface;
import spoon.reflect.declaration.CtMethod;
import spoon.reflect.declaration.CtModifiable;
import spoon.reflect.declaration.CtNamedElement;
import spoon.reflect.declaration.CtPackage;
import spoon.reflect.declaration.CtParameter;
import spoon.reflect.declaration.CtType;
import spoon.reflect.declaration.CtTypeParameter;
import spoon.reflect.declaration.ModifierKind;
import spoon.reflect.declaration.ParentNotInitializedException;
import spoon.reflect.factory.Factory;
import spoon.reflect.reference.CtArrayTypeReference;
import spoon.reflect.reference.CtCatchVariableReference;
import spoon.reflect.reference.CtExecutableReference;
import spoon.reflect.reference.CtFieldReference;
import spoon.reflect.reference.CtGenericElementReference;
import spoon.reflect.reference.CtImplicitTypeReference;
import spoon.reflect.reference.CtLocalVariableReference;
import spoon.reflect.reference.CtPackageReference;
import spoon.reflect.reference.CtParameterReference;
import spoon.reflect.reference.CtReference;
import spoon.reflect.reference.CtTypeParameterReference;
import spoon.reflect.reference.CtTypeReference;
import spoon.reflect.reference.CtUnboundVariableReference;
import spoon.reflect.visitor.CtVisitor;
import spoon.reflect.visitor.ImportScanner;
import spoon.reflect.visitor.ImportScannerImpl;
import spoon.reflect.visitor.PrettyPrinter;
import spoon.support.reflect.cu.CtLineElementComparator;
import spoon.support.util.SortedList;
import spoon.support.visitor.SignaturePrinter;

public class DefaultJavaPrettyPrinter
implements CtVisitor,
PrettyPrinter {
    public static final String JAVA_FILE_EXTENSION = ".java";
    public static final String JAVA_PACKAGE_DECLARATION = "package-info.java";
    public static final String LINE_SEPARATOR = System.getProperty("line.separator");
    Map<Integer, Integer> lineNumberMapping = new HashMap<Integer, Integer>();
    public PrintingContext context = new PrintingContext();
    private ImportScanner importsContext = new ImportScannerImpl();
    private StringBuffer sbf = new StringBuffer();
    private Environment env;
    private int line = 1;
    private CompilationUnit sourceCompilationUnit;

    public DefaultJavaPrettyPrinter(Environment env) {
        this.env = env;
    }

    public DefaultJavaPrettyPrinter decTab() {
        --this.context.nbTabs;
        return this;
    }

    private void undefLine(int line) {
        if (this.lineNumberMapping.get(line) == null) {
            this.lineNumberMapping.put(line, 0);
        }
    }

    private void mapLine(int line, CtElement e) {
        if (e.getPosition() != null && e.getPosition().getCompilationUnit() == this.sourceCompilationUnit) {
            this.lineNumberMapping.put(line, e.getPosition().getLine());
        } else {
            this.undefLine(line);
        }
    }

    protected void enterCtExpression(CtExpression<?> e) {
        this.mapLine(this.line, e);
        if (this.shouldSetBracket(e)) {
            this.context.parenthesedExpression.push(e);
            this.write("(");
        }
        if (!e.getTypeCasts().isEmpty()) {
            for (CtTypeReference<?> r : e.getTypeCasts()) {
                this.write("(");
                this.scan(r);
                this.write(")");
                this.write("(");
                this.context.parenthesedExpression.push(e);
            }
        }
    }

    private void printTypeAnnotations(CtTypeReference<?> r) {
        if (!r.getTypeAnnotations().isEmpty()) {
            for (CtAnnotation<? extends Annotation> annotation : r.getTypeAnnotations()) {
                this.scan(annotation);
            }
        }
    }

    protected void enterCtStatement(CtStatement s) {
        this.mapLine(this.line, s);
        this.writeAnnotations(s);
        if (s.getLabel() != null) {
            this.write(s.getLabel()).write(" : ");
        }
    }

    protected void exitCtExpression(CtExpression<?> e) {
        while (this.context.parenthesedExpression.size() > 0 && e == this.context.parenthesedExpression.peek()) {
            this.context.parenthesedExpression.pop();
            this.write(")");
        }
    }

    @Override
    public String getPackageDeclaration() {
        StringBuffer bck = this.sbf;
        this.sbf = new StringBuffer();
        for (CtAnnotation<? extends Annotation> a : this.context.currentTopLevel.getPackage().getAnnotations()) {
            a.accept(this);
        }
        if (!this.context.currentTopLevel.getPackage().getQualifiedName().equals("unnamed package")) {
            this.write("package " + this.context.currentTopLevel.getPackage().getQualifiedName() + ";");
        }
        String ret = this.sbf.toString();
        this.sbf = bck;
        return ret;
    }

    @Override
    public String getResult() {
        return this.sbf.toString();
    }

    public DefaultJavaPrettyPrinter incTab() {
        ++this.context.nbTabs;
        return this;
    }

    public DefaultJavaPrettyPrinter setTabCount(int tabCount) {
        this.context.nbTabs = tabCount;
        return this;
    }

    private boolean isWhite(char c) {
        return c == ' ' || c == '\t' || c == '\n' || c == '\r';
    }

    public Collection<CtTypeReference<?>> computeImports(CtType<?> type) {
        if (this.env.isAutoImports()) {
            this.context.currentTopLevel = type;
            return this.importsContext.computeImports(this.context.currentTopLevel);
        }
        return Collections.emptyList();
    }

    public void computeImports(CtElement element) {
        if (this.env.isAutoImports()) {
            this.importsContext.computeImports(element);
        }
    }

    protected void postWriteUnaryOperator(UnaryOperatorKind o) {
        switch (o) {
            case POSTINC: {
                this.write("++");
                break;
            }
            case POSTDEC: {
                this.write("--");
                break;
            }
        }
    }

    void preWriteUnaryOperator(UnaryOperatorKind o) {
        switch (o) {
            case POS: {
                this.write("+");
                break;
            }
            case NEG: {
                this.write("-");
                break;
            }
            case NOT: {
                this.write("!");
                break;
            }
            case COMPL: {
                this.write("~");
                break;
            }
            case PREINC: {
                this.write("++");
                break;
            }
            case PREDEC: {
                this.write("--");
                break;
            }
        }
    }

    protected DefaultJavaPrettyPrinter removeLastChar() {
        while (this.isWhite(this.sbf.charAt(this.sbf.length() - 1))) {
            if (this.sbf.charAt(this.sbf.length() - 1) == '\n') {
                --this.line;
            }
            this.sbf.deleteCharAt(this.sbf.length() - 1);
        }
        this.sbf.deleteCharAt(this.sbf.length() - 1);
        while (this.isWhite(this.sbf.charAt(this.sbf.length() - 1))) {
            if (this.sbf.charAt(this.sbf.length() - 1) == '\n') {
                --this.line;
            }
            this.sbf.deleteCharAt(this.sbf.length() - 1);
        }
        return this;
    }

    public DefaultJavaPrettyPrinter scan(CtElement e) {
        if (e != null) {
            this.context.elementStack.push(e);
            if (this.env.isPreserveLineNumbers()) {
                boolean bl = this.context.noNewLines = e.getPosition() == null || e.getPosition().getCompilationUnit() != this.sourceCompilationUnit;
                if (!(e instanceof CtNamedElement)) {
                    this.adjustPosition(e);
                }
            }
            e.accept(this);
            this.context.elementStack.pop();
        }
        return this;
    }

    private void insertLine() {
        int i;
        for (i = this.sbf.length() - 1; i >= 0 && (this.sbf.charAt(i) == ' ' || this.sbf.charAt(i) == '\t'); --i) {
        }
        this.sbf.insert(i + 1, LINE_SEPARATOR);
        ++this.line;
    }

    private boolean removeLine() {
        int i;
        String ls = LINE_SEPARATOR;
        boolean hasWhite = false;
        for (i = this.sbf.length() - ls.length(); i > 0 && !ls.equals(this.sbf.substring(i, i + ls.length())); --i) {
            if (!this.isWhite(this.sbf.charAt(i))) {
                return false;
            }
            hasWhite = true;
        }
        if (i <= 0) {
            return false;
        }
        hasWhite = hasWhite || this.isWhite(this.sbf.charAt(i - 1));
        this.sbf.replace(i, i + ls.length(), hasWhite ? "" : " ");
        --this.line;
        return true;
    }

    protected void printCharArray(char[] c) {
        for (int i = 0; i < c.length; ++i) {
            switch (c[i]) {
                case '\b': {
                    System.out.print("\\b");
                    break;
                }
                case '\t': {
                    System.out.print("\\t");
                    break;
                }
                case '\n': {
                    System.out.print("\\n");
                    break;
                }
                case '\f': {
                    System.out.print("\\f");
                    break;
                }
                case '\r': {
                    System.out.print("\\r");
                    break;
                }
                case '\"': {
                    System.out.print("\\\"");
                    break;
                }
                case '\'': {
                    System.out.print("\\'");
                    break;
                }
                case '\\': {
                    System.out.println("\\\\");
                    break;
                }
                default: {
                    System.out.print(c[i]);
                }
            }
            if (i >= c.length - 1) continue;
            System.out.print(",");
        }
    }

    private void adjustPosition(CtElement e) {
        if (e.getPosition() != null && e.getPosition().getCompilationUnit() != null && e.getPosition().getCompilationUnit() == this.sourceCompilationUnit) {
            while (this.line < e.getPosition().getLine()) {
                this.insertLine();
            }
            while (this.line > e.getPosition().getLine()) {
                if (this.removeLine()) continue;
                if (this.line <= e.getPosition().getEndLine()) break;
                this.env.report(null, Level.WARN, e, "cannot adjust position of " + e.getClass().getSimpleName() + " '" + e.getSignature() + "' " + " to match lines: " + this.line + " > [" + e.getPosition().getLine() + ", " + e.getPosition().getEndLine() + "]");
                break;
            }
        }
    }

    public DefaultJavaPrettyPrinter scan(CtReference ref) {
        if (ref != null) {
            ref.accept(this);
        }
        return this;
    }

    private boolean shouldSetBracket(CtExpression<?> e) {
        if (e.getTypeCasts().size() != 0) {
            return true;
        }
        try {
            if (e.getParent() instanceof CtBinaryOperator || e.getParent() instanceof CtUnaryOperator) {
                return e instanceof CtTargetedExpression || e instanceof CtAssignment || e instanceof CtConditional || e instanceof CtUnaryOperator;
            }
            if (e.getParent() instanceof CtTargetedExpression) {
                return e instanceof CtBinaryOperator || e instanceof CtAssignment || e instanceof CtConditional;
            }
        }
        catch (ParentNotInitializedException parentNotInitializedException) {
            // empty catch block
        }
        return false;
    }

    public String toString() {
        return this.sbf.toString();
    }

    @Override
    public <A extends Annotation> void visitCtAnnotation(CtAnnotation<A> annotation) {
        this.writeAnnotations(annotation);
        this.write("@");
        this.scan(annotation.getAnnotationType());
        if (annotation.getElementValues().size() > 0) {
            this.write("(");
            for (Map.Entry<String, Object> e : annotation.getElementValues().entrySet()) {
                this.write(e.getKey() + " = ");
                this.writeAnnotationElement(annotation.getFactory(), e.getValue());
                this.write(", ");
            }
            this.removeLastChar();
            this.write(")");
        }
        this.writeln().writeTabs();
    }

    @Override
    public <A extends Annotation> void visitCtAnnotationType(CtAnnotationType<A> annotationType) {
        this.visitCtType(annotationType);
        this.write("@interface " + annotationType.getSimpleName() + " {").incTab();
        SortedList<CtElement> lst = new SortedList<CtElement>(new CtLineElementComparator());
        lst.addAll(annotationType.getNestedTypes());
        lst.addAll(annotationType.getFields());
        for (CtElement el : lst) {
            this.writeln().writeTabs().scan(el);
            if (this.env.isPreserveLineNumbers()) continue;
            this.writeln();
        }
        this.decTab().writeTabs().write("}");
    }

    @Override
    public void visitCtAnonymousExecutable(CtAnonymousExecutable impl) {
        this.writeAnnotations(impl);
        this.writeModifiers(impl);
        this.scan(impl.getBody());
    }

    @Override
    public <T, E extends CtExpression<?>> void visitCtArrayAccess(CtArrayAccess<T, E> arrayAccess) {
        this.enterCtExpression(arrayAccess);
        this.scan((CtElement)arrayAccess.getTarget());
        this.write("[").scan(arrayAccess.getIndexExpression()).write("]");
        this.exitCtExpression(arrayAccess);
    }

    @Override
    public <T> void visitCtArrayRead(CtArrayRead<T> arrayRead) {
        this.visitCtArrayAccess(arrayRead);
    }

    @Override
    public <T> void visitCtArrayWrite(CtArrayWrite<T> arrayWrite) {
        this.visitCtArrayAccess(arrayWrite);
    }

    @Override
    public <T> void visitCtArrayTypeReference(CtArrayTypeReference<T> reference) {
        this.scan(reference.getComponentType());
        if (!this.context.skipArray) {
            this.write("[]");
        }
    }

    @Override
    public <T> void visitCtAssert(CtAssert<T> asserted) {
        this.enterCtStatement(asserted);
        this.write("assert ");
        this.scan(asserted.getAssertExpression());
        if (asserted.getExpression() != null) {
            this.write(" : ");
            this.scan(asserted.getExpression());
        }
    }

    @Override
    public <T, A extends T> void visitCtAssignment(CtAssignment<T, A> assignement) {
        this.enterCtStatement(assignement);
        this.enterCtExpression(assignement);
        this.scan(assignement.getAssigned());
        this.write(" = ");
        this.scan(assignement.getAssignment());
        this.exitCtExpression(assignement);
    }

    @Override
    public <T> void visitCtBinaryOperator(CtBinaryOperator<T> operator) {
        this.enterCtExpression(operator);
        boolean paren = false;
        try {
            paren = operator.getParent() instanceof CtBinaryOperator || operator.getParent() instanceof CtUnaryOperator;
        }
        catch (ParentNotInitializedException parentNotInitializedException) {
            // empty catch block
        }
        if (paren) {
            this.write("(");
        }
        this.scan(operator.getLeftHandOperand());
        this.write(" ").writeOperator(operator.getKind()).write(" ");
        this.scan(operator.getRightHandOperand());
        if (paren) {
            this.write(")");
        }
        this.exitCtExpression(operator);
    }

    @Override
    public <R> void visitCtBlock(CtBlock<R> block) {
        this.enterCtStatement(block);
        this.write("{").incTab();
        for (CtStatement e : block.getStatements()) {
            if (e.isImplicit()) continue;
            this.writeln().writeTabs();
            this.writeStatement(e);
        }
        if (this.env.isPreserveLineNumbers()) {
            this.decTab().write("}");
        } else {
            this.decTab().writeln().writeTabs().write("}");
        }
    }

    @Override
    public void visitCtBreak(CtBreak breakStatement) {
        this.enterCtStatement(breakStatement);
        this.write("break");
        if (breakStatement.getTargetLabel() != null) {
            this.write(" " + breakStatement.getTargetLabel());
        }
    }

    public <E> void visitCtCase(CtCase<E> caseStatement) {
        this.enterCtStatement(caseStatement);
        if (caseStatement.getCaseExpression() != null) {
            this.write("case ");
            if (caseStatement.getCaseExpression() instanceof CtFieldAccess && ((CtFieldAccess)caseStatement.getCaseExpression()).getVariable().getType().getQualifiedName().equals(((CtFieldAccess)caseStatement.getCaseExpression()).getVariable().getDeclaringType().getQualifiedName())) {
                this.write(((CtFieldAccess)caseStatement.getCaseExpression()).getVariable().getSimpleName());
            } else {
                this.scan(caseStatement.getCaseExpression());
            }
        } else {
            this.write("default");
        }
        this.write(" :").incTab();
        for (CtStatement s : caseStatement.getStatements()) {
            this.writeln().writeTabs().writeStatement(s);
        }
        this.decTab();
    }

    @Override
    public void visitCtCatch(CtCatch catchBlock) {
        this.write(" catch (");
        CtCatchVariable<? extends Throwable> parameter = catchBlock.getParameter();
        if (parameter.getMultiTypes().size() > 0) {
            for (int i = 0; i < parameter.getMultiTypes().size(); ++i) {
                CtTypeReference<?> type = parameter.getMultiTypes().get(i);
                this.scan(type);
                if (i >= parameter.getMultiTypes().size() - 1) continue;
                this.write(" | ");
            }
            this.write(" " + parameter.getSimpleName());
        } else {
            this.scan(parameter);
        }
        this.write(") ");
        this.scan(catchBlock.getBody());
    }

    public DefaultJavaPrettyPrinter writeExtendsClause(CtClass<?> c) {
        if (c.getSuperclass() != null) {
            this.write(" extends ");
            this.scan(c.getSuperclass());
        }
        return this;
    }

    public DefaultJavaPrettyPrinter writeImplementsClause(CtType<?> t) {
        if (t.getSuperInterfaces().size() > 0) {
            this.write(" implements ");
            for (CtTypeReference<?> ref : t.getSuperInterfaces()) {
                this.scan(ref);
                this.write(" , ");
            }
            this.removeLastChar();
        }
        return this;
    }

    @Override
    public <T> void visitCtClass(CtClass<T> ctClass) {
        SortedList<CtElement> lst = new SortedList<CtElement>(new CtLineElementComparator());
        if (ctClass.getSimpleName() != null && !ctClass.isAnonymous()) {
            this.visitCtType(ctClass);
            this.write("class " + ctClass.getSimpleName());
            this.writeFormalTypeParameters(ctClass.getFormalTypeParameters());
            this.writeExtendsClause(ctClass);
            this.writeImplementsClause(ctClass);
            for (CtConstructor<T> c : ctClass.getConstructors()) {
                if (c.isImplicit()) continue;
                lst.add(c);
            }
        }
        lst.addAll(ctClass.getAnonymousExecutables());
        lst.addAll(ctClass.getNestedTypes());
        lst.addAll(ctClass.getFields());
        lst.addAll(ctClass.getMethods());
        if ((ctClass.getSimpleName() == null || ctClass.getSimpleName().isEmpty()) && ctClass.getParent() != null && ctClass.getParent() instanceof CtNewClass) {
            this.context.currentThis.push(((CtNewClass)ctClass.getParent()).getType());
        } else {
            this.context.currentThis.push((CtTypeReference<?>)ctClass.getReference());
        }
        this.write(" {").incTab();
        for (CtElement el : lst) {
            this.writeln().writeTabs().scan(el);
            if (this.env.isPreserveLineNumbers()) continue;
            this.writeln();
        }
        this.decTab().writeTabs().write("}");
        this.context.currentThis.pop();
    }

    @Override
    public <T> void visitCtConditional(CtConditional<T> conditional) {
        this.enterCtExpression(conditional);
        this.scan(conditional.getCondition());
        this.write(" ? ");
        this.scan(conditional.getThenExpression());
        this.write(" : ");
        boolean isAssign = false;
        isAssign = conditional.getElseExpression() instanceof CtAssignment;
        if (isAssign) {
            this.write("(");
        }
        this.scan(conditional.getElseExpression());
        if (isAssign) {
            this.write(")");
        }
        this.exitCtExpression(conditional);
    }

    @Override
    public <T> void visitCtConstructor(CtConstructor<T> c) {
        this.visitCtNamedElement(c);
        this.writeModifiers(c);
        this.writeFormalTypeParameters(c.getFormalTypeParameters());
        this.write(c.getDeclaringType().getSimpleName());
        this.write("(");
        if (c.getParameters().size() > 0) {
            for (CtParameter<?> ctParameter : c.getParameters()) {
                this.visitCtParameter(ctParameter);
                this.write(" ,");
            }
            this.removeLastChar();
        }
        this.write(") ");
        if (c.getThrownTypes() != null && c.getThrownTypes().size() > 0) {
            this.write("throws ");
            for (CtTypeReference ctTypeReference : c.getThrownTypes()) {
                this.scan(ctTypeReference);
                this.write(" , ");
            }
            this.removeLastChar();
            this.write(" ");
        }
        this.scan(c.getBody());
    }

    @Override
    public void visitCtContinue(CtContinue continueStatement) {
        this.enterCtStatement(continueStatement);
        this.write("continue");
        if (continueStatement.getTargetLabel() != null) {
            this.write(" " + continueStatement.getTargetLabel());
        }
    }

    @Override
    public void visitCtDo(CtDo doLoop) {
        this.enterCtStatement(doLoop);
        this.write("do ");
        this.writeStatement(doLoop.getBody());
        this.write(" while (");
        this.scan(doLoop.getLoopingExpression());
        this.write(" )");
    }

    private void writeEnumField(CtField<?> f) {
        this.visitCtNamedElement(f);
        this.write(f.getSimpleName());
        if (f.getDefaultExpression() != null) {
            CtConstructorCall constructorCall = (CtConstructorCall)f.getDefaultExpression();
            if (constructorCall.getArguments().size() > 0) {
                this.write("(");
                boolean first = true;
                for (CtExpression<?> ctexpr : constructorCall.getArguments()) {
                    if (first) {
                        first = false;
                    } else {
                        this.write(",");
                    }
                    this.scan(ctexpr);
                }
                this.write(")");
            }
            if (constructorCall instanceof CtNewClass) {
                this.scan(((CtNewClass)constructorCall).getAnonymousClass());
            }
        }
    }

    @Override
    public <T extends Enum<?>> void visitCtEnum(CtEnum<T> ctEnum) {
        this.visitCtType(ctEnum);
        this.write("enum " + ctEnum.getSimpleName());
        if (ctEnum.getSuperInterfaces().size() > 0) {
            this.write(" implements ");
            for (CtTypeReference<?> ref : ctEnum.getSuperInterfaces()) {
                this.scan(ref);
                this.write(" , ");
            }
            this.removeLastChar();
        }
        this.context.currentThis.push((CtTypeReference<?>)ctEnum.getReference());
        this.write(" {").incTab().writeln();
        ArrayList l1 = new ArrayList();
        ArrayList l2 = new ArrayList();
        for (CtField<?> ctField : ctEnum.getFields()) {
            if (ctField.getType() == null) {
                l1.add(ctField);
                continue;
            }
            l2.add(ctField);
        }
        if (l1.size() > 0) {
            for (CtField<Object> ctField : l1) {
                this.writeEnumField(ctField);
                this.write(", ");
            }
            this.removeLastChar();
            this.write(";");
        }
        for (CtField<Object> ctField : l2) {
            this.writeln().writeTabs().scan(ctField);
        }
        for (CtConstructor ctConstructor : ctEnum.getConstructors()) {
            if (ctConstructor.isImplicit()) continue;
            this.writeln().writeTabs().scan(ctConstructor);
        }
        SortedList<CtElement> lst = new SortedList<CtElement>(new CtLineElementComparator());
        lst.addAll(ctEnum.getAnonymousExecutables());
        lst.addAll(ctEnum.getNestedTypes());
        lst.addAll(ctEnum.getMethods());
        for (CtElement el : lst) {
            this.writeln().writeTabs().scan(el);
            if (this.env.isPreserveLineNumbers()) continue;
            this.writeln();
        }
        this.decTab().writeTabs().write("}");
        this.context.currentThis.pop();
    }

    @Override
    public <T> void visitCtExecutableReference(CtExecutableReference<T> reference) {
        SignaturePrinter pr = new SignaturePrinter();
        pr.scan(reference);
        this.write(pr.getSignature());
    }

    @Override
    public <T> void visitCtField(CtField<T> f) {
        this.visitCtNamedElement(f);
        this.writeModifiers(f);
        this.scan(f.getType());
        this.write(" ");
        this.write(f.getSimpleName());
        if (!f.isParentInitialized() || !CtAnnotationType.class.isAssignableFrom(f.getParent().getClass()) || f.getModifiers().contains((Object)ModifierKind.STATIC)) {
            if (f.getDefaultExpression() != null) {
                this.write(" = ");
                this.scan(f.getDefaultExpression());
            }
        } else {
            this.write("()");
            if (f.getDefaultExpression() != null) {
                this.write(" default ");
                this.scan(f.getDefaultExpression());
            }
        }
        this.write(";");
    }

    @Override
    public <T> void visitCtFieldAccess(CtFieldAccess<T> f) {
        this.enterCtExpression(f);
        if (f.getTarget() != null) {
            this.scan((CtElement)f.getTarget());
            this.write(".");
            this.context.ignoreStaticAccess = true;
        }
        this.context.ignoreGenerics = true;
        this.scan(f.getVariable());
        this.context.ignoreGenerics = false;
        this.context.ignoreStaticAccess = false;
        this.exitCtExpression(f);
    }

    @Override
    public <T> void visitCtFieldRead(CtFieldRead<T> fieldRead) {
        this.visitCtFieldAccess(fieldRead);
    }

    @Override
    public <T> void visitCtFieldWrite(CtFieldWrite<T> fieldWrite) {
        this.visitCtFieldAccess(fieldWrite);
    }

    @Override
    public <T> void visitCtThisAccess(CtThisAccess<T> thisAccess) {
        this.enterCtExpression(thisAccess);
        if (thisAccess.getTarget() != null && thisAccess.isImplicit()) {
            throw new RuntimeException("inconsistent this definition");
        }
        if (thisAccess.getTarget() != null) {
            this.visitCtTypeReferenceWithoutGenerics(thisAccess.getType());
            this.write(".");
        }
        if (!thisAccess.isImplicit()) {
            this.write("this");
        }
        this.exitCtExpression(thisAccess);
    }

    @Override
    public <T> void visitCtSuperAccess(CtSuperAccess<T> f) {
        this.enterCtExpression(f);
        if (f.getTarget() != null) {
            this.scan((CtElement)f.getTarget());
            this.write(".");
        }
        this.write("super");
        this.exitCtExpression(f);
    }

    @Override
    public <T> void visitCtAnnotationFieldAccess(CtAnnotationFieldAccess<T> annotationFieldAccess) {
        this.enterCtExpression(annotationFieldAccess);
        if (annotationFieldAccess.getTarget() != null) {
            this.scan((CtElement)annotationFieldAccess.getTarget());
            this.write(".");
            this.context.ignoreStaticAccess = true;
        }
        this.context.ignoreGenerics = true;
        this.scan(annotationFieldAccess.getVariable());
        this.write("()");
        this.context.ignoreGenerics = false;
        this.context.ignoreStaticAccess = false;
        this.exitCtExpression(annotationFieldAccess);
    }

    @Override
    public <T> void visitCtFieldReference(CtFieldReference<T> reference) {
        boolean isStatic = false;
        isStatic = reference.getSimpleName().equals("class") ? true : (reference.getSimpleName().equals("super") ? false : reference.isStatic());
        boolean printType = true;
        if (reference.isFinal() && reference.isStatic()) {
            CtTypeReference<?> declTypeRef = reference.getDeclaringType();
            if (this.context.currentTopLevel != null) {
                CtReference ref2 = this.context.currentThis != null && this.context.currentThis.size() > 0 ? (CtTypeReference)this.context.currentThis.lastElement() : this.context.currentTopLevel.getReference();
                printType = !"".equals(declTypeRef.getSimpleName()) && !declTypeRef.equals(ref2);
            } else {
                boolean bl = printType = !"".equals(declTypeRef.getSimpleName());
            }
        }
        if (isStatic && printType && !this.context.ignoreStaticAccess) {
            this.context.ignoreGenerics = true;
            this.scan(reference.getDeclaringType());
            this.context.ignoreGenerics = false;
            this.write(".");
        }
        this.write(reference.getSimpleName());
    }

    @Override
    public void visitCtFor(CtFor forLoop) {
        this.enterCtStatement(forLoop);
        this.write("for (");
        List<CtStatement> st = forLoop.getForInit();
        if (st.size() > 0) {
            this.scan(st.get(0));
        }
        if (st.size() > 1) {
            this.context.noTypeDecl = true;
            for (int i = 1; i < st.size(); ++i) {
                this.write(", ");
                this.scan(st.get(i));
            }
            this.context.noTypeDecl = false;
        }
        this.write(" ; ");
        this.scan(forLoop.getExpression());
        this.write(" ; ");
        for (CtStatement s : forLoop.getForUpdate()) {
            this.scan(s);
            this.write(" , ");
        }
        if (forLoop.getForUpdate().size() > 0) {
            this.removeLastChar();
        }
        this.write(")");
        if (forLoop.getBody() instanceof CtBlock) {
            this.write(" ");
            this.scan(forLoop.getBody());
        } else {
            this.incTab().writeln().writeTabs();
            this.writeStatement(forLoop.getBody());
            this.decTab();
        }
    }

    @Override
    public void visitCtForEach(CtForEach foreach) {
        this.enterCtStatement(foreach);
        this.write("for (");
        this.scan(foreach.getVariable());
        this.write(" : ");
        this.scan(foreach.getExpression());
        this.write(")");
        if (foreach.getBody() instanceof CtBlock) {
            this.write(" ");
            this.scan(foreach.getBody());
        } else {
            this.incTab().writeln().writeTabs();
            this.writeStatement(foreach.getBody());
            this.decTab();
        }
    }

    @Override
    public void visitCtIf(CtIf ifElement) {
        this.enterCtStatement(ifElement);
        this.write("if (");
        this.scan(ifElement.getCondition());
        this.write(")");
        if (ifElement.getThenStatement() instanceof CtBlock) {
            this.write(" ");
            this.scan((CtElement)ifElement.getThenStatement());
            this.write(" ");
        } else {
            this.incTab().writeln().writeTabs();
            this.writeStatement((CtStatement)ifElement.getThenStatement());
            if (this.env.isPreserveLineNumbers()) {
                this.decTab();
            } else {
                this.decTab().writeln().writeTabs();
            }
        }
        if (ifElement.getElseStatement() != null) {
            this.write("else");
            if (ifElement.getElseStatement() instanceof CtIf) {
                this.write(" ");
                this.scan((CtElement)ifElement.getElseStatement());
            } else if (ifElement.getElseStatement() instanceof CtBlock) {
                this.write(" ");
                this.scan((CtElement)ifElement.getElseStatement());
            } else {
                this.incTab().writeln().writeTabs();
                this.writeStatement((CtStatement)ifElement.getElseStatement());
                if (this.env.isPreserveLineNumbers()) {
                    this.decTab();
                } else {
                    this.decTab().writeln().writeTabs();
                }
            }
        }
    }

    @Override
    public <T> void visitCtInterface(CtInterface<T> intrface) {
        this.visitCtType(intrface);
        this.write("interface " + intrface.getSimpleName());
        if (intrface.getFormalTypeParameters() != null) {
            this.writeFormalTypeParameters(intrface.getFormalTypeParameters());
        }
        if (intrface.getSuperInterfaces().size() > 0) {
            this.write(" extends ");
            for (CtTypeReference<?> ref : intrface.getSuperInterfaces()) {
                this.scan(ref);
                this.write(" , ");
            }
            this.removeLastChar();
        }
        this.write(" {").incTab();
        SortedList<CtElement> lst = new SortedList<CtElement>(new CtLineElementComparator());
        lst.addAll(intrface.getNestedTypes());
        lst.addAll(intrface.getFields());
        lst.addAll(intrface.getMethods());
        for (CtElement e : lst) {
            this.writeln().writeTabs().scan(e);
            if (this.env.isPreserveLineNumbers()) continue;
            this.writeln();
        }
        this.decTab().writeTabs().write("}");
    }

    @Override
    public <T> void visitCtInvocation(CtInvocation<T> invocation) {
        this.enterCtStatement(invocation);
        this.enterCtExpression(invocation);
        if (invocation.getExecutable().isConstructor()) {
            this.writeActualTypeArguments(invocation.getExecutable());
            CtType parentType = invocation.getParent(CtType.class);
            if (parentType != null && parentType.getQualifiedName() != null && parentType.getQualifiedName().equals(invocation.getExecutable().getDeclaringType().getQualifiedName())) {
                this.write("this");
            } else {
                if (invocation.getTarget() != null) {
                    this.write(invocation.getTarget().getSignature() + '.');
                }
                this.write("super");
            }
        } else {
            if (invocation.getExecutable().isStatic() && invocation.getExecutable().getDeclaringType() != null) {
                CtTypeReference<?> type = invocation.getExecutable().getDeclaringType();
                this.context.ignoreGenerics = true;
                this.scan(type);
                this.context.ignoreGenerics = false;
                this.write(".");
            } else if (invocation.getTarget() != null) {
                this.context.enterTarget();
                this.scan((CtElement)invocation.getTarget());
                this.context.exitTarget();
                this.write(".");
            } else if (invocation.getExecutable().getActualTypeArguments() != null && invocation.getExecutable().getActualTypeArguments().size() > 0) {
                this.write("this.");
            }
            this.writeActualTypeArguments(invocation.getExecutable());
            if (this.env.isPreserveLineNumbers()) {
                this.adjustPosition(invocation);
            }
            this.write(invocation.getExecutable().getSimpleName());
        }
        this.write("(");
        boolean remove = false;
        for (CtExpression<?> e : invocation.getArguments()) {
            this.scan(e);
            this.write(", ");
            remove = true;
        }
        if (remove) {
            this.removeLastChar();
        }
        this.write(")");
        this.exitCtExpression(invocation);
    }

    public static String byteToHex(byte b) {
        char[] hexDigit = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
        char[] array = new char[]{hexDigit[b >> 4 & 0xF], hexDigit[b & 0xF]};
        return new String(array);
    }

    public static String charToHex(char c) {
        byte hi = (byte)(c >>> 8);
        byte lo = (byte)(c & 0xFF);
        return DefaultJavaPrettyPrinter.byteToHex(hi) + DefaultJavaPrettyPrinter.byteToHex(lo);
    }

    private void writeStringLiteral(String value) {
        block10: for (int i = 0; i < value.length(); ++i) {
            switch (value.charAt(i)) {
                case '\b': {
                    this.write("\\b");
                    continue block10;
                }
                case '\t': {
                    this.write("\\t");
                    continue block10;
                }
                case '\n': {
                    this.write("\\n");
                    continue block10;
                }
                case '\f': {
                    this.write("\\f");
                    continue block10;
                }
                case '\r': {
                    this.write("\\r");
                    continue block10;
                }
                case '\"': {
                    this.write("\\\"");
                    continue block10;
                }
                case '\'': {
                    this.write("\\'");
                    continue block10;
                }
                case '\\': {
                    this.write("\\\\");
                    continue block10;
                }
                default: {
                    this.write(value.charAt(i));
                }
            }
        }
    }

    @Override
    public <T> void visitCtLiteral(CtLiteral<T> literal) {
        this.enterCtExpression(literal);
        if (literal.getValue() == null) {
            this.write("null");
        } else if (literal.getValue() instanceof Long) {
            this.write(literal.getValue() + "L");
        } else if (literal.getValue() instanceof Float) {
            this.write(literal.getValue() + "F");
        } else if (literal.getValue() instanceof Character) {
            this.write("'");
            this.writeStringLiteral(new String(new char[]{((Character)literal.getValue()).charValue()}));
            this.write("'");
        } else if (literal.getValue() instanceof String) {
            this.write('\"');
            this.writeStringLiteral((String)literal.getValue());
            this.write('\"');
        } else if (literal.getValue() instanceof Class) {
            this.write(((Class)literal.getValue()).getName());
        } else if (literal.getValue() instanceof CtReference) {
            this.scan((CtReference)literal.getValue());
        } else {
            this.write(literal.getValue().toString());
        }
        this.exitCtExpression(literal);
    }

    public <T> DefaultJavaPrettyPrinter writeLocalVariable(CtLocalVariable<T> localVariable) {
        if (this.env.isPreserveLineNumbers()) {
            this.adjustPosition(localVariable);
        }
        if (!this.context.noTypeDecl) {
            this.writeModifiers(localVariable);
            this.scan(localVariable.getType());
            this.write(" ");
        }
        this.write(localVariable.getSimpleName());
        if (localVariable.getDefaultExpression() != null) {
            this.write(" = ");
            this.scan(localVariable.getDefaultExpression());
        }
        return this;
    }

    @Override
    public <T> void visitCtLocalVariable(CtLocalVariable<T> localVariable) {
        this.enterCtStatement(localVariable);
        this.writeLocalVariable(localVariable);
    }

    @Override
    public <T> void visitCtLocalVariableReference(CtLocalVariableReference<T> reference) {
        this.write(reference.getSimpleName());
    }

    @Override
    public <T> void visitCtCatchVariable(CtCatchVariable<T> catchVariable) {
        if (this.env.isPreserveLineNumbers()) {
            this.adjustPosition(catchVariable);
        }
        if (!this.context.noTypeDecl) {
            this.writeModifiers(catchVariable);
            this.scan(catchVariable.getType());
            this.write(" ");
        }
        this.write(catchVariable.getSimpleName());
    }

    @Override
    public <T> void visitCtCatchVariableReference(CtCatchVariableReference<T> reference) {
        this.write(reference.getSimpleName());
    }

    public DefaultJavaPrettyPrinter writeTypeReference(CtTypeReference<?> t) {
        this.scan(t);
        return this;
    }

    public DefaultJavaPrettyPrinter writeExecutableParameters(CtExecutable<?> e) {
        if (e.getParameters().size() > 0) {
            for (CtParameter<?> p : e.getParameters()) {
                this.scan(p);
                this.write(", ");
            }
            this.removeLastChar();
        }
        return this;
    }

    public DefaultJavaPrettyPrinter writeThrowsClause(CtExecutable<?> e) {
        if (e.getThrownTypes().size() > 0) {
            this.write(" throws ");
            for (CtTypeReference<Throwable> ref : e.getThrownTypes()) {
                this.scan(ref);
                this.write(", ");
            }
            this.removeLastChar();
        }
        return this;
    }

    @Override
    public <T> void visitCtMethod(CtMethod<T> m) {
        this.visitCtNamedElement(m);
        this.writeModifiers(m);
        if (m.isDefaultMethod()) {
            this.write("default ");
        }
        this.writeFormalTypeParameters(m.getFormalTypeParameters());
        this.scan(m.getType());
        this.write(" ");
        this.write(m.getSimpleName());
        this.write("(");
        this.writeExecutableParameters(m);
        this.write(")");
        this.writeThrowsClause(m);
        if (m.getBody() != null) {
            this.write(" ");
            this.scan(m.getBody());
            if (m.getBody().getPosition() != null) {
                if (m.getBody().getPosition().getCompilationUnit() == this.sourceCompilationUnit) {
                    if (m.getBody().getStatements().isEmpty() || !(m.getBody().getStatements().get(m.getBody().getStatements().size() - 1) instanceof CtReturn)) {
                        this.lineNumberMapping.put(this.line, m.getBody().getPosition().getEndLine());
                    }
                } else {
                    this.undefLine(this.line);
                }
            } else {
                this.undefLine(this.line);
            }
        } else {
            this.write(";");
        }
    }

    @Override
    public void reset() {
        this.sbf = new StringBuffer();
    }

    public DefaultJavaPrettyPrinter writeModifiers(CtModifiable m) {
        for (ModifierKind mod : m.getModifiers()) {
            this.write(mod.toString() + " ");
        }
        return this;
    }

    public void visitCtNamedElement(CtNamedElement e) {
        if (!this.env.isPreserveLineNumbers() && this.env.isGenerateJavadoc() && e.getDocComment() != null) {
            this.write("/** ").writeln().writeTabs();
            String[] lines = e.getDocComment().split("\n");
            for (int i = 0; i < lines.length; ++i) {
                String com = lines[i].trim();
                if ("".equals(com) && (i == 0 || i == lines.length - 1)) continue;
                if (com.startsWith("//")) {
                    this.write(com).writeln().writeTabs();
                    continue;
                }
                this.write(" * " + com).writeln().writeTabs();
            }
            this.write(" */").writeln();
        }
        this.writeAnnotations(e);
        if (this.env.isPreserveLineNumbers()) {
            this.adjustPosition(e);
        }
    }

    @Override
    public <T> void visitCtNewArray(CtNewArray<T> newArray) {
        this.enterCtExpression(newArray);
        if (newArray.getParent(CtAnnotationType.class) == null && newArray.getParent(CtAnnotation.class) == null) {
            CtTypeReference<Object> ref = newArray.getType();
            if (ref != null) {
                this.write("new ");
            }
            this.context.skipArray = true;
            this.scan(ref);
            this.context.skipArray = false;
            int i = 0;
            while (ref instanceof CtArrayTypeReference) {
                this.write("[");
                if (newArray.getDimensionExpressions().size() > i) {
                    this.scan(newArray.getDimensionExpressions().get(i));
                }
                this.write("]");
                ref = ((CtArrayTypeReference)ref).getComponentType();
                ++i;
            }
        }
        if (newArray.getDimensionExpressions().size() == 0) {
            this.write("{ ");
            for (CtExpression<?> e : newArray.getElements()) {
                this.scan(e);
                this.write(" , ");
            }
            if (newArray.getElements().size() > 0) {
                this.removeLastChar();
            }
            this.write(" }");
        }
        this.exitCtExpression(newArray);
    }

    @Override
    public <T> void visitCtConstructorCall(CtConstructorCall<T> ctConstructorCall) {
        this.enterCtStatement(ctConstructorCall);
        this.enterCtExpression(ctConstructorCall);
        if (ctConstructorCall.getTarget() != null) {
            this.scan((CtElement)ctConstructorCall.getTarget()).write(".");
            this.context.ignoreEnclosingClass = true;
        }
        if (this.getTopLevelType(ctConstructorCall).getReference().equals(ctConstructorCall.getType().getDeclaringType()) && ctConstructorCall.getType().getDeclaringType().getActualTypeArguments().size() > 0) {
            this.context.ignoreEnclosingClass = true;
        }
        this.write("new ");
        if (ctConstructorCall.getActualTypeArguments().size() > 0) {
            this.writeActualTypeArguments(ctConstructorCall);
        }
        this.scan(ctConstructorCall.getType());
        this.context.ignoreEnclosingClass = false;
        this.write("(");
        boolean remove = false;
        for (CtCodeElement ctCodeElement : ctConstructorCall.getArguments()) {
            this.scan(ctCodeElement);
            this.write(" , ");
            remove = true;
        }
        if (remove) {
            this.removeLastChar();
        }
        this.write(")");
        this.exitCtExpression(ctConstructorCall);
    }

    private CtType<?> getTopLevelType(CtElement e) {
        CtType parent = e.getParent(CtType.class);
        if (parent == null && this instanceof CtType) {
            return (CtType)((Object)this);
        }
        return this.getTypeParent(parent);
    }

    private CtType<?> getTypeParent(CtType<?> parent) {
        CtType typeParent = parent.getParent(CtType.class);
        if (typeParent == null) {
            return parent;
        }
        return this.getTypeParent(typeParent);
    }

    @Override
    public <T> void visitCtNewClass(CtNewClass<T> newClass) {
        this.enterCtStatement(newClass);
        this.enterCtExpression(newClass);
        if (newClass.getTarget() != null) {
            this.scan((CtElement)newClass.getTarget()).write(".");
        }
        this.write("new ");
        if (newClass.getAnonymousClass().getSuperclass() != null) {
            this.scan(newClass.getAnonymousClass().getSuperclass());
        } else if (newClass.getAnonymousClass().getSuperInterfaces().size() > 0) {
            for (CtTypeReference ctTypeReference : newClass.getAnonymousClass().getSuperInterfaces()) {
                this.scan(ctTypeReference);
            }
        }
        this.write("(");
        for (CtExpression ctExpression : newClass.getArguments()) {
            this.scan(ctExpression);
            this.write(", ");
        }
        if (newClass.getArguments().size() > 0) {
            this.removeLastChar();
        }
        this.write(")");
        this.scan(newClass.getAnonymousClass());
        this.exitCtExpression(newClass);
    }

    @Override
    public <T> void visitCtLambda(CtLambda<T> lambda) {
        this.enterCtExpression(lambda);
        this.write("(");
        if (lambda.getParameters().size() > 0) {
            for (CtParameter<?> parameter : lambda.getParameters()) {
                this.scan(parameter);
                this.write(",");
            }
            this.removeLastChar();
        }
        this.write(") -> ");
        if (lambda.getBody() != null) {
            this.scan(lambda.getBody());
        } else {
            this.scan(lambda.getExpression());
        }
        this.exitCtExpression(lambda);
    }

    @Override
    public <T, E extends CtExpression<?>> void visitCtExecutableReferenceExpression(CtExecutableReferenceExpression<T, E> expression) {
        this.enterCtExpression(expression);
        this.scan((CtElement)expression.getTarget());
        this.write("::");
        if (expression.getExecutable().isConstructor()) {
            this.write("new");
        } else {
            this.write(expression.getExecutable().getSimpleName());
        }
        this.exitCtExpression(expression);
    }

    @Override
    public <T, A extends T> void visitCtOperatorAssignment(CtOperatorAssignment<T, A> assignment) {
        this.enterCtStatement(assignment);
        this.enterCtExpression(assignment);
        this.scan(assignment.getAssigned());
        this.write(" ");
        this.writeOperator(assignment.getKind());
        this.write("= ");
        this.scan(assignment.getAssignment());
        this.exitCtExpression(assignment);
    }

    @Override
    public void visitCtPackage(CtPackage ctPackage) {
        if (!ctPackage.getQualifiedName().equals("unnamed package")) {
            this.write("package " + ctPackage.getQualifiedName() + ";");
        } else {
            this.write("// default package (CtPackage.TOP_LEVEL_PACKAGE_NAME in Spoon= unnamed package)\n");
        }
    }

    @Override
    public void visitCtPackageReference(CtPackageReference reference) {
        this.write(reference.getSimpleName());
    }

    @Override
    public <T> void visitCtParameter(CtParameter<T> parameter) {
        this.writeAnnotations(parameter);
        this.writeModifiers(parameter);
        if (parameter.isVarArgs()) {
            this.scan(((CtArrayTypeReference)parameter.getType()).getComponentType());
            this.write("...");
        } else {
            this.scan(parameter.getType());
        }
        this.write(" ");
        this.write(parameter.getSimpleName());
    }

    @Override
    public <T> void visitCtParameterReference(CtParameterReference<T> reference) {
        this.write(reference.getSimpleName());
    }

    @Override
    public <R> void visitCtReturn(CtReturn<R> returnStatement) {
        this.enterCtStatement(returnStatement);
        this.write("return ");
        this.scan(returnStatement.getReturnedExpression());
    }

    <T> void visitCtType(CtType<T> type) {
        this.mapLine(this.line, type);
        if (type.isTopLevel()) {
            this.context.currentTopLevel = type;
        }
        this.visitCtNamedElement(type);
        this.writeModifiers(type);
    }

    @Override
    public <R> void visitCtStatementList(CtStatementList statements) {
        for (CtStatement s : statements.getStatements()) {
            this.scan(s);
        }
    }

    public <E> void visitCtSwitch(CtSwitch<E> switchStatement) {
        this.enterCtStatement(switchStatement);
        this.write("switch (");
        this.scan(switchStatement.getSelector());
        this.write(") {").incTab();
        for (CtCase<E> c : switchStatement.getCases()) {
            this.writeln().writeTabs().scan(c);
        }
        if (this.env.isPreserveLineNumbers()) {
            this.decTab().write("}");
        } else {
            this.decTab().writeln().writeTabs().write("}");
        }
    }

    @Override
    public void visitCtSynchronized(CtSynchronized synchro) {
        this.enterCtStatement(synchro);
        this.write("synchronized");
        if (synchro.getExpression() != null) {
            this.write("(");
            this.scan(synchro.getExpression());
            this.write(") ");
        }
        this.scan(synchro.getBlock());
    }

    @Override
    public void visitCtThrow(CtThrow throwStatement) {
        this.enterCtStatement(throwStatement);
        this.write("throw ");
        this.scan(throwStatement.getThrownExpression());
    }

    @Override
    public void visitCtTry(CtTry tryBlock) {
        this.enterCtStatement(tryBlock);
        this.write("try ");
        this.scan(tryBlock.getBody());
        for (CtCatch c : tryBlock.getCatchers()) {
            this.scan(c);
        }
        if (tryBlock.getFinalizer() != null) {
            this.write(" finally ");
            this.scan(tryBlock.getFinalizer());
        }
    }

    @Override
    public void visitCtTryWithResource(CtTryWithResource tryWithResource) {
        this.enterCtStatement(tryWithResource);
        this.write("try ");
        if (tryWithResource.getResources() != null && !tryWithResource.getResources().isEmpty()) {
            this.write("(");
            for (CtLocalVariable ctLocalVariable : tryWithResource.getResources()) {
                this.scan(ctLocalVariable);
                this.write(";");
            }
            this.removeLastChar();
            this.write(") ");
        }
        this.scan(tryWithResource.getBody());
        for (CtCatch ctCatch : tryWithResource.getCatchers()) {
            this.scan(ctCatch);
        }
        if (tryWithResource.getFinalizer() != null) {
            this.write(" finally ");
            this.scan(tryWithResource.getFinalizer());
        }
    }

    @Override
    public void visitCtTypeParameter(CtTypeParameter typeParameter) {
        this.write(typeParameter.getSimpleName());
        if (!typeParameter.getBounds().isEmpty()) {
            this.write(" extends ");
            for (CtTypeReference<?> ref : typeParameter.getBounds()) {
                this.scan(ref);
                this.write(" & ");
            }
            this.removeLastChar();
        }
    }

    @Override
    public void visitCtTypeParameterReference(CtTypeParameterReference ref) {
        this.printTypeAnnotations(ref);
        if (this.importsContext.isImported(ref)) {
            this.write(ref.getSimpleName());
        } else {
            this.write(ref.getQualifiedName());
        }
        if (!(this.context.isInvocation && !"?".equals(ref.getSimpleName()) || ref.getBounds() == null || ref.getBounds().isEmpty() || ref.getBounds().size() == 1 && "java.lang.Object".equals(ref.getBounds().get(0).getQualifiedName()))) {
            if (ref.isUpper()) {
                this.write(" extends ");
            } else {
                this.write(" super ");
            }
            for (CtTypeReference<?> b : ref.getBounds()) {
                this.scan(b);
                this.write(" & ");
            }
            this.removeLastChar();
        }
    }

    @Override
    public <T> void visitCtTypeReference(CtTypeReference<T> ref) {
        if (ref.isPrimitive()) {
            this.write(ref.getSimpleName());
            return;
        }
        if (this.importsContext.isImported(ref) && ref.getPackage() != null) {
            this.printTypeAnnotations(ref);
            this.write(ref.getSimpleName());
        } else if (ref.getDeclaringType() != null) {
            if ((!this.context.currentThis.contains(ref.getDeclaringType()) || ref.getModifiers().contains((Object)ModifierKind.STATIC) || this.hasDeclaringTypeWithGenerics(ref)) && !this.context.ignoreEnclosingClass) {
                boolean ign = this.context.ignoreGenerics;
                this.context.ignoreGenerics = false;
                this.scan(ref.getDeclaringType());
                this.write(".");
                this.context.ignoreGenerics = ign;
            }
            this.write(ref.getSimpleName());
        } else {
            this.write(ref.getQualifiedName());
        }
        if (!this.context.ignoreGenerics) {
            this.writeActualTypeArguments(ref);
        }
    }

    private <T> boolean hasDeclaringTypeWithGenerics(CtTypeReference<T> reference) {
        if (reference.getActualTypeArguments().size() != 0) {
            return false;
        }
        if (reference.getDeclaration() == null) {
            return false;
        }
        if (reference.getDeclaration().getParent(CtMethod.class) != null) {
            return false;
        }
        if (reference.getDeclaringType() == null) {
            return false;
        }
        CtElement declaration = reference.getDeclaringType().getDeclaration();
        if (declaration == null) {
            return false;
        }
        if (!(declaration instanceof CtType)) {
            return false;
        }
        return ((CtType)declaration).getFormalTypeParameters().size() != 0;
    }

    @Override
    public <T> void visitCtTypeAccess(CtTypeAccess<T> typeAccess) {
        this.scan(typeAccess.getType());
    }

    public void visitCtTypeReferenceWithoutGenerics(CtTypeReference<?> ref) {
        if (ref.isPrimitive()) {
            this.write(ref.getSimpleName());
            return;
        }
        if (this.importsContext.isImported(ref) && ref.getPackage() != null) {
            this.printTypeAnnotations(ref);
            this.write(ref.getSimpleName());
        } else if (ref.getDeclaringType() != null) {
            if ((!this.context.currentThis.contains(ref.getDeclaringType()) || ref.getModifiers().contains((Object)ModifierKind.STATIC) || this.hasDeclaringTypeWithGenerics(ref)) && !this.context.ignoreEnclosingClass) {
                boolean ign = this.context.ignoreGenerics;
                this.context.ignoreGenerics = true;
                this.scan(ref.getDeclaringType());
                this.write(".");
                this.context.ignoreGenerics = ign;
            }
            this.write(ref.getSimpleName());
        } else {
            this.write(ref.getQualifiedName());
        }
    }

    @Override
    public <T> void visitCtUnaryOperator(CtUnaryOperator<T> operator) {
        this.enterCtStatement(operator);
        this.enterCtExpression(operator);
        this.preWriteUnaryOperator(operator.getKind());
        this.context.enterTarget();
        this.scan(operator.getOperand());
        this.context.exitTarget();
        this.postWriteUnaryOperator(operator.getKind());
        this.exitCtExpression(operator);
    }

    @Override
    public <T> void visitCtVariableAccess(CtVariableAccess<T> variableAccess) {
        this.enterCtExpression(variableAccess);
        this.write(variableAccess.getVariable().getSimpleName());
        this.exitCtExpression(variableAccess);
    }

    @Override
    public <T> void visitCtVariableRead(CtVariableRead<T> variableRead) {
        this.visitCtVariableAccess(variableRead);
    }

    @Override
    public <T> void visitCtVariableWrite(CtVariableWrite<T> variableWrite) {
        this.visitCtVariableAccess(variableWrite);
    }

    @Override
    public void visitCtWhile(CtWhile whileLoop) {
        this.enterCtStatement(whileLoop);
        this.write("while (");
        this.scan(whileLoop.getLoopingExpression());
        this.write(")");
        if (whileLoop.getBody() instanceof CtBlock) {
            this.write(" ");
            this.scan(whileLoop.getBody());
        } else {
            this.incTab().writeln().writeTabs();
            this.writeStatement(whileLoop.getBody());
            this.decTab();
        }
    }

    public DefaultJavaPrettyPrinter write(String s) {
        if (s != null) {
            this.sbf.append(s);
        }
        return this;
    }

    public DefaultJavaPrettyPrinter write(char c) {
        this.sbf.append(c);
        return this;
    }

    public DefaultJavaPrettyPrinter writeAnnotations(CtElement e) {
        for (CtAnnotation<? extends Annotation> a : e.getAnnotations()) {
            this.scan(a);
        }
        return this;
    }

    public DefaultJavaPrettyPrinter writeAnnotationElement(Factory factory, Object value) {
        if (value instanceof CtTypeReference) {
            this.context.ignoreGenerics = true;
            this.scan((CtTypeReference)value).write(".class");
            this.context.ignoreGenerics = false;
        } else if (value instanceof CtFieldReference) {
            this.scan(((CtFieldReference)value).getDeclaringType());
            this.write("." + ((CtFieldReference)value).getSimpleName());
        } else if (value instanceof CtReference) {
            this.scan((CtReference)value);
        } else if (value instanceof CtElement) {
            this.scan((CtElement)value);
        } else if (value instanceof String) {
            this.write("\"" + value.toString() + "\"");
        } else if (value instanceof Collection) {
            this.write("{");
            if (!((Collection)value).isEmpty()) {
                for (Object obj : (Collection)value) {
                    this.writeAnnotationElement(factory, obj);
                    this.write(" ,");
                }
                this.removeLastChar();
            }
            this.write("}");
        } else if (value instanceof Object[]) {
            this.write("{");
            if (((Object[])value).length > 0) {
                for (Object obj : (Object[])value) {
                    this.writeAnnotationElement(factory, obj);
                    this.write(" ,");
                }
                this.removeLastChar();
            }
            this.write("}");
        } else if (value instanceof Enum) {
            this.context.ignoreGenerics = true;
            this.scan(factory.Type().createReference(((Enum)value).getDeclaringClass()));
            this.context.ignoreGenerics = false;
            this.write(".");
            this.write(value.toString());
        } else {
            this.write(value.toString());
        }
        return this;
    }

    public DefaultJavaPrettyPrinter writeFormalTypeParameters(Collection<CtTypeReference<?>> params) {
        if (params == null) {
            return this;
        }
        if (params.size() > 0) {
            this.write("<");
            for (CtTypeReference<?> param : params) {
                this.scan(param);
                this.write(", ");
            }
            this.removeLastChar();
            this.write(">");
        }
        return this;
    }

    public DefaultJavaPrettyPrinter writeActualTypeArguments(CtGenericElementReference ctGenericElementReference) {
        List<CtTypeReference<?>> params = ctGenericElementReference.getActualTypeArguments();
        if (params != null && params.size() > 0) {
            this.write("<");
            boolean isImplicitTypeReference = true;
            for (CtTypeReference ctTypeReference : params) {
                if (ctTypeReference instanceof CtImplicitTypeReference) continue;
                isImplicitTypeReference = false;
                this.scan(ctTypeReference);
                this.write(", ");
            }
            if (!isImplicitTypeReference) {
                this.removeLastChar();
            }
            this.write(">");
        }
        return this;
    }

    public DefaultJavaPrettyPrinter writeHeader(List<CtType<?>> types, Collection<CtTypeReference<?>> imports) {
        if (!types.isEmpty()) {
            CtPackage pack = types.get(0).getPackage();
            this.scan(pack).writeln().writeln().writeTabs();
            if (this.env.isAutoImports()) {
                for (CtTypeReference<?> ref : imports) {
                    this.write("import " + ref.getQualifiedName() + ";").writeln().writeTabs();
                }
            }
            this.writeln().writeTabs();
        }
        return this;
    }

    public DefaultJavaPrettyPrinter writeln() {
        if (this.context.noNewLines) {
            this.sbf.append(" ");
        } else {
            this.sbf.append(LINE_SEPARATOR);
            ++this.line;
        }
        return this;
    }

    public DefaultJavaPrettyPrinter writeTabs() {
        for (int i = 0; i < this.context.nbTabs; ++i) {
            if (this.env.isUsingTabulations()) {
                this.sbf.append("\t");
                continue;
            }
            for (int j = 0; j < this.env.getTabulationSize(); ++j) {
                this.sbf.append(" ");
            }
        }
        return this;
    }

    public DefaultJavaPrettyPrinter writeOperator(BinaryOperatorKind o) {
        switch (o) {
            case OR: {
                this.write("||");
                break;
            }
            case AND: {
                this.write("&&");
                break;
            }
            case BITOR: {
                this.write("|");
                break;
            }
            case BITXOR: {
                this.write("^");
                break;
            }
            case BITAND: {
                this.write("&");
                break;
            }
            case EQ: {
                this.write("==");
                break;
            }
            case NE: {
                this.write("!=");
                break;
            }
            case LT: {
                this.write("<");
                break;
            }
            case GT: {
                this.write(">");
                break;
            }
            case LE: {
                this.write("<=");
                break;
            }
            case GE: {
                this.write(">=");
                break;
            }
            case SL: {
                this.write("<<");
                break;
            }
            case SR: {
                this.write(">>");
                break;
            }
            case USR: {
                this.write(">>>");
                break;
            }
            case PLUS: {
                this.write("+");
                break;
            }
            case MINUS: {
                this.write("-");
                break;
            }
            case MUL: {
                this.write("*");
                break;
            }
            case DIV: {
                this.write("/");
                break;
            }
            case MOD: {
                this.write("%");
                break;
            }
            case INSTANCEOF: {
                this.write("instanceof");
            }
        }
        return this;
    }

    protected void writeParameters(Collection<CtTypeReference<?>> params) {
        if (params.size() > 0) {
            this.write("(");
            for (CtTypeReference<?> param : params) {
                this.scan(param);
                this.write(", ");
            }
            this.removeLastChar();
            this.write(")");
        }
    }

    protected void writeStatement(CtStatement e) {
        this.scan(e);
        if (!(e instanceof CtBlock || e instanceof CtIf || e instanceof CtFor || e instanceof CtForEach || e instanceof CtWhile || e instanceof CtTry || e instanceof CtSwitch || e instanceof CtSynchronized || e instanceof CtClass)) {
            this.write(";");
        }
    }

    @Override
    public <T> void visitCtCodeSnippetExpression(CtCodeSnippetExpression<T> expression) {
        this.write(expression.getValue());
    }

    @Override
    public void visitCtCodeSnippetStatement(CtCodeSnippetStatement statement) {
        this.write(statement.getValue());
    }

    @Override
    public void calculate(CompilationUnit sourceCompilationUnit, List<CtType<?>> types) {
        this.sourceCompilationUnit = sourceCompilationUnit;
        Collection<CtTypeReference<?>> imports = Collections.emptyList();
        for (CtType<?> t : types) {
            imports = this.computeImports(t);
        }
        this.writeHeader(types, imports);
        for (CtType<?> t : types) {
            this.scan(t);
            this.writeln().writeln().writeTabs();
        }
    }

    @Override
    public Map<Integer, Integer> getLineNumberMapping() {
        return this.lineNumberMapping;
    }

    public PrintingContext getContext() {
        return this.context;
    }

    @Override
    public <T> void visitCtUnboundVariableReference(CtUnboundVariableReference<T> reference) {
        this.write(reference.getSimpleName());
    }

    public class PrintingContext {
        boolean noTypeDecl = false;
        Stack<CtTypeReference<?>> currentThis = new Stack();
        Stack<CtElement> elementStack = new Stack();
        CtType<?> currentTopLevel;
        boolean ignoreGenerics = false;
        int jumped = 0;
        int nbTabs = 0;
        Stack<CtExpression<?>> parenthesedExpression = new Stack();
        boolean isInvocation = false;
        boolean skipArray = false;
        boolean ignoreStaticAccess = false;
        boolean ignoreEnclosingClass = false;
        boolean noNewLines = false;

        public boolean getIgnoreGenerics() {
            return this.ignoreGenerics;
        }

        void enterTarget() {
        }

        void exitTarget() {
            if (this.jumped > 0) {
                --this.jumped;
            }
        }

        public String toString() {
            return "context.ignoreGenerics: " + DefaultJavaPrettyPrinter.this.context.ignoreGenerics + "\n";
        }
    }
}

