/*
 * Decompiled with CFR 0.152.
 */
package spoon.reflect.visitor;

import java.lang.annotation.Annotation;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import spoon.reflect.code.CtExpression;
import spoon.reflect.declaration.CtAnnotation;
import spoon.reflect.declaration.CtExecutable;
import spoon.reflect.declaration.CtGenericElement;
import spoon.reflect.declaration.CtTypeInformation;
import spoon.reflect.declaration.CtTypedElement;
import spoon.reflect.reference.CtTypeReference;
import spoon.reflect.visitor.CtInheritanceScanner;

public class TypeAnnotationVisitor
extends CtInheritanceScanner {
    private final Set<CtAnnotation<? extends Annotation>> annotations = new HashSet<CtAnnotation<? extends Annotation>>();
    private boolean isToBeProcessed;

    public TypeAnnotationVisitor(boolean isToBeProcessed) {
        this.isToBeProcessed = isToBeProcessed;
    }

    @Override
    public <T> void scanCtExpression(CtExpression<T> expression) {
        super.scanCtExpression(expression);
        if (!this.isToBeProcessed && expression.getTypeCasts().size() > 0) {
            this.isToBeProcessed = this.iterateOnTypeReference(expression.getTypeCasts());
        }
    }

    @Override
    public <R> void scanCtExecutable(CtExecutable<R> e) {
        super.scanCtExecutable(e);
        if (!this.isToBeProcessed && e.getThrownTypes().size() > 0) {
            this.isToBeProcessed = this.iterateOnTypeReference(e.getThrownTypes());
        }
    }

    @Override
    public void scanCtGenericElement(CtGenericElement e) {
        super.scanCtGenericElement(e);
        if (!this.isToBeProcessed) {
            this.isToBeProcessed = this.iterateOnTypeReference(e.getFormalTypeParameters());
        }
    }

    @Override
    public <T> void scanCtTypeInformation(CtTypeInformation typeInfo) {
        super.scanCtTypeInformation(typeInfo);
        if (!this.isToBeProcessed) {
            if (typeInfo.getSuperclass() != null) {
                boolean bl = this.isToBeProcessed = typeInfo.getSuperclass().getTypeAnnotations().size() > 0;
                if (this.isToBeProcessed) {
                    this.annotations.addAll(typeInfo.getSuperclass().getTypeAnnotations());
                }
            }
            if (typeInfo.getSuperInterfaces() != null && !this.isToBeProcessed) {
                this.isToBeProcessed = this.iterateOnTypeReference(typeInfo.getSuperInterfaces());
            }
        }
    }

    @Override
    public <T> void scanCtTypedElement(CtTypedElement<T> e) {
        super.scanCtTypedElement(e);
        if (!this.isToBeProcessed && e.getType() != null) {
            List<CtTypeReference<?>> typeArguments;
            boolean bl = this.isToBeProcessed = e.getType().getTypeAnnotations().size() > 0;
            if (this.isToBeProcessed) {
                this.annotations.addAll(e.getType().getTypeAnnotations());
            }
            if ((typeArguments = e.getType().getActualTypeArguments()).size() > 0 && !this.isToBeProcessed) {
                this.isToBeProcessed = this.iterateOnTypeReference(typeArguments);
            }
        }
    }

    private boolean iterateOnTypeReference(Iterable<CtTypeReference<?>> typeReferences) {
        boolean isToBeProcessed = false;
        for (CtTypeReference<?> ref : typeReferences) {
            isToBeProcessed = ref.getTypeAnnotations().size() > 0;
            if (!isToBeProcessed) continue;
            this.annotations.addAll(ref.getTypeAnnotations());
            break;
        }
        return isToBeProcessed;
    }

    public boolean isToBeProcessed() {
        return this.isToBeProcessed;
    }

    public Set<CtAnnotation<? extends Annotation>> getAnnotations() {
        return this.annotations;
    }
}

