/*
 * Decompiled with CFR 0.152.
 */
package spoon.support.compiler;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import spoon.Launcher;
import spoon.compiler.SpoonFile;
import spoon.compiler.SpoonFolder;
import spoon.compiler.SpoonResourceHelper;
import spoon.support.compiler.ZipFile;

public class ZipFolder
implements SpoonFolder {
    File file;
    List<SpoonFile> files;

    public ZipFolder(File file) throws IOException {
        if (!file.isFile()) {
            throw new IOException(file.getName() + " is not a valid zip file");
        }
        this.file = file;
    }

    @Override
    public List<SpoonFile> getAllFiles() {
        return this.getFiles();
    }

    @Override
    public List<SpoonFile> getAllJavaFiles() {
        ArrayList<SpoonFile> files = new ArrayList<SpoonFile>();
        for (SpoonFile f : this.getFiles()) {
            if (!f.isJava()) continue;
            files.add(f);
        }
        return files;
    }

    @Override
    public List<SpoonFile> getFiles() {
        if (this.files == null) {
            this.files = new ArrayList<SpoonFile>();
            ZipInputStream zipInput = null;
            try {
                ZipEntry entry;
                zipInput = new ZipInputStream(new BufferedInputStream(new FileInputStream(this.file)));
                while ((entry = zipInput.getNextEntry()) != null) {
                    int count;
                    int buffer = 2048;
                    ByteArrayOutputStream output = new ByteArrayOutputStream(2048);
                    byte[] data = new byte[2048];
                    while ((count = zipInput.read(data, 0, 2048)) != -1) {
                        output.write(data, 0, count);
                    }
                    output.flush();
                    output.close();
                    this.files.add(new ZipFile(this, entry.getName(), output.toByteArray()));
                }
                zipInput.close();
            }
            catch (Exception e) {
                Launcher.LOGGER.error((Object)e.getMessage(), (Throwable)e);
            }
        }
        return this.files;
    }

    @Override
    public String getName() {
        return this.file.getName();
    }

    @Override
    public SpoonFolder getParent() {
        try {
            return SpoonResourceHelper.createFolder(this.file.getParentFile());
        }
        catch (FileNotFoundException e) {
            Launcher.LOGGER.error((Object)e.getMessage(), (Throwable)e);
            return null;
        }
    }

    @Override
    public List<SpoonFolder> getSubFolders() {
        return new ArrayList<SpoonFolder>(0);
    }

    @Override
    public boolean isFile() {
        return false;
    }

    public String toString() {
        return this.getPath();
    }

    @Override
    public String getPath() {
        try {
            return this.file.getCanonicalPath();
        }
        catch (Exception e) {
            Launcher.LOGGER.error((Object)e.getMessage(), (Throwable)e);
            return this.file.getPath();
        }
    }

    @Override
    public boolean isArchive() {
        return true;
    }

    @Override
    public File getFileSystemParent() {
        return this.file.getParentFile();
    }

    @Override
    public File toFile() {
        return this.file;
    }

    public boolean equals(Object obj) {
        return this.toString().equals(obj.toString());
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    @Override
    public void addFile(SpoonFile source) {
        throw new UnsupportedOperationException("not possible a real folder");
    }

    @Override
    public void addFolder(SpoonFolder source) {
        throw new UnsupportedOperationException("not possible a real folder");
    }

    public void extract(File destDir) {
        ZipInputStream zipInput = null;
        try {
            ZipEntry entry;
            zipInput = new ZipInputStream(new BufferedInputStream(new FileInputStream(this.file)));
            while ((entry = zipInput.getNextEntry()) != null) {
                int count;
                File f = new File(destDir + File.separator + entry.getName());
                if (entry.isDirectory()) {
                    f.mkdir();
                    continue;
                }
                int buffer = 2048;
                f.getParentFile().mkdirs();
                BufferedOutputStream output = new BufferedOutputStream(new FileOutputStream(f));
                byte[] data = new byte[2048];
                while ((count = zipInput.read(data, 0, 2048)) != -1) {
                    ((OutputStream)output).write(data, 0, count);
                }
                ((OutputStream)output).flush();
                ((OutputStream)output).close();
            }
            zipInput.close();
        }
        catch (Exception e) {
            Launcher.LOGGER.error((Object)e.getMessage(), (Throwable)e);
        }
    }
}

