/*
 * Decompiled with CFR 0.152.
 */
package spoon.support.compiler.jdt;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.log4j.Level;
import org.eclipse.jdt.core.compiler.CategorizedProblem;
import org.eclipse.jdt.internal.compiler.ASTVisitor;
import org.eclipse.jdt.internal.compiler.ast.CompilationUnitDeclaration;
import org.eclipse.jdt.internal.compiler.env.INameEnvironment;
import spoon.Launcher;
import spoon.OutputType;
import spoon.SpoonException;
import spoon.compiler.Environment;
import spoon.compiler.ModelBuildingException;
import spoon.compiler.SpoonCompiler;
import spoon.compiler.SpoonFile;
import spoon.compiler.SpoonFolder;
import spoon.compiler.SpoonResource;
import spoon.compiler.SpoonResourceHelper;
import spoon.processing.Processor;
import spoon.reflect.cu.CompilationUnit;
import spoon.reflect.declaration.CtElement;
import spoon.reflect.declaration.CtPackage;
import spoon.reflect.declaration.CtType;
import spoon.reflect.factory.Factory;
import spoon.reflect.visitor.DefaultJavaPrettyPrinter;
import spoon.reflect.visitor.PrettyPrinter;
import spoon.support.QueueProcessingManager;
import spoon.support.compiler.FileSystemFile;
import spoon.support.compiler.VirtualFolder;
import spoon.support.compiler.jdt.CompilerClassLoader;
import spoon.support.compiler.jdt.JDTBatchCompiler;
import spoon.support.compiler.jdt.JDTTreeBuilder;
import spoon.support.compiler.jdt.TreeBuilderRequestor;

public class JDTBasedSpoonCompiler
implements SpoonCompiler {
    public int javaCompliance = 7;
    private String[] templateClasspath = new String[0];
    File outputDirectory = new File("spooned");
    boolean buildOnlyOutdatedFiles = false;
    File binaryOutputDirectory;
    INameEnvironment environment = null;
    private final List<CategorizedProblem> probs = new ArrayList<CategorizedProblem>();
    public final TreeBuilderRequestor requestor = new TreeBuilderRequestor(this);
    private boolean build = false;
    SpoonFolder sources = new VirtualFolder();
    SpoonFolder templates = new VirtualFolder();
    Factory factory;
    Map<String, char[]> loadedContent = new HashMap<String, char[]>();
    List<SpoonResource> forceBuildList = new ArrayList<SpoonResource>();
    protected String encoding;

    @Override
    public void setSourceOutputDirectory(File outputDirectory) {
        this.outputDirectory = outputDirectory;
    }

    @Override
    public File getSourceOutputDirectory() {
        return this.outputDirectory;
    }

    @Override
    public void setBinaryOutputDirectory(File binaryOutputDirectory) {
        this.binaryOutputDirectory = binaryOutputDirectory;
    }

    @Override
    public File getBinaryOutputDirectory() {
        return this.binaryOutputDirectory;
    }

    public JDTBasedSpoonCompiler(Factory factory) {
        this.factory = factory;
    }

    public static void main(String[] args) throws Exception {
        Launcher main = new Launcher();
        JDTBasedSpoonCompiler comp = new JDTBasedSpoonCompiler(main.createFactory());
        comp.createBatchCompiler().printUsage();
        FileSystemFile file = new FileSystemFile(new File("./src/main/java/spoon/support/compiler/JDTCompiler.java"));
        comp.addInputSource(file);
        try {
            comp.build();
            Set<CtType<?>> types = comp.getFactory().Package().get("spoon.support.compiler").getTypes();
            for (CtType<?> type : types) {
                main.getEnvironment().debugMessage(type.toString());
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    protected JDTBatchCompiler createBatchCompiler(boolean useFactory) {
        return new JDTBatchCompiler(this, useFactory);
    }

    protected JDTBatchCompiler createBatchCompiler() {
        return this.createBatchCompiler(false);
    }

    protected void keepOutdatedFiles(List<SpoonFile> files, Collection<File> outputFiles) {
        int offset = this.outputDirectory.getAbsolutePath().length() + 1;
        ArrayList<String> relativeOutputPaths = new ArrayList<String>();
        for (File f : outputFiles) {
            relativeOutputPaths.add(f.getAbsolutePath().substring(offset));
        }
        for (SpoonFile sf : new ArrayList<SpoonFile>(files)) {
            if (this.forceBuildList.contains(sf)) continue;
            File f = sf.toFile();
            for (String s : relativeOutputPaths) {
                if (!f.getAbsolutePath().endsWith(s) || f.lastModified() > new File(this.outputDirectory, s).lastModified()) continue;
                files.remove(sf);
            }
        }
    }

    protected boolean buildSources() {
        if (this.sources.getAllJavaFiles().isEmpty()) {
            return true;
        }
        this.initInputClassLoader();
        JDTBatchCompiler batchCompiler = this.createBatchCompiler();
        ArrayList<String> args = new ArrayList<String>();
        args.add("-1." + this.javaCompliance);
        if (this.encoding != null) {
            args.add("-encoding");
            args.add(this.encoding);
        }
        args.add("-preserveAllLocals");
        args.add("-enableJavadoc");
        args.add("-noExit");
        if (this.getSourceClasspath() != null) {
            this.addClasspathToJDTArgs(args);
        } else {
            URL[] urls;
            ClassLoader currentClassLoader = Thread.currentThread().getContextClassLoader();
            if (currentClassLoader instanceof URLClassLoader && (urls = ((URLClassLoader)currentClassLoader).getURLs()) != null && urls.length > 0) {
                String classpath = ".";
                for (URL uRL : urls) {
                    classpath = classpath + File.pathSeparator + uRL.getFile();
                }
                if (classpath != null) {
                    args.add("-cp");
                    args.add(classpath);
                }
            }
        }
        args.addAll(this.toStringList(this.sources.getAllJavaFiles()));
        this.getFactory().getEnvironment().debugMessage("build args: " + args);
        batchCompiler.configure(args.toArray(new String[0]));
        List<SpoonFile> filesToBuild = this.sources.getAllJavaFiles();
        if (this.buildOnlyOutdatedFiles) {
            if (this.outputDirectory.exists()) {
                Collection outputFiles = FileUtils.listFiles((File)this.outputDirectory, (String[])new String[]{"java"}, (boolean)true);
                this.keepOutdatedFiles(filesToBuild, outputFiles);
            } else {
                this.keepOutdatedFiles(filesToBuild, new ArrayList<File>());
            }
        }
        CompilationUnitDeclaration[] units = batchCompiler.getUnits(filesToBuild);
        JDTTreeBuilder builder = new JDTTreeBuilder(this.factory);
        for (URL uRL : units) {
            uRL.traverse(builder, ((CompilationUnitDeclaration)uRL).scope);
        }
        return this.probs.size() == 0;
    }

    private Collection<? extends String> toStringList(List<SpoonFile> files) {
        ArrayList<String> res = new ArrayList<String>();
        for (SpoonFile f : files) {
            if (f.isActualFile()) {
                res.add(f.toString());
                continue;
            }
            try {
                File file = File.createTempFile(f.getName(), ".java");
                file.deleteOnExit();
                IOUtils.copy((InputStream)f.getContent(), (OutputStream)new FileOutputStream(file));
                res.add(file.toString());
            }
            catch (IOException e) {
                throw new RuntimeException(e.getMessage(), e);
            }
        }
        return res;
    }

    protected String computeTemplateClasspath() {
        return this.computeClasspath(this.getTemplateClasspath());
    }

    protected String computeJdtClassPath() {
        return this.computeClasspath(this.getSourceClasspath());
    }

    private String computeClasspath(String[] classpath) {
        if (classpath == null || classpath.length == 0) {
            return "";
        }
        StringBuilder builder = new StringBuilder();
        for (String entry : classpath) {
            builder.append(entry);
            builder.append(File.pathSeparatorChar);
        }
        return builder.toString();
    }

    protected void addClasspathToJDTArgs(List<String> args) {
        args.add("-cp");
        args.add(this.computeJdtClassPath());
    }

    protected File createTmpJavaFile(File folder) {
        File f = new File(folder, "Tmp.java");
        if (f.exists()) {
            return f;
        }
        try {
            FileUtils.writeStringToFile((File)f, (String)"class Tmp {}");
            f.deleteOnExit();
        }
        catch (Exception e) {
            Launcher.LOGGER.error((Object)e.getMessage(), (Throwable)e);
        }
        return f;
    }

    protected boolean buildTemplates() {
        if (this.templates.getAllJavaFiles().isEmpty()) {
            return true;
        }
        JDTBatchCompiler batchCompiler = this.createBatchCompiler();
        ArrayList<? extends String> args = new ArrayList<String>();
        args.add("-1." + this.javaCompliance);
        if (this.encoding != null) {
            args.add("-encoding");
            args.add(this.encoding);
        }
        args.add("-preserveAllLocals");
        args.add("-enableJavadoc");
        args.add("-noExit");
        File f = null;
        if (this.templateClasspath != null && this.templateClasspath.length > 0) {
            args.add("-cp");
            args.add(this.computeTemplateClasspath());
            for (SpoonFolder file : this.templates.getSubFolders()) {
                if (!file.isArchive()) continue;
                f = this.createTmpJavaFile(file.getFileSystemParent());
            }
            args.addAll(this.toStringList(this.templates.getAllJavaFiles()));
        } else {
            args.add(".");
        }
        this.getFactory().getEnvironment().debugMessage("template build args: " + args);
        batchCompiler.configure(args.toArray(new String[0]));
        CompilationUnitDeclaration[] units = batchCompiler.getUnits(this.templates.getAllJavaFiles());
        if (f != null && f.exists()) {
            f.delete();
        }
        JDTTreeBuilder builder = new JDTTreeBuilder(this.factory);
        for (CompilationUnitDeclaration unit : units) {
            unit.traverse((ASTVisitor)builder, unit.scope);
        }
        return this.probs.size() == 0;
    }

    public void setEnvironment(INameEnvironment environment) {
        this.environment = environment;
    }

    public void reportProblem(CategorizedProblem pb) {
        if (pb == null) {
            return;
        }
        if (pb.getID() == 16777539) {
            throw new ModelBuildingException(pb.getMessage());
        }
        this.probs.add(pb);
    }

    public List<CategorizedProblem> getProblems() {
        return Collections.unmodifiableList(this.probs);
    }

    @Override
    public void addInputSources(List<SpoonResource> resources) {
        for (SpoonResource r : resources) {
            this.addInputSource(r);
        }
    }

    @Override
    public void addTemplateSources(List<SpoonResource> resources) {
        for (SpoonResource r : resources) {
            this.addTemplateSource(r);
        }
    }

    @Override
    public void addInputSource(SpoonResource source) {
        if (source.isFile()) {
            this.sources.addFile((SpoonFile)source);
        } else {
            this.sources.addFolder((SpoonFolder)source);
        }
    }

    @Override
    public void addInputSource(File source) {
        try {
            if (SpoonResourceHelper.isFile(source)) {
                this.sources.addFile(SpoonResourceHelper.createFile(source));
            } else {
                this.sources.addFolder(SpoonResourceHelper.createFolder(source));
            }
        }
        catch (Exception e) {
            throw new SpoonException(e);
        }
    }

    @Override
    public void addTemplateSource(SpoonResource source) {
        if (source.isFile()) {
            this.templates.addFile((SpoonFile)source);
        } else {
            this.templates.addFolder((SpoonFolder)source);
        }
    }

    @Override
    public void addTemplateSource(File source) {
        try {
            if (SpoonResourceHelper.isFile(source)) {
                this.templates.addFile(SpoonResourceHelper.createFile(source));
            } else {
                this.templates.addFolder(SpoonResourceHelper.createFolder(source));
            }
        }
        catch (Exception e) {
            throw new SpoonException(e);
        }
    }

    @Override
    public boolean build() {
        if (this.factory == null) {
            throw new SpoonException("Factory not initialized");
        }
        if (this.build) {
            throw new SpoonException("Model already built");
        }
        this.build = true;
        this.factory.getEnvironment().debugMessage("building sources: " + this.sources.getAllJavaFiles());
        long t = System.currentTimeMillis();
        this.javaCompliance = this.factory.getEnvironment().getComplianceLevel();
        boolean srcSuccess = this.buildSources();
        this.reportProblems(this.factory.getEnvironment());
        this.factory.getEnvironment().debugMessage("built in " + (System.currentTimeMillis() - t) + " ms");
        this.factory.getEnvironment().debugMessage("building templates: " + this.templates.getAllJavaFiles());
        t = System.currentTimeMillis();
        boolean templateSuccess = this.buildTemplates();
        this.factory.getEnvironment().debugMessage("built in " + (System.currentTimeMillis() - t) + " ms");
        return srcSuccess && templateSuccess;
    }

    protected void report(Environment environment, CategorizedProblem problem) {
        if (problem == null) {
            throw new IllegalArgumentException("problem cannot be null");
        }
        File file = new File(new String(problem.getOriginatingFileName()));
        String filename = file.getAbsolutePath();
        String message = problem.getMessage() + " at " + filename + ":" + problem.getSourceLineNumber();
        if (problem.isError()) {
            if (!environment.getNoClasspath()) {
                throw new ModelBuildingException(message);
            }
            environment.report(null, problem.isError() ? Level.ERROR : Level.WARN, message);
        }
    }

    public void reportProblems(Environment environment) {
        if (this.getProblems().size() > 0) {
            for (CategorizedProblem problem : this.getProblems()) {
                if (problem == null) continue;
                this.report(environment, problem);
            }
        }
    }

    @Override
    public Set<File> getInputSources() {
        HashSet<File> files = new HashSet<File>();
        for (SpoonFolder file : this.getSource().getSubFolders()) {
            files.add(new File(file.getPath()));
        }
        return files;
    }

    public SpoonFolder getSource() {
        return this.sources;
    }

    public SpoonFolder getTemplates() {
        return this.templates;
    }

    @Override
    public Set<File> getTemplateSources() {
        HashSet<File> files = new HashSet<File>();
        for (SpoonFolder file : this.getTemplates().getSubFolders()) {
            files.add(new File(file.getPath()));
        }
        return files;
    }

    @Override
    public boolean compile() {
        this.initInputClassLoader();
        this.factory.getEnvironment().debugMessage("compiling sources: " + this.factory.CompilationUnit().getMap().keySet());
        long t = System.currentTimeMillis();
        this.javaCompliance = this.factory.getEnvironment().getComplianceLevel();
        JDTBatchCompiler batchCompiler = this.createBatchCompiler(true);
        ArrayList<? extends String> args = new ArrayList<String>();
        args.add("-1." + this.javaCompliance);
        if (this.encoding != null) {
            args.add("-encoding");
            args.add(this.encoding);
        }
        args.add("-preserveAllLocals");
        args.add("-enableJavadoc");
        args.add("-noExit");
        args.add("-proc:none");
        if (this.getBinaryOutputDirectory() != null) {
            args.add("-d");
            args.add(this.getBinaryOutputDirectory().getAbsolutePath());
        } else {
            args.add("-d");
            args.add("none");
        }
        String finalClassPath = null;
        if (this.getSourceClasspath() != null) {
            finalClassPath = this.computeJdtClassPath();
        } else {
            URL[] urls;
            ClassLoader currentClassLoader = Thread.currentThread().getContextClassLoader();
            if (currentClassLoader instanceof URLClassLoader && (urls = ((URLClassLoader)currentClassLoader).getURLs()) != null && urls.length > 0) {
                String classpath = ".";
                for (URL url : urls) {
                    classpath = classpath + File.pathSeparator + url.getFile();
                }
                if (classpath != null) {
                    finalClassPath = classpath;
                }
            }
        }
        args.add("-cp");
        args.add(finalClassPath);
        if (this.buildOnlyOutdatedFiles) {
            if (this.outputDirectory.exists()) {
                Collection outputFiles = FileUtils.listFiles((File)this.outputDirectory, (String[])new String[]{"java"}, (boolean)true);
                int offset = this.outputDirectory.getAbsolutePath().length() + 1;
                ArrayList<String> relativeOutputPaths = new ArrayList<String>();
                for (File f : outputFiles) {
                    relativeOutputPaths.add(f.getAbsolutePath().substring(offset));
                }
                for (SpoonFile sf : this.sources.getAllJavaFiles()) {
                    if (this.factory.CompilationUnit().getMap().containsKey(sf.getPath())) continue;
                    File source = sf.toFile();
                    for (String out : relativeOutputPaths) {
                        if (!source.getAbsolutePath().endsWith(out) || source.lastModified() > new File(this.outputDirectory, out).lastModified()) continue;
                        batchCompiler.ignoreFile(new File(this.outputDirectory, out).getAbsolutePath());
                    }
                }
            }
            args.add(this.getBinaryOutputDirectory().getAbsolutePath());
        } else {
            args.addAll(this.toStringList(this.sources.getAllJavaFiles()));
        }
        this.getFactory().getEnvironment().debugMessage("compile args: " + args);
        System.setProperty("jdt.compiler.useSingleThread", "true");
        batchCompiler.compile(args.toArray(new String[0]));
        this.reportProblems(this.factory.getEnvironment());
        this.factory.getEnvironment().debugMessage("compiled in " + (System.currentTimeMillis() - t) + " ms");
        return this.probs.size() == 0;
    }

    @Override
    public void generateProcessedSourceFiles(OutputType outputType) {
        this.initInputClassLoader();
        switch (outputType) {
            case CLASSES: {
                this.generateProcessedSourceFilesUsingTypes();
                break;
            }
            case COMPILATION_UNITS: {
                this.generateProcessedSourceFilesUsingCUs();
                break;
            }
        }
    }

    protected void generateProcessedSourceFilesUsingTypes() {
        if (this.factory.getEnvironment().getDefaultFileGenerator() != null) {
            this.factory.getEnvironment().debugMessage("Generating source using types...");
            QueueProcessingManager processing = new QueueProcessingManager(this.factory);
            processing.addProcessor(this.factory.getEnvironment().getDefaultFileGenerator());
            processing.process();
        }
    }

    protected void generateProcessedSourceFilesUsingCUs() {
        this.factory.getEnvironment().debugMessage("Generating source using compilation units...");
        if (this.outputDirectory == null) {
            throw new RuntimeException("You should set output directory before generating source files");
        }
        if (this.outputDirectory.isFile()) {
            throw new RuntimeException("Output must be a directory");
        }
        if (!this.outputDirectory.exists() && !this.outputDirectory.mkdirs()) {
            throw new RuntimeException("Error creating output directory");
        }
        try {
            this.outputDirectory = this.outputDirectory.getCanonicalFile();
        }
        catch (IOException e1) {
            throw new SpoonException(e1);
        }
        this.factory.getEnvironment().debugMessage("Generating source files to: " + this.outputDirectory);
        ArrayList<File> printedFiles = new ArrayList<File>();
        for (CompilationUnit cu : this.factory.CompilationUnit().getMap().values()) {
            this.factory.getEnvironment().debugMessage("Generating source for compilation unit: " + cu.getFile());
            CtType<?> element = cu.getMainType();
            CtPackage pack = element.getPackage();
            File packageDir = pack.getQualifiedName().equals("unnamed package") ? new File(this.outputDirectory.getAbsolutePath()) : new File(this.outputDirectory.getAbsolutePath() + File.separatorChar + pack.getQualifiedName().replace('.', File.separatorChar));
            if (!packageDir.exists() && !packageDir.mkdirs()) {
                throw new RuntimeException("Error creating output directory");
            }
            try {
                File file = new File(packageDir.getAbsolutePath() + File.separatorChar + element.getSimpleName() + ".java");
                file.createNewFile();
                InputStream is = this.getCompilationUnitInputStream(cu.getFile().getPath());
                IOUtils.copy((InputStream)is, (OutputStream)new FileOutputStream(file));
                if (printedFiles.contains(file)) continue;
                printedFiles.add(file);
            }
            catch (Exception e) {
                Launcher.LOGGER.error((Object)e.getMessage(), (Throwable)e);
            }
        }
    }

    protected InputStream getCompilationUnitInputStream(String path) {
        Environment env = this.factory.getEnvironment();
        CompilationUnit cu = this.factory.CompilationUnit().getMap().get(path);
        List<CtType<?>> toBePrinted = cu.getDeclaredTypes();
        PrettyPrinter printer = null;
        if (printer == null) {
            printer = new DefaultJavaPrettyPrinter(env);
        }
        printer.calculate(cu, toBePrinted);
        return new ByteArrayInputStream(printer.getResult().toString().getBytes());
    }

    @Override
    public Factory getFactory() {
        return this.factory;
    }

    @Override
    public boolean compileInputSources() {
        this.initInputClassLoader();
        this.factory.getEnvironment().debugMessage("compiling input sources: " + this.sources.getAllJavaFiles());
        long t = System.currentTimeMillis();
        this.javaCompliance = this.factory.getEnvironment().getComplianceLevel();
        JDTBatchCompiler batchCompiler = this.createBatchCompiler(false);
        ArrayList<? extends String> args = new ArrayList<String>();
        args.add("-1." + this.javaCompliance);
        if (this.encoding != null) {
            args.add("-encoding");
            args.add(this.encoding);
        }
        args.add("-preserveAllLocals");
        args.add("-enableJavadoc");
        args.add("-noExit");
        args.add("-proc:none");
        if (this.getBinaryOutputDirectory() != null) {
            args.add("-d");
            args.add(this.getBinaryOutputDirectory().getAbsolutePath());
        } else {
            args.add("-d");
            args.add("none");
        }
        String finalClassPath = null;
        if (this.getSourceClasspath() != null) {
            finalClassPath = this.computeJdtClassPath();
        } else {
            URL[] urls;
            ClassLoader currentClassLoader = Thread.currentThread().getContextClassLoader();
            if (currentClassLoader instanceof URLClassLoader && (urls = ((URLClassLoader)currentClassLoader).getURLs()) != null && urls.length > 0) {
                String classpath = ".";
                for (URL url : urls) {
                    classpath = classpath + File.pathSeparator + url.getFile();
                }
                if (classpath != null) {
                    finalClassPath = classpath;
                }
            }
        }
        args.add("-cp");
        args.add(finalClassPath);
        args.addAll(this.toStringList(this.sources.getAllJavaFiles()));
        batchCompiler.compile(args.toArray(new String[0]));
        this.factory.getEnvironment().debugMessage("compiled in " + (System.currentTimeMillis() - t) + " ms");
        return this.probs.size() == 0;
    }

    @Override
    public String[] getTemplateClasspath() {
        return this.templateClasspath;
    }

    @Override
    public String[] getSourceClasspath() {
        return this.getEnvironment().getSourceClasspath();
    }

    @Override
    public void setSourceClasspath(String ... classpath) {
        this.getEnvironment().setSourceClasspath(classpath);
    }

    @Override
    public void setTemplateClasspath(String ... classpath) {
        this.templateClasspath = classpath;
    }

    @Override
    public void setBuildOnlyOutdatedFiles(boolean buildOnlyOutdatedFiles) {
        this.buildOnlyOutdatedFiles = buildOnlyOutdatedFiles;
    }

    @Override
    public void forceBuild(SpoonResource source) {
        this.forceBuildList.add(source);
    }

    @Override
    public String getEncoding() {
        return this.encoding;
    }

    @Override
    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    private CompilerClassLoader getCompilerClassLoader(ClassLoader initialClassLoader) {
        while (initialClassLoader != null) {
            if (initialClassLoader instanceof CompilerClassLoader) {
                return (CompilerClassLoader)initialClassLoader;
            }
            initialClassLoader = initialClassLoader.getParent();
        }
        return null;
    }

    private boolean hasClassLoader(ClassLoader initialClassLoader, ClassLoader classLoader) {
        while (initialClassLoader != null) {
            if (initialClassLoader == classLoader) {
                return true;
            }
            initialClassLoader = initialClassLoader.getParent();
        }
        return false;
    }

    protected void initInputClassLoader() {
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        if (this.buildOnlyOutdatedFiles && this.getBinaryOutputDirectory() != null) {
            CompilerClassLoader ccl = this.getCompilerClassLoader(cl);
            if (ccl == null) {
                try {
                    Launcher.LOGGER.debug((Object)("setting classloader for " + this.getBinaryOutputDirectory().toURI().toURL()));
                    Thread.currentThread().setContextClassLoader(new CompilerClassLoader(new URL[]{this.getBinaryOutputDirectory().toURI().toURL()}, this.factory.getEnvironment().getInputClassLoader()));
                }
                catch (Exception e) {
                    Launcher.LOGGER.error((Object)e.getMessage(), (Throwable)e);
                }
            }
        } else if (!this.hasClassLoader(Thread.currentThread().getContextClassLoader(), this.factory.getEnvironment().getInputClassLoader())) {
            Thread.currentThread().setContextClassLoader(this.factory.getEnvironment().getInputClassLoader());
        }
    }

    @Override
    public void process(List<String> processorTypes) {
        this.initInputClassLoader();
        QueueProcessingManager processing = new QueueProcessingManager(this.factory);
        for (String processorName : processorTypes) {
            processing.addProcessor(processorName);
            this.factory.getEnvironment().debugMessage("Loaded processor " + processorName + ".");
        }
        processing.process();
    }

    @Override
    public void process(Collection<Processor<? extends CtElement>> processors) {
        this.initInputClassLoader();
        QueueProcessingManager processing = new QueueProcessingManager(this.factory);
        for (Processor<? extends CtElement> processorName : processors) {
            processing.addProcessor(processorName);
            this.factory.getEnvironment().debugMessage("Loaded processor " + processorName + ".");
        }
        processing.process();
    }

    protected Environment getEnvironment() {
        return this.getFactory().getEnvironment();
    }
}

