/*
 * Decompiled with CFR 0.152.
 */
package spoon.support.compiler.jdt;

import java.io.InputStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.io.IOUtils;
import org.eclipse.jdt.core.compiler.CategorizedProblem;
import org.eclipse.jdt.internal.compiler.CompilationResult;
import org.eclipse.jdt.internal.compiler.ICompilerRequestor;
import org.eclipse.jdt.internal.compiler.ast.CompilationUnitDeclaration;
import org.eclipse.jdt.internal.compiler.batch.CompilationUnit;
import org.eclipse.jdt.internal.compiler.batch.Main;
import org.eclipse.jdt.internal.compiler.env.INameEnvironment;
import org.eclipse.jdt.internal.compiler.impl.CompilerOptions;
import spoon.Launcher;
import spoon.compiler.SpoonFile;
import spoon.support.compiler.jdt.CompilationUnitWrapper;
import spoon.support.compiler.jdt.JDTBasedSpoonCompiler;
import spoon.support.compiler.jdt.TreeBuilderCompiler;

class JDTBatchCompiler
extends Main {
    protected JDTBasedSpoonCompiler jdtCompiler;
    private boolean useFactory;
    private Set<String> ignoredFiles = new HashSet<String>();

    JDTBatchCompiler(JDTBasedSpoonCompiler jdtCompiler, boolean useFactory) {
        super(new PrintWriter(System.out), new PrintWriter(System.err), false, null, null);
        this.jdtCompiler = jdtCompiler;
        this.useFactory = useFactory;
    }

    public ICompilerRequestor getBatchRequestor() {
        final ICompilerRequestor r = super.getBatchRequestor();
        return new ICompilerRequestor(){

            public void acceptResult(CompilationResult compilationResult) {
                if (compilationResult.hasErrors()) {
                    for (CategorizedProblem problem : compilationResult.problems) {
                        JDTBatchCompiler.this.jdtCompiler.reportProblem(problem);
                    }
                }
                r.acceptResult(compilationResult);
            }
        };
    }

    public void ignoreFile(String filePath) {
        this.ignoredFiles.add(filePath);
    }

    public CompilationUnit[] getCompilationUnits() {
        CompilationUnit[] units = super.getCompilationUnits();
        if (!this.ignoredFiles.isEmpty()) {
            ArrayList<CompilationUnit> l = new ArrayList<CompilationUnit>();
            for (CompilationUnit unit : units) {
                if (this.ignoredFiles.contains(new String(unit.getFileName()))) continue;
                l.add(unit);
            }
            units = l.toArray(new CompilationUnit[0]);
        }
        if (this.useFactory) {
            for (int i = 0; i < units.length; ++i) {
                CompilationUnit unit = units[i];
                units[i] = new CompilationUnitWrapper(this.jdtCompiler, unit);
            }
        }
        return units;
    }

    public CompilationUnit[] getCompilationUnits(List<SpoonFile> files) {
        HashSet<String> fileNames = new HashSet<String>();
        ArrayList<SpoonFile> virtualFiles = new ArrayList<SpoonFile>();
        for (SpoonFile f : files) {
            if (!f.isActualFile()) {
                virtualFiles.add(f);
                continue;
            }
            fileNames.add(f.getPath());
        }
        ArrayList<CompilationUnit> culist = new ArrayList<CompilationUnit>();
        CompilationUnit[] units = this.getCompilationUnits();
        for (CompilationUnit unit : units) {
            if (!fileNames.contains(new String(unit.getFileName()))) continue;
            culist.add(unit);
        }
        for (SpoonFile f : virtualFiles) {
            try {
                culist.add(new CompilationUnit(IOUtils.toCharArray((InputStream)f.getContent()), f.getName(), null));
            }
            catch (Exception e) {
                Launcher.LOGGER.error((Object)e.getMessage(), (Throwable)e);
            }
        }
        return culist.toArray(new CompilationUnit[0]);
    }

    public CompilationUnitDeclaration[] getUnits(List<SpoonFile> files) {
        this.startTime = System.currentTimeMillis();
        INameEnvironment environment = this.jdtCompiler.environment;
        if (environment == null) {
            environment = this.getLibraryAccess();
        }
        CompilerOptions compilerOptions = new CompilerOptions(this.options);
        compilerOptions.parseLiteralExpressionsAsConstants = false;
        TreeBuilderCompiler treeBuilderCompiler = new TreeBuilderCompiler(environment, this.getHandlingPolicy(), compilerOptions, this.jdtCompiler.requestor, this.getProblemFactory(), this.out, null);
        CompilationUnitDeclaration[] units = treeBuilderCompiler.buildUnits(this.getCompilationUnits(files));
        return units;
    }
}

