/*
 * Decompiled with CFR 0.152.
 */
package spoon.support.gui;

import java.util.Stack;
import javax.swing.tree.DefaultMutableTreeNode;
import spoon.reflect.declaration.CtElement;
import spoon.reflect.declaration.CtNamedElement;
import spoon.reflect.reference.CtReference;
import spoon.reflect.visitor.CtScanner;

public class SpoonTreeBuilder
extends CtScanner {
    Stack<DefaultMutableTreeNode> nodes;
    DefaultMutableTreeNode root = new DefaultMutableTreeNode("Spoon Tree Root");

    public SpoonTreeBuilder() {
        this.nodes = new Stack();
        this.nodes.push(this.root);
    }

    private void createNode(Object o) {
        DefaultMutableTreeNode node = new DefaultMutableTreeNode(o){
            private static final long serialVersionUID = 1L;

            private String getASTNodeName() {
                return this.getUserObject().getClass().getSimpleName().replaceAll("Impl$", "");
            }

            @Override
            public String toString() {
                if (this.getUserObject() instanceof CtNamedElement) {
                    return this.getASTNodeName() + " - " + ((CtNamedElement)this.getUserObject()).getSimpleName();
                }
                return this.getASTNodeName() + " - " + this.getUserObject().toString();
            }
        };
        this.nodes.peek().add(node);
        this.nodes.push(node);
    }

    @Override
    public void enter(CtElement element) {
        this.createNode(element);
        super.enter(element);
    }

    @Override
    public void enterReference(CtReference e) {
        this.createNode(e);
        super.enterReference(e);
    }

    @Override
    public void exitReference(CtReference e) {
        this.nodes.pop();
        super.exitReference(e);
    }

    @Override
    public void exit(CtElement element) {
        this.nodes.pop();
        super.exit(element);
    }

    public DefaultMutableTreeNode getRoot() {
        return this.root;
    }
}

