/*
 * Decompiled with CFR 0.152.
 */
package spoon.support.processing;

import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.TreeMap;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;
import org.xml.sax.helpers.XMLReaderFactory;
import spoon.processing.ProcessorProperties;
import spoon.reflect.factory.Factory;
import spoon.reflect.reference.CtExecutableReference;
import spoon.reflect.reference.CtFieldReference;
import spoon.reflect.reference.CtPackageReference;
import spoon.reflect.reference.CtTypeReference;

public class XmlProcessorProperties
implements ProcessorProperties {
    Factory factory;
    String processorName;
    private Map<String, Object> props = new TreeMap<String, Object>();

    public XmlProcessorProperties(Factory factory, String processorName) {
        this.processorName = processorName;
        this.factory = factory;
    }

    public XmlProcessorProperties(Factory factory, String processorName, InputStream stream) throws IOException, SAXException {
        this.processorName = processorName;
        this.factory = factory;
        this.load(stream);
    }

    public void addProperty(String name, Object value) {
        this.props.put(name, value);
    }

    @Override
    public <T> T get(Class<T> type, String name) {
        if (!this.props.containsKey(name)) {
            return null;
        }
        if (type.isArray()) {
            return (T)this.convertArray(type.getComponentType(), (Collection)this.props.get(name));
        }
        return this.convert(type, this.props.get(name));
    }

    @Override
    public String getProcessorName() {
        return this.processorName;
    }

    private void load(InputStream stream) throws IOException, SAXException {
        if (stream == null) {
            return;
        }
        XMLReader xr = XMLReaderFactory.createXMLReader();
        Loader handler = new Loader();
        xr.setContentHandler(handler);
        xr.parse(new InputSource(stream));
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("Properties : \n");
        for (Map.Entry<String, Object> ent : this.props.entrySet()) {
            buf.append(ent.getKey());
            for (int i = ent.getKey().length(); i < 15; ++i) {
                buf.append(" ");
            }
            buf.append(": " + ent.getValue() + "\n");
        }
        return buf.toString();
    }

    public <T> T convert(Class<T> type, Object o) {
        if (o == null) {
            return null;
        }
        if (type == Boolean.TYPE) {
            return (T)new Boolean(o.toString());
        }
        if (type == Byte.TYPE) {
            return (T)new Byte(o.toString());
        }
        if (type == Character.TYPE) {
            return (T)new Character(o.toString().charAt(0));
        }
        if (type == Double.TYPE) {
            return (T)new Double(o.toString());
        }
        if (type == Float.TYPE) {
            return (T)new Float(o.toString());
        }
        if (type == Integer.TYPE) {
            return (T)new Integer(o.toString());
        }
        if (type == Long.TYPE) {
            return (T)new Long(o.toString());
        }
        if (CtTypeReference.class.isAssignableFrom(type)) {
            return (T)this.factory.Type().createReference(o.toString());
        }
        if (CtExecutableReference.class.isAssignableFrom(type)) {
            return (T)this.factory.Executable().createReference(o.toString());
        }
        if (CtFieldReference.class.isAssignableFrom(type)) {
            return (T)this.factory.Field().createReference(o.toString());
        }
        if (CtPackageReference.class.isAssignableFrom(type)) {
            return (T)this.factory.Package().createReference(o.toString());
        }
        if (type.isEnum()) {
            return Enum.valueOf(type, o.toString());
        }
        return (T)o.toString();
    }

    public <T> T convertArray(Class<T> type, Collection<Object> val) {
        if (type.equals(Boolean.TYPE)) {
            boolean[] ret = new boolean[val.size()];
            int i = 0;
            for (Object o : val) {
                ret[i++] = this.convert(Boolean.TYPE, o);
            }
            return (T)ret;
        }
        if (type.equals(Byte.TYPE)) {
            byte[] ret = new byte[val.size()];
            int i = 0;
            for (Object o : val) {
                ret[i++] = this.convert(Byte.TYPE, o);
            }
            return (T)ret;
        }
        if (type.equals(Character.TYPE)) {
            char[] ret = new char[val.size()];
            int i = 0;
            for (Object o : val) {
                ret[i++] = this.convert(Character.TYPE, o).charValue();
            }
            return (T)ret;
        }
        if (type.equals(Double.TYPE)) {
            double[] ret = new double[val.size()];
            int i = 0;
            for (Object o : val) {
                ret[i++] = this.convert(Double.TYPE, o);
            }
            return (T)ret;
        }
        if (type.equals(Float.TYPE)) {
            float[] ret = new float[val.size()];
            int i = 0;
            for (Object o : val) {
                ret[i++] = this.convert(Float.TYPE, o).floatValue();
            }
            return (T)ret;
        }
        if (type.equals(Integer.TYPE)) {
            int[] ret = new int[val.size()];
            int i = 0;
            for (Object o : val) {
                ret[i++] = this.convert(Integer.TYPE, o);
            }
            return (T)ret;
        }
        if (type.equals(Long.TYPE)) {
            long[] ret = new long[val.size()];
            int i = 0;
            for (Object o : val) {
                ret[i++] = this.convert(Long.TYPE, o);
            }
            return (T)ret;
        }
        if (type.equals(String.class)) {
            String[] ret = new String[val.size()];
            int i = 0;
            for (Object o : val) {
                ret[i++] = this.convert(String.class, o);
            }
            return (T)ret;
        }
        if (CtPackageReference.class.isAssignableFrom(type)) {
            CtPackageReference[] ret = new CtPackageReference[val.size()];
            int i = 0;
            for (Object o : val) {
                ret[i++] = this.convert(CtPackageReference.class, o);
            }
            return (T)ret;
        }
        if (CtTypeReference.class.isAssignableFrom(type)) {
            CtTypeReference[] ret = new CtTypeReference[val.size()];
            int i = 0;
            for (Object o : val) {
                ret[i++] = this.convert(CtTypeReference.class, o);
            }
            return (T)ret;
        }
        if (CtFieldReference.class.isAssignableFrom(type)) {
            CtFieldReference[] ret = new CtFieldReference[val.size()];
            int i = 0;
            for (Object o : val) {
                ret[i++] = this.convert(CtFieldReference.class, o);
            }
            return (T)ret;
        }
        if (CtExecutableReference.class.isAssignableFrom(type)) {
            CtExecutableReference[] ret = new CtExecutableReference[val.size()];
            int i = 0;
            for (Object o : val) {
                ret[i++] = this.convert(CtExecutableReference.class, o);
            }
            return (T)ret;
        }
        if (type.isEnum()) {
            ArrayList<Enum> ret = new ArrayList<Enum>();
            for (Object o : val) {
                ret.add((Enum)this.convert(type, o));
            }
            return (T)ret.toArray((Enum[])Array.newInstance(type, 0));
        }
        return null;
    }

    public class Loader
    extends DefaultHandler {
        boolean isValue = false;
        String name;
        Object value;

        @Override
        public void characters(char[] ch, int start, int length) throws SAXException {
            if (this.isValue) {
                if (this.value == null || !(this.value instanceof Collection)) {
                    this.value = new ArrayList();
                }
                ((Collection)this.value).add(new String(ch, start, length));
            }
        }

        @Override
        public void endElement(String uri, String localName, String qName) throws SAXException {
            if ("property".equals(localName)) {
                XmlProcessorProperties.this.props.put(this.name, this.value);
                this.value = null;
            } else if ("value".equals(localName)) {
                this.isValue = false;
            }
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            if ("property".equals(localName)) {
                this.name = attributes.getValue("name");
                if (attributes.getValue("value") != null) {
                    this.value = attributes.getValue("value");
                }
            } else if ("value".equals(localName)) {
                this.isValue = true;
            }
        }
    }
}

