/*
 * Decompiled with CFR 0.152.
 */
package spoon.support.reflect.code;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import spoon.reflect.code.CtBlock;
import spoon.reflect.code.CtCodeElement;
import spoon.reflect.code.CtInvocation;
import spoon.reflect.code.CtStatement;
import spoon.reflect.code.CtStatementList;
import spoon.reflect.declaration.CtConstructor;
import spoon.reflect.declaration.CtElement;
import spoon.reflect.declaration.CtType;
import spoon.reflect.declaration.ParentNotInitializedException;
import spoon.reflect.visitor.CtVisitor;
import spoon.reflect.visitor.Filter;
import spoon.reflect.visitor.Query;
import spoon.support.reflect.code.CtStatementImpl;
import spoon.support.reflect.declaration.CtElementImpl;

public class CtBlockImpl<R>
extends CtStatementImpl
implements CtBlock<R> {
    private static final long serialVersionUID = 1L;
    private List<CtStatement> statements = CtBlockImpl.emptyList();

    @Override
    public void accept(CtVisitor visitor) {
        visitor.visitCtBlock(this);
    }

    @Override
    public List<CtStatement> getStatements() {
        this.ensureModifiableStatementsList();
        return this.statements;
    }

    @Override
    public <T extends CtStatement> T getStatement(int i) {
        return (T)this.statements.get(i);
    }

    @Override
    public <T extends CtStatement> T getLastStatement() {
        return (T)this.statements.get(this.statements.size() - 1);
    }

    @Override
    public <T extends CtBlock<R>> T insertBegin(CtStatementList statements) {
        CtStatement first;
        if (this.getParent() != null && this.getParent() instanceof CtConstructor && this.getStatements().size() > 0 && (first = this.getStatements().get(0)) instanceof CtInvocation && ((CtInvocation)first).getExecutable().getSimpleName().startsWith("<init>")) {
            first.insertAfter(statements);
            return (T)this;
        }
        if (this.statements == CtElementImpl.emptyList()) {
            this.statements = new ArrayList<CtStatement>(statements.getStatements().size() + 3);
        }
        this.statements.addAll(0, statements.getStatements());
        return (T)this;
    }

    @Override
    public <T extends CtBlock<R>> T insertBegin(CtStatement statement) {
        try {
            CtStatement first;
            if (this.getParent() != null && this.getParent() instanceof CtConstructor && this.getStatements().size() > 0 && (first = this.getStatements().get(0)) instanceof CtInvocation && ((CtInvocation)first).getExecutable().getSimpleName().startsWith("<init>")) {
                first.insertAfter(statement);
                return (T)this;
            }
        }
        catch (ParentNotInitializedException parentNotInitializedException) {
            // empty catch block
        }
        this.ensureModifiableStatementsList();
        this.statements.add(0, statement);
        return (T)this;
    }

    @Override
    public <T extends CtBlock<R>> T insertEnd(CtStatement statement) {
        this.ensureModifiableStatementsList();
        this.addStatement(statement);
        return (T)this;
    }

    @Override
    public <T extends CtBlock<R>> T insertEnd(CtStatementList statements) {
        for (CtStatement s : statements.getStatements()) {
            this.insertEnd(s);
        }
        return (T)this;
    }

    @Override
    public <T extends CtBlock<R>> T insertAfter(Filter<? extends CtStatement> insertionPoints, CtStatement statement) {
        for (CtStatement ctStatement : Query.getElements(this, insertionPoints)) {
            ctStatement.insertAfter(statement);
        }
        return (T)this;
    }

    @Override
    public <T extends CtBlock<R>> T insertAfter(Filter<? extends CtStatement> insertionPoints, CtStatementList statements) {
        for (CtStatement ctStatement : Query.getElements(this, insertionPoints)) {
            ctStatement.insertAfter(statements);
        }
        return (T)this;
    }

    @Override
    public <T extends CtBlock<R>> T insertBefore(Filter<? extends CtStatement> insertionPoints, CtStatement statement) {
        for (CtStatement ctStatement : Query.getElements(this, insertionPoints)) {
            ctStatement.insertBefore(statement);
        }
        return (T)this;
    }

    @Override
    public <T extends CtBlock<R>> T insertBefore(Filter<? extends CtStatement> insertionPoints, CtStatementList statements) {
        for (CtStatement ctStatement : Query.getElements(this, insertionPoints)) {
            ctStatement.insertBefore(statements);
        }
        return (T)this;
    }

    @Override
    public <T extends CtStatementList> T setStatements(List<CtStatement> statements) {
        this.statements.clear();
        for (CtStatement s : statements) {
            this.addStatement(s);
        }
        return (T)this;
    }

    @Override
    public <T extends CtStatementList> T addStatement(CtStatement statement) {
        this.ensureModifiableStatementsList();
        statement.setParent(this);
        this.statements.add(statement);
        return (T)this;
    }

    private void ensureModifiableStatementsList() {
        if (this.statements == CtElementImpl.emptyList()) {
            this.statements = new ArrayList<CtStatement>(3);
        }
    }

    @Override
    public void removeStatement(CtStatement statement) {
        if (this.statements != CtElementImpl.emptyList()) {
            this.statements.remove(statement);
        }
    }

    @Override
    public Iterator<CtStatement> iterator() {
        return Collections.unmodifiableList(new ArrayList<CtStatement>(this.getStatements())).iterator();
    }

    @Override
    public <T extends R> void replace(CtBlock<T> element) {
        this.replace((CtElement)element);
    }

    @Override
    public R S() {
        return null;
    }

    public CtCodeElement getSubstitution(CtType<?> targetType) {
        return this.getFactory().Core().clone(this);
    }
}

