/*
 * Decompiled with CFR 0.152.
 */
package spoon.support.reflect.code;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import spoon.SpoonException;
import spoon.reflect.code.CtBlock;
import spoon.reflect.code.CtExpression;
import spoon.reflect.code.CtLambda;
import spoon.reflect.declaration.CtExecutable;
import spoon.reflect.declaration.CtNamedElement;
import spoon.reflect.declaration.CtParameter;
import spoon.reflect.reference.CtExecutableReference;
import spoon.reflect.reference.CtTypeReference;
import spoon.reflect.visitor.CtVisitor;
import spoon.support.reflect.code.CtExpressionImpl;
import spoon.support.reflect.declaration.CtElementImpl;

public class CtLambdaImpl<T>
extends CtExpressionImpl<T>
implements CtLambda<T> {
    String simpleName;
    CtExpression<T> expression;
    CtBlock<?> body;
    List<CtParameter<?>> parameters = CtLambdaImpl.emptyList();
    Set<CtTypeReference<? extends Throwable>> thrownTypes = CtLambdaImpl.emptySet();

    @Override
    public void accept(CtVisitor visitor) {
        visitor.visitCtLambda(this);
    }

    @Override
    public String getSimpleName() {
        return this.simpleName;
    }

    public <C extends CtNamedElement> C setSimpleName(String simpleName) {
        this.simpleName = simpleName;
        return (C)this;
    }

    @Override
    public <B extends T> CtBlock<B> getBody() {
        return this.body;
    }

    @Override
    public <B extends T, C extends CtExecutable<T>> C setBody(CtBlock<B> body) {
        if (this.expression != null) {
            throw new SpoonException("A lambda can't have two bodys.");
        }
        body.setParent(this);
        this.body = body;
        return (C)this;
    }

    @Override
    public List<CtParameter<?>> getParameters() {
        return Collections.unmodifiableList(this.parameters);
    }

    @Override
    public <C extends CtExecutable<T>> C setParameters(List<CtParameter<?>> params) {
        this.parameters.clear();
        for (CtParameter<?> p : params) {
            this.addParameter(p);
        }
        return (C)this;
    }

    @Override
    public <C extends CtExecutable<T>> C addParameter(CtParameter<?> parameter) {
        if (this.parameters == CtElementImpl.emptyList()) {
            this.parameters = new ArrayList(2);
        }
        parameter.setParent(this);
        this.parameters.add(parameter);
        return (C)this;
    }

    @Override
    public boolean removeParameter(CtParameter<?> parameter) {
        return this.parameters != CtElementImpl.emptyList() && this.parameters.remove(parameter);
    }

    @Override
    public Set<CtTypeReference<? extends Throwable>> getThrownTypes() {
        return this.thrownTypes;
    }

    @Override
    public <C extends CtExecutable<T>> C setThrownTypes(Set<CtTypeReference<? extends Throwable>> thrownTypes) {
        this.thrownTypes = thrownTypes;
        return (C)this;
    }

    @Override
    public <C extends CtExecutable<T>> C addThrownType(CtTypeReference<? extends Throwable> throwType) {
        if (this.thrownTypes == CtElementImpl.emptySet()) {
            this.thrownTypes = new TreeSet<CtTypeReference<? extends Throwable>>();
        }
        this.thrownTypes.add(throwType);
        return (C)this;
    }

    @Override
    public boolean removeThrownType(CtTypeReference<? extends Throwable> throwType) {
        return this.thrownTypes.remove(throwType);
    }

    @Override
    public CtExecutableReference<T> getReference() {
        return this.getFactory().Executable().createReference(this);
    }

    @Override
    public CtExpression<T> getExpression() {
        return this.expression;
    }

    @Override
    public <C extends CtLambda<T>> C setExpression(CtExpression<T> expression) {
        if (this.body != null) {
            throw new SpoonException("A lambda can't have two bodys.");
        }
        expression.setParent(this);
        this.expression = expression;
        return (C)this;
    }
}

