/*
 * Decompiled with CFR 0.152.
 */
package spoon.support.reflect.cu;

import java.io.File;
import java.io.FileInputStream;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import spoon.processing.FactoryAccessor;
import spoon.reflect.cu.CompilationUnit;
import spoon.reflect.cu.Import;
import spoon.reflect.declaration.CtType;
import spoon.reflect.factory.Factory;

public class CompilationUnitImpl
implements CompilationUnit,
FactoryAccessor {
    Factory factory;
    List<CtType<?>> declaredTypes = new ArrayList(1);
    File file;
    String originalSourceCode;
    boolean autoImport = true;
    Set<Import> manualImports = new HashSet<Import>();

    @Override
    public List<CtType<?>> getDeclaredTypes() {
        return this.declaredTypes;
    }

    @Override
    public File getFile() {
        return this.file;
    }

    @Override
    public CtType<?> getMainType() {
        if (this.getFile() == null) {
            return this.getDeclaredTypes().get(0);
        }
        for (CtType<?> t : this.getDeclaredTypes()) {
            String name = this.getFile().getName();
            name = name.substring(0, name.lastIndexOf("."));
            if (!t.getSimpleName().equals(name)) continue;
            return t;
        }
        throw new RuntimeException("inconsistent compilation unit: '" + this.file + "': declared types are " + this.getDeclaredTypes());
    }

    @Override
    public void setDeclaredTypes(List<CtType<?>> types) {
        this.declaredTypes = types;
    }

    @Override
    public void setFile(File file) {
        this.file = file;
    }

    @Override
    public String getOriginalSourceCode() {
        try {
            if (this.originalSourceCode == null) {
                FileInputStream s = new FileInputStream(this.getFile());
                byte[] elementBytes = new byte[s.available()];
                s.read(elementBytes);
                s.close();
                this.originalSourceCode = new String(elementBytes);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return this.originalSourceCode;
    }

    @Override
    public int beginOfLineIndex(int index) {
        int cur;
        for (cur = index; cur >= 0 && this.getOriginalSourceCode().charAt(cur) != '\n'; --cur) {
        }
        return cur + 1;
    }

    @Override
    public int nextLineIndex(int index) {
        int cur;
        for (cur = index; cur < this.getOriginalSourceCode().length() && this.getOriginalSourceCode().charAt(cur) != '\n'; ++cur) {
        }
        return cur + 1;
    }

    @Override
    public int getTabCount(int index) {
        int tabCount = 0;
        int whiteSpaceCount = 0;
        for (int cur = index; cur < this.getOriginalSourceCode().length() && (this.getOriginalSourceCode().charAt(cur) == ' ' || this.getOriginalSourceCode().charAt(cur) == '\t'); ++cur) {
            if (this.getOriginalSourceCode().charAt(cur) == '\t') {
                ++tabCount;
            }
            if (this.getOriginalSourceCode().charAt(cur) != ' ') continue;
            ++whiteSpaceCount;
        }
        return tabCount += whiteSpaceCount / this.getFactory().getEnvironment().getTabulationSize();
    }

    @Override
    public Factory getFactory() {
        return this.factory;
    }

    @Override
    public void setFactory(Factory factory) {
        this.factory = factory;
    }

    public boolean isAutoImport() {
        return this.autoImport;
    }

    public void setAutoImport(boolean autoImport) {
        this.autoImport = autoImport;
    }

    public Set<Import> getManualImports() {
        return this.manualImports;
    }

    public void setManualImports(Set<Import> manualImports) {
        this.manualImports = manualImports;
    }
}

