/*
 * Decompiled with CFR 0.152.
 */
package spoon.support.reflect.declaration;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import spoon.reflect.code.CtCodeElement;
import spoon.reflect.code.CtStatement;
import spoon.reflect.code.CtStatementList;
import spoon.reflect.declaration.CtAnonymousExecutable;
import spoon.reflect.declaration.CtClass;
import spoon.reflect.declaration.CtConstructor;
import spoon.reflect.declaration.CtElement;
import spoon.reflect.declaration.CtExecutable;
import spoon.reflect.reference.CtExecutableReference;
import spoon.reflect.reference.CtReference;
import spoon.reflect.reference.CtTypeReference;
import spoon.reflect.visitor.CtVisitor;
import spoon.support.reflect.code.CtStatementImpl;
import spoon.support.reflect.declaration.CtElementImpl;
import spoon.support.reflect.declaration.CtTypeImpl;
import spoon.support.reflect.eval.VisitorPartialEvaluator;

public class CtClassImpl<T>
extends CtTypeImpl<T>
implements CtClass<T> {
    private static final long serialVersionUID = 1L;
    List<CtAnonymousExecutable> anonymousExecutables = CtClassImpl.emptyList();
    Set<CtConstructor<T>> constructors = CtClassImpl.emptySet();
    CtTypeReference<?> superClass;

    @Override
    public void accept(CtVisitor v) {
        v.visitCtClass(this);
    }

    @Override
    public List<CtAnonymousExecutable> getAnonymousExecutables() {
        return this.anonymousExecutables;
    }

    @Override
    public CtConstructor<T> getConstructor(CtTypeReference<?> ... parameterTypes) {
        for (CtConstructor<T> c : this.constructors) {
            boolean cont = c.getParameters().size() == parameterTypes.length;
            for (int i = 0; cont && i < c.getParameters().size() && i < parameterTypes.length; ++i) {
                if (c.getParameters().get(i).getType().getQualifiedName().equals(parameterTypes[i].getQualifiedName())) continue;
                cont = false;
            }
            if (!cont) continue;
            return c;
        }
        return null;
    }

    @Override
    public Set<CtConstructor<T>> getConstructors() {
        return this.constructors;
    }

    @Override
    public <C extends CtClass<T>> C addAnonymousExecutable(CtAnonymousExecutable e) {
        if (this.anonymousExecutables == CtElementImpl.emptyList()) {
            this.anonymousExecutables = new ArrayList<CtAnonymousExecutable>(1);
        }
        e.setParent(this);
        this.anonymousExecutables.add(e);
        return (C)this;
    }

    @Override
    public boolean removeAnonymousExecutable(CtAnonymousExecutable e) {
        return this.anonymousExecutables != CtElementImpl.emptyList() && this.anonymousExecutables.remove(e);
    }

    @Override
    public CtTypeReference<?> getSuperclass() {
        return this.superClass;
    }

    @Override
    public <C extends CtClass<T>> C setAnonymousExecutables(List<CtAnonymousExecutable> anonymousExecutables) {
        this.anonymousExecutables.clear();
        for (CtAnonymousExecutable exec : anonymousExecutables) {
            this.addAnonymousExecutable(exec);
        }
        return (C)this;
    }

    @Override
    public <C extends CtClass<T>> C setConstructors(Set<CtConstructor<T>> constructors) {
        this.constructors = constructors;
        return (C)this;
    }

    @Override
    public <C extends CtClass<T>> C addConstructor(CtConstructor<T> constructor) {
        if (this.constructors == CtElementImpl.emptySet()) {
            this.constructors = new TreeSet<CtConstructor<T>>();
        }
        constructor.setParent(this);
        this.constructors.add(constructor);
        return (C)this;
    }

    @Override
    public void removeConstructor(CtConstructor<T> constructor) {
        if (!this.constructors.isEmpty()) {
            if (this.constructors.size() == 1) {
                if (this.constructors.contains(constructor)) {
                    this.constructors = CtElementImpl.emptySet();
                }
            } else {
                this.constructors.remove(constructor);
            }
        }
    }

    @Override
    public <C extends CtClass<T>> C setSuperclass(CtTypeReference<?> superClass) {
        this.superClass = superClass;
        return (C)this;
    }

    @Override
    public boolean isAnonymous() {
        try {
            Integer.parseInt(this.getSimpleName());
        }
        catch (NumberFormatException e) {
            return false;
        }
        return true;
    }

    @Override
    public boolean isSubtypeOf(CtTypeReference<?> type) {
        if (this.getSuperclass() != null && this.getSuperclass().isSubtypeOf(type)) {
            return true;
        }
        for (CtTypeReference<?> ref : this.getSuperInterfaces()) {
            if (!ref.isSubtypeOf(type)) continue;
            return true;
        }
        return false;
    }

    public <C extends CtStatement> C insertAfter(CtStatement statement) {
        CtStatementImpl.insertAfter((CtStatement)this, statement);
        return (C)this;
    }

    public <C extends CtStatement> C insertAfter(CtStatementList statements) {
        CtStatementImpl.insertAfter((CtStatement)this, statements);
        return (C)this;
    }

    public <C extends CtStatement> C insertBefore(CtStatement statement) {
        CtStatementImpl.insertBefore((CtStatement)this, statement);
        return (C)this;
    }

    public <C extends CtStatement> C insertBefore(CtStatementList statements) {
        CtStatementImpl.insertBefore((CtStatement)this, statements);
        return (C)this;
    }

    @Override
    public String getLabel() {
        return null;
    }

    public <C extends CtStatement> C setLabel(String label) {
        throw new UnsupportedOperationException("cannot set a label on a class declaration");
    }

    @Override
    public <R extends CtCodeElement> R partiallyEvaluate() {
        VisitorPartialEvaluator eval = new VisitorPartialEvaluator();
        return (R)eval.evaluate(this.getParent(), this);
    }

    @Override
    public Collection<CtExecutableReference<?>> getDeclaredExecutables() {
        Collection<CtExecutableReference<?>> declaredExecutables = super.getDeclaredExecutables();
        ArrayList<CtReference> l = new ArrayList<CtReference>(declaredExecutables.size() + this.getConstructors().size());
        l.addAll(declaredExecutables);
        for (CtExecutable ctExecutable : this.getConstructors()) {
            l.add(ctExecutable.getReference());
        }
        return Collections.unmodifiableCollection(l);
    }

    @Override
    public void replace(CtStatement element) {
        this.replace((CtElement)element);
    }
}

