/*
 * Decompiled with CFR 0.152.
 */
package spoon.support.reflect.declaration;

import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import spoon.reflect.declaration.CtConstructor;
import spoon.reflect.declaration.CtGenericElement;
import spoon.reflect.declaration.CtModifiable;
import spoon.reflect.declaration.CtNamedElement;
import spoon.reflect.declaration.CtType;
import spoon.reflect.declaration.CtTypedElement;
import spoon.reflect.declaration.ModifierKind;
import spoon.reflect.reference.CtTypeReference;
import spoon.reflect.visitor.CtVisitor;
import spoon.support.reflect.declaration.CtElementImpl;
import spoon.support.reflect.declaration.CtExecutableImpl;

public class CtConstructorImpl<T>
extends CtExecutableImpl<T>
implements CtConstructor<T> {
    private static final long serialVersionUID = 1L;
    List<CtTypeReference<?>> formalTypeParameters = CtConstructorImpl.emptyList();
    Set<ModifierKind> modifiers = CtElementImpl.emptySet();

    @Override
    public void accept(CtVisitor visitor) {
        visitor.visitCtConstructor(this);
    }

    public <C extends CtNamedElement> C setSimpleName(String simpleName) {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getSimpleName() {
        return "<init>";
    }

    @Override
    public CtType<T> getDeclaringType() {
        return (CtType)this.parent;
    }

    @Override
    public CtTypeReference<T> getType() {
        if (this.getDeclaringType() == null) {
            return null;
        }
        return this.getDeclaringType().getReference();
    }

    @Override
    public <C extends CtTypedElement> C setType(CtTypeReference<T> type) {
        throw new UnsupportedOperationException();
    }

    @Override
    public List<CtTypeReference<?>> getFormalTypeParameters() {
        return this.formalTypeParameters;
    }

    @Override
    public <T extends CtGenericElement> T addFormalTypeParameter(CtTypeReference<?> formalTypeParameter) {
        if (formalTypeParameter == null) {
            return (T)this;
        }
        if (this.formalTypeParameters == CtElementImpl.emptyList()) {
            this.formalTypeParameters = new ArrayList(1);
        }
        this.formalTypeParameters.add(formalTypeParameter);
        return (T)this;
    }

    @Override
    public <T extends CtGenericElement> T setFormalTypeParameters(List<CtTypeReference<?>> formalTypeParameters) {
        this.formalTypeParameters = formalTypeParameters;
        return (T)this;
    }

    @Override
    public boolean removeFormalTypeParameter(CtTypeReference<?> formalTypeParameter) {
        return formalTypeParameter != null && this.formalTypeParameters != CtElementImpl.emptyList() && this.formalTypeParameters.remove(formalTypeParameter);
    }

    @Override
    public Set<ModifierKind> getModifiers() {
        return this.modifiers;
    }

    @Override
    public boolean hasModifier(ModifierKind modifier) {
        return this.getModifiers().contains((Object)modifier);
    }

    public <C extends CtModifiable> C setModifiers(Set<ModifierKind> modifiers) {
        this.modifiers = modifiers;
        return (C)this;
    }

    public <C extends CtModifiable> C addModifier(ModifierKind modifier) {
        if (this.modifiers == CtElementImpl.emptySet()) {
            this.modifiers = EnumSet.noneOf(ModifierKind.class);
        }
        this.modifiers.add(modifier);
        return (C)this;
    }

    @Override
    public boolean removeModifier(ModifierKind modifier) {
        return !this.modifiers.isEmpty() && this.modifiers.remove((Object)modifier);
    }

    public <C extends CtModifiable> C setVisibility(ModifierKind visibility) {
        if (this.modifiers == CtElementImpl.emptySet()) {
            this.modifiers = EnumSet.noneOf(ModifierKind.class);
        }
        this.getModifiers().remove((Object)ModifierKind.PUBLIC);
        this.getModifiers().remove((Object)ModifierKind.PROTECTED);
        this.getModifiers().remove((Object)ModifierKind.PRIVATE);
        this.getModifiers().add(visibility);
        return (C)this;
    }

    @Override
    public ModifierKind getVisibility() {
        if (this.getModifiers().contains((Object)ModifierKind.PUBLIC)) {
            return ModifierKind.PUBLIC;
        }
        if (this.getModifiers().contains((Object)ModifierKind.PROTECTED)) {
            return ModifierKind.PROTECTED;
        }
        if (this.getModifiers().contains((Object)ModifierKind.PRIVATE)) {
            return ModifierKind.PRIVATE;
        }
        return null;
    }
}

