/*
 * Decompiled with CFR 0.152.
 */
package spoon.support.reflect.declaration;

import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.apache.log4j.Logger;
import spoon.Launcher;
import spoon.processing.FactoryAccessor;
import spoon.reflect.cu.SourcePosition;
import spoon.reflect.declaration.CtAnnotation;
import spoon.reflect.declaration.CtElement;
import spoon.reflect.declaration.CtNamedElement;
import spoon.reflect.declaration.ParentNotInitializedException;
import spoon.reflect.factory.Factory;
import spoon.reflect.reference.CtReference;
import spoon.reflect.reference.CtTypeReference;
import spoon.reflect.visitor.CtScanner;
import spoon.reflect.visitor.DefaultJavaPrettyPrinter;
import spoon.reflect.visitor.Filter;
import spoon.reflect.visitor.ModelConsistencyChecker;
import spoon.reflect.visitor.Query;
import spoon.reflect.visitor.ReferenceFilter;
import spoon.reflect.visitor.filter.AnnotationFilter;
import spoon.support.reflect.declaration.CtUncomparableException;
import spoon.support.util.RtHelper;
import spoon.support.visitor.SignaturePrinter;
import spoon.support.visitor.TypeReferenceScanner;

public abstract class CtElementImpl
implements CtElement,
Serializable,
Comparable<CtElement> {
    private static final long serialVersionUID = 1L;
    protected static final Logger LOGGER = Logger.getLogger(CtElementImpl.class);
    public static final String ERROR_MESSAGE_TO_STRING = "Error in printing the node. One parent isn't initialized!";
    private static final Set<Object> EMPTY_SET = new UnModifiableCollection();
    private static final Set<Object> EMPTY_LIST = new UnModifiableCollection();
    transient Factory factory;
    List<CtAnnotation<? extends Annotation>> annotations = CtElementImpl.emptyList();
    String docComment;
    CtElement parent;
    SourcePosition position;
    boolean implicit = false;

    public static <T> List<T> emptyList() {
        return (List)((Object)EMPTY_LIST);
    }

    public static <T> Set<T> emptySet() {
        return EMPTY_SET;
    }

    public static <T> Collection<T> emptyCollection() {
        return EMPTY_LIST;
    }

    @Override
    public String getSignature() {
        SignaturePrinter pr = new SignaturePrinter();
        pr.scan(this);
        return pr.getSignature();
    }

    @Override
    public Factory getFactory() {
        return this.factory;
    }

    @Override
    public void setFactory(Factory factory) {
        this.factory = factory;
        LOGGER.setLevel(factory.getEnvironment().getLevel());
    }

    @Override
    public int compareTo(CtElement o) {
        String current = this.getSignature();
        String other = o.getSignature();
        if (current.length() <= 0 || other.length() <= 0) {
            throw new ClassCastException("Unable to compare elements");
        }
        return current.compareTo(other);
    }

    public boolean equals(Object o) {
        if (!(o instanceof CtElement)) {
            return false;
        }
        String current = this.getSignature();
        String other = ((CtElement)o).getSignature();
        return current.equals(other);
    }

    @Override
    public <A extends Annotation> A getAnnotation(Class<A> annotationType) {
        for (CtAnnotation<? extends Annotation> a : this.getAnnotations()) {
            if (!a.getAnnotationType().toString().equals(annotationType.getName().replace('$', '.'))) continue;
            return (A)a.getActualAnnotation();
        }
        return null;
    }

    @Override
    public <A extends Annotation> CtAnnotation<A> getAnnotation(CtTypeReference<A> annotationType) {
        for (CtAnnotation<? extends Annotation> a : this.getAnnotations()) {
            if (!a.getAnnotationType().equals(annotationType)) continue;
            return a;
        }
        return null;
    }

    @Override
    public List<CtAnnotation<? extends Annotation>> getAnnotations() {
        return Collections.unmodifiableList(this.annotations);
    }

    @Override
    public String getDocComment() {
        return this.docComment;
    }

    @Override
    public CtElement getParent() throws ParentNotInitializedException {
        if (this.parent == null) {
            String exceptionMsg = "";
            exceptionMsg = this instanceof CtNamedElement ? "parent not initialized for " + ((CtNamedElement)((Object)this)).getSimpleName() + "(" + this.getClass() + ")" + (this.getPosition() != null ? " " + this.getPosition() : " (?)") : "parent not initialized for " + this.getClass() + (this.getPosition() != null ? " " + this.getPosition() : " (?)");
            throw new ParentNotInitializedException(exceptionMsg);
        }
        return this.parent;
    }

    @Override
    public <P extends CtElement> P getParent(Class<P> parentType) throws ParentNotInitializedException {
        if (this.getParent() == null) {
            return null;
        }
        if (parentType.isAssignableFrom(this.getParent().getClass())) {
            return (P)this.getParent();
        }
        return this.getParent().getParent(parentType);
    }

    @Override
    public boolean hasParent(CtElement candidate) throws ParentNotInitializedException {
        return this.getParent() == candidate || this.getParent().hasParent(candidate);
    }

    @Override
    public SourcePosition getPosition() {
        if (this.position != null) {
            return this.position;
        }
        return null;
    }

    public int hashCode() {
        return this.getSignature().hashCode();
    }

    public void replace(CtElement element) {
        try {
            this.replaceIn(this, element, this.getParent());
        }
        catch (CtUncomparableException ctUncomparableException) {
        }
        catch (Exception e1) {
            Launcher.LOGGER.error((Object)e1.getMessage(), (Throwable)e1);
        }
    }

    private <T extends FactoryAccessor> void replaceIn(Object toReplace, T replacement, Object parent) throws IllegalArgumentException, IllegalAccessException {
        for (Field f : RtHelper.getAllFields(parent.getClass())) {
            f.setAccessible(true);
            Object tmp = f.get(parent);
            if (tmp == null) continue;
            if (tmp instanceof List) {
                List lst = (List)tmp;
                for (int i = 0; i < lst.size(); ++i) {
                    if (lst.get(i) == null || !this.compare(lst.get(i), toReplace)) continue;
                    lst.remove(i);
                    if (replacement == null) continue;
                    lst.add(i, this.getReplacement(replacement, parent));
                }
                continue;
            }
            if (tmp instanceof Collection) {
                Object[] array;
                Collection collect = (Collection)tmp;
                for (Object obj : array = collect.toArray()) {
                    if (!this.compare(obj, toReplace)) continue;
                    collect.remove(obj);
                    collect.add(this.getReplacement(replacement, parent));
                }
                continue;
            }
            if (!this.compare(tmp, toReplace)) continue;
            f.set(parent, this.getReplacement(replacement, parent));
        }
    }

    private <T extends FactoryAccessor> T getReplacement(T replacement, Object parent) {
        if (replacement instanceof CtElement && parent instanceof CtElement) {
            ((CtElement)replacement).setParent((CtElement)parent);
        }
        return replacement;
    }

    private boolean compare(Object o1, Object o2) {
        return o1 == o2;
    }

    @Override
    public <E extends CtElement> E setAnnotations(List<CtAnnotation<? extends Annotation>> annotations) {
        this.annotations.clear();
        for (CtAnnotation<? extends Annotation> annot : annotations) {
            this.addAnnotation(annot);
        }
        return (E)this;
    }

    @Override
    public <E extends CtElement> E addAnnotation(CtAnnotation<? extends Annotation> annotation) {
        if (this.annotations == CtElementImpl.emptyList()) {
            this.annotations = new ArrayList<CtAnnotation<? extends Annotation>>(2);
        }
        annotation.setParent(this);
        this.annotations.add(annotation);
        return (E)this;
    }

    @Override
    public boolean removeAnnotation(CtAnnotation<? extends Annotation> annotation) {
        return this.annotations != CtElementImpl.emptyList() && this.annotations.remove(annotation);
    }

    @Override
    public <E extends CtElement> E setDocComment(String docComment) {
        this.docComment = docComment;
        return (E)this;
    }

    @Override
    public <E extends CtElement> E setParent(CtElement parentElement) {
        this.parent = parentElement;
        return (E)this;
    }

    @Override
    public <E extends CtElement> E setPosition(SourcePosition position) {
        this.position = position;
        return (E)this;
    }

    @Override
    public <E extends CtElement> E setPositions(final SourcePosition position) {
        this.accept(new CtScanner(){

            @Override
            public void enter(CtElement e) {
                e.setPosition(position);
            }
        });
        return (E)this;
    }

    public String toString() {
        DefaultJavaPrettyPrinter printer = new DefaultJavaPrettyPrinter(this.getFactory().getEnvironment());
        String errorMessage = "";
        try {
            printer.computeImports(this);
            printer.scan(this);
        }
        catch (ParentNotInitializedException ignore) {
            errorMessage = ERROR_MESSAGE_TO_STRING;
        }
        return printer.toString() + errorMessage;
    }

    @Override
    public <E extends CtElement> List<E> getAnnotatedChildren(Class<? extends Annotation> annotationType) {
        return Query.getElements(this, new AnnotationFilter<CtElement>(CtElement.class, annotationType));
    }

    @Override
    public boolean isImplicit() {
        return this.implicit;
    }

    @Override
    public <E extends CtElement> E setImplicit(boolean implicit) {
        this.implicit = implicit;
        return (E)this;
    }

    @Override
    public Set<CtTypeReference<?>> getReferencedTypes() {
        TypeReferenceScanner s = new TypeReferenceScanner();
        s.scan(this);
        return s.getReferences();
    }

    @Override
    public <E extends CtElement> List<E> getElements(Filter<E> filter) {
        return Query.getElements(this, filter);
    }

    @Override
    public <T extends CtReference> List<T> getReferences(ReferenceFilter<T> filter) {
        return Query.getReferences(this, filter);
    }

    @Override
    public void updateAllParentsBelow() {
        new ModelConsistencyChecker(this.getFactory().getEnvironment(), true, true).scan(this);
    }

    @Override
    public boolean isParentInitialized() {
        return this.parent != null;
    }

    private static class UnModifiableCollection
    extends ArrayList<Object>
    implements Set<Object> {
        private static final long serialVersionUID = 1L;

        private UnModifiableCollection() {
        }

        @Override
        public Object set(int index, Object element) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void add(int index, Object element) {
            throw new UnsupportedOperationException();
        }

        @Override
        public Object remove(int index) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean addAll(int index, Collection<? extends Object> c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public <T> T[] toArray(T[] a) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean add(Object e) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean containsAll(Collection<?> c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean addAll(Collection<?> c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean retainAll(Collection<?> c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean removeAll(Collection<?> c) {
            throw new UnsupportedOperationException();
        }
    }
}

