/*
 * Decompiled with CFR 0.152.
 */
package spoon.support.reflect.declaration;

import java.util.Set;
import java.util.TreeSet;
import spoon.reflect.cu.SourcePosition;
import spoon.reflect.declaration.CtPackage;
import spoon.reflect.declaration.CtType;
import spoon.reflect.reference.CtPackageReference;
import spoon.reflect.visitor.CtVisitor;
import spoon.support.reflect.declaration.CtNamedElementImpl;

public class CtPackageImpl
extends CtNamedElementImpl
implements CtPackage {
    private static final long serialVersionUID = 1L;
    private Set<CtPackage> packs = new TreeSet<CtPackage>();
    private Set<CtType<?>> types = new TreeSet();

    @Override
    public void accept(CtVisitor v) {
        v.visitCtPackage(this);
    }

    @Override
    public <T extends CtPackage> T addPackage(CtPackage pack) {
        pack.setParent(this);
        this.packs.add(pack);
        return (T)this;
    }

    @Override
    public boolean removePackage(CtPackage pack) {
        return this.packs.remove(pack);
    }

    @Override
    public CtPackage getDeclaringPackage() {
        return this.getParent(CtPackage.class);
    }

    @Override
    public CtPackage getPackage(String name) {
        for (CtPackage p : this.packs) {
            if (!p.getSimpleName().equals(name)) continue;
            return p;
        }
        return null;
    }

    @Override
    public Set<CtPackage> getPackages() {
        return this.packs;
    }

    @Override
    public String getQualifiedName() {
        if (this.getDeclaringPackage() == null || "unnamed package".equals(((CtPackageImpl)this.getDeclaringPackage()).simpleName)) {
            return this.getSimpleName();
        }
        return this.getDeclaringPackage().getQualifiedName() + "." + this.getSimpleName();
    }

    @Override
    public <T extends CtType<?>> T getType(String simpleName) {
        for (CtType<?> t : this.types) {
            if (!t.getSimpleName().equals(simpleName)) continue;
            return (T)t;
        }
        return null;
    }

    @Override
    public Set<CtType<?>> getTypes() {
        return this.types;
    }

    @Override
    public <T extends CtPackage> T setPackages(Set<CtPackage> packs) {
        this.packs.clear();
        for (CtPackage p : packs) {
            this.addPackage(p);
        }
        return (T)this;
    }

    @Override
    public <T extends CtPackage> T setTypes(Set<CtType<?>> types) {
        this.types.clear();
        for (CtType<?> t : types) {
            this.addType(t);
        }
        return (T)this;
    }

    @Override
    public CtPackageReference getReference() {
        return this.getFactory().Package().createReference(this);
    }

    @Override
    public <T extends CtPackage> T addType(CtType<?> type) {
        type.setParent(this);
        this.types.add(type);
        return (T)this;
    }

    @Override
    public void removeType(CtType<?> type) {
        this.types.remove(type);
    }

    @Override
    public SourcePosition getPosition() {
        return this.position;
    }

    @Override
    public String toString() {
        return this.getQualifiedName();
    }
}

