/*
 * Decompiled with CFR 0.152.
 */
package spoon.support.reflect.declaration;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import spoon.reflect.declaration.CtAnnotation;
import spoon.reflect.declaration.CtAnnotationType;
import spoon.reflect.declaration.CtClass;
import spoon.reflect.declaration.CtElement;
import spoon.reflect.declaration.CtEnum;
import spoon.reflect.declaration.CtExecutable;
import spoon.reflect.declaration.CtField;
import spoon.reflect.declaration.CtGenericElement;
import spoon.reflect.declaration.CtInterface;
import spoon.reflect.declaration.CtMethod;
import spoon.reflect.declaration.CtModifiable;
import spoon.reflect.declaration.CtPackage;
import spoon.reflect.declaration.CtType;
import spoon.reflect.declaration.ModifierKind;
import spoon.reflect.declaration.ParentNotInitializedException;
import spoon.reflect.reference.CtArrayTypeReference;
import spoon.reflect.reference.CtExecutableReference;
import spoon.reflect.reference.CtFieldReference;
import spoon.reflect.reference.CtPackageReference;
import spoon.reflect.reference.CtReference;
import spoon.reflect.reference.CtTypeReference;
import spoon.reflect.reference.CtVariableReference;
import spoon.reflect.visitor.CtScanner;
import spoon.reflect.visitor.Query;
import spoon.reflect.visitor.filter.ReferenceTypeFilter;
import spoon.support.compiler.SnippetCompilationHelper;
import spoon.support.reflect.declaration.CtElementImpl;
import spoon.support.reflect.declaration.CtNamedElementImpl;

public abstract class CtTypeImpl<T>
extends CtNamedElementImpl
implements CtType<T> {
    private static final long serialVersionUID = 1L;
    List<CtTypeReference<?>> formalTypeParameters = CtTypeImpl.emptyList();
    Set<CtTypeReference<?>> interfaces = CtTypeImpl.emptySet();
    Set<CtMethod<?>> methods = CtTypeImpl.emptySet();
    private List<CtField<?>> fields = new ArrayList(4);
    Set<CtType<?>> nestedTypes = CtTypeImpl.emptySet();
    Set<ModifierKind> modifiers = CtTypeImpl.emptySet();

    @Override
    public <F, C extends CtType<T>> C addField(CtField<F> field) {
        if (!this.fields.contains(field)) {
            field.setParent(this);
            this.fields.add(field);
        }
        return (C)this;
    }

    @Override
    public <F> boolean removeField(CtField<F> field) {
        return this.fields.remove(field);
    }

    @Override
    public CtField<?> getField(String name) {
        for (CtField<?> f : this.fields) {
            if (!f.getSimpleName().equals(name)) continue;
            return f;
        }
        return null;
    }

    @Override
    public List<CtField<?>> getFields() {
        return this.fields;
    }

    @Override
    public <N, C extends CtType<T>> C addNestedType(CtType<N> nestedType) {
        if (this.nestedTypes == CtElementImpl.emptySet()) {
            this.nestedTypes = new TreeSet();
        }
        nestedType.setParent(this);
        this.nestedTypes.add(nestedType);
        return (C)this;
    }

    @Override
    public <N> boolean removeNestedType(CtType<N> nestedType) {
        if (this.nestedTypes.isEmpty()) {
            return false;
        }
        if (this.nestedTypes.size() == 1) {
            if (this.nestedTypes.contains(nestedType)) {
                this.nestedTypes = CtElementImpl.emptySet();
                return true;
            }
            return false;
        }
        return this.nestedTypes.remove(nestedType);
    }

    @Override
    public Set<CtTypeReference<?>> getUsedTypes(boolean includeSamePackage) {
        HashSet typeRefs = new HashSet();
        for (CtTypeReference typeRef : Query.getReferences(this, new ReferenceTypeFilter(CtTypeReference.class))) {
            if (typeRef.isPrimitive() || typeRef instanceof CtArrayTypeReference || typeRef.toString().equals("<nulltype>") || typeRef.getPackage() != null && "java.lang".equals(typeRef.getPackage().toString()) || !includeSamePackage && CtTypeImpl.getPackageReference(typeRef).equals(this.getPackage().getReference())) continue;
            typeRefs.add(typeRef);
        }
        return typeRefs;
    }

    private static CtPackageReference getPackageReference(CtTypeReference<?> tref) {
        CtPackageReference pref = tref.getPackage();
        while (pref == null) {
            tref = tref.getDeclaringType();
            pref = tref.getPackage();
        }
        return pref;
    }

    @Override
    public Class<T> getActualClass() {
        return this.getFactory().Type().createReference(this).getActualClass();
    }

    @Override
    public CtType<?> getDeclaringType() {
        try {
            return this.getParent(CtType.class);
        }
        catch (ParentNotInitializedException ex) {
            return null;
        }
    }

    @Override
    public <N extends CtType<?>> N getNestedType(final String name) {
        class NestedTypeScanner
        extends CtScanner {
            CtType<?> type;

            NestedTypeScanner() {
            }

            public void checkType(CtType<?> type) {
                if (type.getSimpleName().equals(name) && CtTypeImpl.this.equals(type.getDeclaringType())) {
                    this.type = type;
                }
            }

            public <U> void visitCtClass(CtClass<U> ctClass) {
                this.scan(ctClass.getNestedTypes());
                this.scan(ctClass.getConstructors());
                this.scan(ctClass.getMethods());
                this.checkType(ctClass);
            }

            public <U> void visitCtInterface(CtInterface<U> intrface) {
                this.scan(intrface.getNestedTypes());
                this.scan(intrface.getMethods());
                this.checkType(intrface);
            }

            public <U extends Enum<?>> void visitCtEnum(CtEnum<U> ctEnum) {
                this.scan(ctEnum.getNestedTypes());
                this.scan(ctEnum.getConstructors());
                this.scan(ctEnum.getMethods());
                this.checkType(ctEnum);
            }

            @Override
            public <A extends Annotation> void visitCtAnnotationType(CtAnnotationType<A> annotationType) {
                this.scan(annotationType.getNestedTypes());
                this.checkType(annotationType);
            }

            CtType<?> getType() {
                return this.type;
            }
        }
        NestedTypeScanner scanner = new NestedTypeScanner();
        scanner.scan(this);
        return (N)scanner.getType();
    }

    @Override
    public Set<CtType<?>> getNestedTypes() {
        return this.nestedTypes;
    }

    @Override
    public CtPackage getPackage() {
        if (this.parent instanceof CtPackage) {
            return (CtPackage)this.parent;
        }
        if (this.parent instanceof CtType) {
            return ((CtType)this.parent).getPackage();
        }
        return null;
    }

    @Override
    public CtTypeReference<T> getReference() {
        return this.getFactory().Type().createReference(this);
    }

    @Override
    public boolean isTopLevel() {
        return this.getDeclaringType() == null && this.getPackage() != null;
    }

    @Override
    public void compileAndReplaceSnippets() {
        SnippetCompilationHelper.compileAndReplaceSnippetsIn(this);
    }

    @Override
    public Set<ModifierKind> getModifiers() {
        return this.modifiers;
    }

    @Override
    public boolean hasModifier(ModifierKind modifier) {
        return this.getModifiers().contains((Object)modifier);
    }

    public <C extends CtModifiable> C setModifiers(Set<ModifierKind> modifiers) {
        this.modifiers = modifiers;
        return (C)this;
    }

    public <C extends CtModifiable> C addModifier(ModifierKind modifier) {
        if (this.modifiers == CtElementImpl.emptySet()) {
            this.modifiers = EnumSet.of(modifier);
        }
        this.modifiers.add(modifier);
        return (C)this;
    }

    @Override
    public boolean removeModifier(ModifierKind modifier) {
        return this.modifiers != CtElementImpl.emptySet() && this.modifiers.remove((Object)modifier);
    }

    public <C extends CtModifiable> C setVisibility(ModifierKind visibility) {
        if (this.modifiers == CtElementImpl.emptySet()) {
            this.modifiers = EnumSet.noneOf(ModifierKind.class);
        }
        this.getModifiers().remove((Object)ModifierKind.PUBLIC);
        this.getModifiers().remove((Object)ModifierKind.PROTECTED);
        this.getModifiers().remove((Object)ModifierKind.PRIVATE);
        this.getModifiers().add(visibility);
        return (C)this;
    }

    @Override
    public ModifierKind getVisibility() {
        if (this.getModifiers().contains((Object)ModifierKind.PUBLIC)) {
            return ModifierKind.PUBLIC;
        }
        if (this.getModifiers().contains((Object)ModifierKind.PROTECTED)) {
            return ModifierKind.PROTECTED;
        }
        if (this.getModifiers().contains((Object)ModifierKind.PRIVATE)) {
            return ModifierKind.PRIVATE;
        }
        return null;
    }

    @Override
    public boolean isPrimitive() {
        return false;
    }

    @Override
    public boolean isAnonymous() {
        return false;
    }

    @Override
    public CtTypeReference<?> getSuperclass() {
        return null;
    }

    @Override
    public boolean isInterface() {
        return false;
    }

    public List<CtFieldReference<?>> getAllFields() {
        CtTypeReference<?> st;
        ArrayList l = new ArrayList(this.getFields().size());
        for (CtField<?> f : this.getFields()) {
            l.add((CtFieldReference<?>)f.getReference());
        }
        if (this instanceof CtClass && (st = ((CtClass)((Object)this)).getSuperclass()) != null) {
            l.addAll(st.getAllFields());
        }
        return l;
    }

    @Override
    public Collection<CtFieldReference<?>> getDeclaredFields() {
        ArrayList<CtVariableReference> l = new ArrayList<CtVariableReference>(this.getFields().size());
        for (CtField<?> f : this.getFields()) {
            l.add(f.getReference());
        }
        return Collections.unmodifiableCollection(l);
    }

    @Override
    public boolean isSubtypeOf(CtTypeReference<?> type) {
        return type.isSubtypeOf((CtTypeReference<?>)this.getReference());
    }

    @Override
    public boolean isAssignableFrom(CtTypeReference<?> type) {
        return this.isSubtypeOf(type);
    }

    @Override
    public <M, C extends CtType<T>> C addMethod(CtMethod<M> method) {
        if (this.methods == CtElementImpl.emptySet()) {
            this.methods = new TreeSet();
        }
        method.setParent(this);
        this.methods.add(method);
        return (C)this;
    }

    @Override
    public <M> boolean removeMethod(CtMethod<M> method) {
        if (this.methods.isEmpty()) {
            return false;
        }
        if (this.methods.size() == 1) {
            if (this.methods.contains(method)) {
                this.methods = CtElementImpl.emptySet();
                return true;
            }
            return false;
        }
        return this.methods.contains(method) && this.methods.remove(method);
    }

    @Override
    public <S, C extends CtType<T>> C addSuperInterface(CtTypeReference<S> interfac) {
        if (this.interfaces == CtElementImpl.emptySet()) {
            this.interfaces = new TreeSet();
        }
        this.interfaces.add(interfac);
        return (C)this;
    }

    @Override
    public <S> boolean removeSuperInterface(CtTypeReference<S> interfac) {
        if (this.interfaces.isEmpty()) {
            return false;
        }
        if (this.interfaces.size() == 1) {
            if (this.interfaces.contains(interfac)) {
                this.interfaces = CtElementImpl.emptySet();
                return true;
            }
            return false;
        }
        return this.interfaces.contains(interfac) && this.interfaces.remove(interfac);
    }

    public <C extends CtGenericElement> C addFormalTypeParameter(CtTypeReference<?> formalTypeParameter) {
        if (this.formalTypeParameters == CtElementImpl.emptyList()) {
            this.formalTypeParameters = new ArrayList(2);
        }
        this.formalTypeParameters.add(formalTypeParameter);
        return (C)this;
    }

    @Override
    public boolean removeFormalTypeParameter(CtTypeReference<?> formalTypeParameter) {
        return this.formalTypeParameters.contains(formalTypeParameter) && this.formalTypeParameters.remove(formalTypeParameter);
    }

    @Override
    public List<CtTypeReference<?>> getFormalTypeParameters() {
        return this.formalTypeParameters;
    }

    @Override
    public <R> CtMethod<R> getMethod(CtTypeReference<R> returnType, String name, CtTypeReference<?> ... parameterTypes) {
        for (CtMethod<?> mm : this.methods) {
            CtMethod<?> m = mm;
            if (!m.getSimpleName().equals(name) || !m.getType().equals(returnType)) continue;
            boolean cont = m.getParameters().size() == parameterTypes.length;
            for (int i = 0; cont && i < m.getParameters().size() && i < parameterTypes.length; ++i) {
                if (m.getParameters().get(i).getType().getQualifiedName().equals(parameterTypes[i].getQualifiedName())) continue;
                cont = false;
            }
            if (!cont) continue;
            return m;
        }
        return null;
    }

    @Override
    public <R> CtMethod<R> getMethod(String name, CtTypeReference<?> ... parameterTypes) {
        for (CtMethod<?> m : this.methods) {
            if (!m.getSimpleName().equals(name)) continue;
            boolean cont = m.getParameters().size() == parameterTypes.length;
            for (int i = 0; cont && i < m.getParameters().size() && i < parameterTypes.length; ++i) {
                if (m.getParameters().get(i).getType().equals(parameterTypes[i])) continue;
                cont = false;
            }
            if (!cont) continue;
            return m;
        }
        return null;
    }

    @Override
    public Set<CtMethod<?>> getMethods() {
        return this.methods;
    }

    @Override
    public Set<CtMethod<?>> getMethodsAnnotatedWith(CtTypeReference<?> ... annotationTypes) {
        HashSet result = new HashSet();
        for (CtMethod<?> m : this.methods) {
            for (CtAnnotation<? extends Annotation> a : m.getAnnotations()) {
                if (!Arrays.asList(annotationTypes).contains(a.getAnnotationType())) continue;
                result.add(m);
            }
        }
        return result;
    }

    @Override
    public List<CtMethod<?>> getMethodsByName(String name) {
        ArrayList result = new ArrayList(1);
        for (CtMethod<?> m : this.methods) {
            if (!name.equals(m.getSimpleName())) continue;
            result.add(m);
        }
        return result;
    }

    @Override
    public String getQualifiedName() {
        if (this.isTopLevel()) {
            if (this.getPackage() != null && !this.getPackage().getSimpleName().equals("unnamed package")) {
                return this.getPackage().getQualifiedName() + "." + this.getSimpleName();
            }
            return this.getSimpleName();
        }
        if (this.getDeclaringType() != null) {
            return this.getDeclaringType().getQualifiedName() + "$" + this.getSimpleName();
        }
        return this.getSimpleName();
    }

    @Override
    public Set<CtTypeReference<?>> getSuperInterfaces() {
        return this.interfaces;
    }

    public <C extends CtGenericElement> C setFormalTypeParameters(List<CtTypeReference<?>> formalTypeParameters) {
        this.formalTypeParameters = formalTypeParameters;
        return (C)this;
    }

    @Override
    public <C extends CtType<T>> C setMethods(Set<CtMethod<?>> methods) {
        this.methods.clear();
        for (CtMethod<?> meth : methods) {
            this.addMethod(meth);
        }
        return (C)this;
    }

    @Override
    public <C extends CtType<T>> C setSuperInterfaces(Set<CtTypeReference<?>> interfaces) {
        this.interfaces = interfaces;
        return (C)this;
    }

    @Override
    public Collection<CtExecutableReference<?>> getDeclaredExecutables() {
        ArrayList<CtReference> l = new ArrayList<CtReference>(this.getMethods().size());
        for (CtExecutable ctExecutable : this.getMethods()) {
            l.add(ctExecutable.getReference());
        }
        return Collections.unmodifiableCollection(l);
    }

    @Override
    public Collection<CtExecutableReference<?>> getAllExecutables() {
        CtTypeReference<?> st;
        HashSet l = new HashSet(this.getDeclaredExecutables());
        if (this instanceof CtClass && (st = ((CtClass)((Object)this)).getSuperclass()) != null) {
            l.addAll(st.getAllExecutables());
        }
        return l;
    }

    @Override
    public Set<CtMethod<?>> getAllMethods() {
        HashSet l = new HashSet(this.getMethods());
        if (this.getSuperclass() != null && this.getSuperclass().getDeclaration() != null) {
            CtElement t = this.getSuperclass().getDeclaration();
            l.addAll(t.getAllMethods());
        }
        for (CtTypeReference<?> ref : this.getSuperInterfaces()) {
            if (ref.getDeclaration() == null) continue;
            CtElement t = ref.getDeclaration();
            l.addAll(t.getAllMethods());
        }
        return Collections.unmodifiableSet(l);
    }
}

