/*
 * Decompiled with CFR 0.152.
 */
package spoon.support.reflect.reference;

import java.lang.annotation.Annotation;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Executable;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import spoon.Launcher;
import spoon.reflect.code.CtNewClass;
import spoon.reflect.declaration.CtAnnotation;
import spoon.reflect.declaration.CtClass;
import spoon.reflect.declaration.CtElement;
import spoon.reflect.declaration.CtType;
import spoon.reflect.declaration.ModifierKind;
import spoon.reflect.reference.CtArrayTypeReference;
import spoon.reflect.reference.CtExecutableReference;
import spoon.reflect.reference.CtFieldReference;
import spoon.reflect.reference.CtGenericElementReference;
import spoon.reflect.reference.CtPackageReference;
import spoon.reflect.reference.CtTypeAnnotableReference;
import spoon.reflect.reference.CtTypeParameterReference;
import spoon.reflect.reference.CtTypeReference;
import spoon.reflect.visitor.CtVisitor;
import spoon.reflect.visitor.filter.AbstractFilter;
import spoon.support.reflect.declaration.CtElementImpl;
import spoon.support.reflect.reference.CtReferenceImpl;
import spoon.support.reflect.reference.SpoonClassNotFoundException;
import spoon.support.util.RtHelper;

public class CtTypeReferenceImpl<T>
extends CtReferenceImpl
implements CtTypeReference<T> {
    private static final long serialVersionUID = 1L;
    List<CtTypeReference<?>> actualTypeArguments = CtElementImpl.emptyList();
    List<CtAnnotation<? extends Annotation>> annotations = CtElementImpl.emptyList();
    CtTypeReference<?> declaringType;
    private CtPackageReference pack;

    @Override
    public void accept(CtVisitor visitor) {
        visitor.visitCtTypeReference(this);
    }

    @Override
    public CtTypeReference<?> box() {
        if (!this.isPrimitive()) {
            return this;
        }
        if (this.getSimpleName().equals("int")) {
            return this.factory.Type().createReference(Integer.class);
        }
        if (this.getSimpleName().equals("float")) {
            return this.factory.Type().createReference(Float.class);
        }
        if (this.getSimpleName().equals("long")) {
            return this.factory.Type().createReference(Long.class);
        }
        if (this.getSimpleName().equals("char")) {
            return this.factory.Type().createReference(Character.class);
        }
        if (this.getSimpleName().equals("double")) {
            return this.factory.Type().createReference(Double.class);
        }
        if (this.getSimpleName().equals("boolean")) {
            return this.factory.Type().createReference(Boolean.class);
        }
        if (this.getSimpleName().equals("short")) {
            return this.factory.Type().createReference(Short.class);
        }
        if (this.getSimpleName().equals("byte")) {
            return this.factory.Type().createReference(Byte.class);
        }
        if (this.getSimpleName().equals("void")) {
            return this.factory.Type().createReference(Void.class);
        }
        return this;
    }

    @Override
    public Class<T> getActualClass() {
        if (this.isPrimitive()) {
            String simpleN = this.getSimpleName();
            if ("boolean".equals(simpleN)) {
                return Boolean.TYPE;
            }
            if ("byte".equals(simpleN)) {
                return Byte.TYPE;
            }
            if ("double".equals(simpleN)) {
                return Double.TYPE;
            }
            if ("int".equals(simpleN)) {
                return Integer.TYPE;
            }
            if ("short".equals(simpleN)) {
                return Short.TYPE;
            }
            if ("char".equals(simpleN)) {
                return Character.TYPE;
            }
            if ("long".equals(simpleN)) {
                return Long.TYPE;
            }
            if ("float".equals(simpleN)) {
                return Float.TYPE;
            }
            if ("void".equals(simpleN)) {
                return Void.TYPE;
            }
        }
        return this.findClass();
    }

    protected Class<T> findClass() {
        try {
            return this.getFactory().getEnvironment().getClassLoader().loadClass(this.getQualifiedName());
        }
        catch (ClassNotFoundException cnfe) {
            throw new SpoonClassNotFoundException("cannot load class: " + this.getQualifiedName() + " with class loader " + Thread.currentThread().getContextClassLoader(), cnfe);
        }
    }

    @Override
    public List<CtTypeReference<?>> getActualTypeArguments() {
        return this.actualTypeArguments;
    }

    @Override
    protected AnnotatedElement getActualAnnotatedElement() {
        return this.getActualClass();
    }

    @Override
    public CtType<T> getDeclaration() {
        if (!this.isPrimitive() && !this.isAnonymous()) {
            return this.getFactory().Type().get(this.getQualifiedName());
        }
        if (!this.isPrimitive() && this.isAnonymous()) {
            CtType rootType = this.getFactory().Type().get(this.getDeclaringType().getQualifiedName());
            CtNewClass elements = (CtNewClass)rootType.getElements(new AbstractFilter<CtNewClass<?>>(CtNewClass.class){

                @Override
                public boolean matches(CtNewClass<?> element) {
                    return CtTypeReferenceImpl.this.getSimpleName().equals(element.getAnonymousClass().getSimpleName());
                }
            }).get(0);
            return elements.getAnonymousClass();
        }
        return null;
    }

    @Override
    public CtTypeReference<?> getDeclaringType() {
        return this.declaringType;
    }

    @Override
    public CtPackageReference getPackage() {
        return this.pack;
    }

    @Override
    public String getQualifiedName() {
        if (this.getDeclaringType() != null) {
            return this.getDeclaringType().getQualifiedName() + "$" + this.getSimpleName();
        }
        if (this.getPackage() != null && !"unnamed package".equals(this.getPackage().getSimpleName())) {
            if (!this.getTypeAnnotations().isEmpty()) {
                String qualifiedName = this.getPackage().getSimpleName() + ".";
                for (CtAnnotation<Annotation> ctAnnotation : this.getTypeAnnotations()) {
                    qualifiedName = qualifiedName + "@" + ctAnnotation.getAnnotationType().getQualifiedName() + " ";
                }
                qualifiedName = qualifiedName + this.getSimpleName();
                return qualifiedName;
            }
            return this.getPackage().getSimpleName() + "." + this.getSimpleName();
        }
        return this.getSimpleName();
    }

    @Override
    public boolean isAssignableFrom(CtTypeReference<?> type) {
        return type != null && type.isSubtypeOf(this);
    }

    @Override
    public boolean isPrimitive() {
        return this.getSimpleName().equals("boolean") || this.getSimpleName().equals("byte") || this.getSimpleName().equals("double") || this.getSimpleName().equals("int") || this.getSimpleName().equals("short") || this.getSimpleName().equals("char") || this.getSimpleName().equals("long") || this.getSimpleName().equals("float") || this.getSimpleName().equals("void");
    }

    @Override
    public boolean isSubtypeOf(CtTypeReference<?> type) {
        if (type instanceof CtTypeParameterReference) {
            return false;
        }
        if ("<nulltype>".equals(this.getSimpleName()) || "<nulltype>".equals(type.getSimpleName())) {
            return false;
        }
        if (this.isAnonymous() || type.isAnonymous()) {
            return false;
        }
        if (this.isPrimitive() || type.isPrimitive()) {
            return this.equals(type);
        }
        CtElement superTypeDecl = type.getDeclaration();
        CtElement subTypeDecl = this.getDeclaration();
        if (subTypeDecl == null && superTypeDecl == null) {
            try {
                if (this instanceof CtArrayTypeReference && type instanceof CtArrayTypeReference) {
                    return ((CtArrayTypeReference)((Object)this)).getComponentType().isSubtypeOf(((CtArrayTypeReference)type).getComponentType());
                }
                Class<T> actualSubType = this.getActualClass();
                Class<T> actualSuperType = type.getActualClass();
                return actualSuperType.isAssignableFrom(actualSubType);
            }
            catch (Exception e) {
                Launcher.LOGGER.error((Object)("cannot determine runtime types for '" + this + "' (" + this.getActualClass() + ") and '" + type + "' (" + type.getActualClass() + ")"), (Throwable)e);
                return false;
            }
        }
        if (this.getQualifiedName().equals(type.getQualifiedName())) {
            return true;
        }
        if (subTypeDecl != null) {
            for (CtTypeReference<?> ref : subTypeDecl.getSuperInterfaces()) {
                if (!ref.isSubtypeOf(type)) continue;
                return true;
            }
            if (subTypeDecl instanceof CtClass) {
                if (this.getFactory().Type().OBJECT.equals(type)) {
                    return true;
                }
                if (((CtClass)subTypeDecl).getSuperclass() != null) {
                    if (((CtClass)subTypeDecl).getSuperclass().equals(type)) {
                        return true;
                    }
                    return ((CtClass)subTypeDecl).getSuperclass().isSubtypeOf(type);
                }
            }
            return false;
        }
        try {
            Class<T> actualSubType = this.getActualClass();
            for (Class<?> c : actualSubType.getInterfaces()) {
                if (!this.getFactory().Type().createReference(c).isSubtypeOf(type)) continue;
                return true;
            }
            CtTypeReference<T> superType = this.getFactory().Type().createReference(actualSubType.getSuperclass());
            if (superType.equals(type)) {
                return true;
            }
            return superType.isSubtypeOf(type);
        }
        catch (Exception e) {
            Launcher.LOGGER.error((Object)("cannot determine runtime types for '" + this + "' and '" + type + "'"), (Throwable)e);
            return false;
        }
    }

    public <C extends CtGenericElementReference> C setActualTypeArguments(List<CtTypeReference<?>> actualTypeArguments) {
        this.actualTypeArguments = actualTypeArguments;
        return (C)this;
    }

    @Override
    public <C extends CtTypeReference<T>> C setDeclaringType(CtTypeReference<?> declaringType) {
        this.declaringType = declaringType;
        return (C)this;
    }

    @Override
    public <C extends CtTypeReference<T>> C setPackage(CtPackageReference pack) {
        this.pack = pack;
        return (C)this;
    }

    @Override
    public CtTypeReference<?> unbox() {
        if (this.isPrimitive()) {
            return this;
        }
        if (this.getActualClass() == Integer.class) {
            return this.factory.Type().createReference(Integer.TYPE);
        }
        if (this.getActualClass() == Float.class) {
            return this.factory.Type().createReference(Float.TYPE);
        }
        if (this.getActualClass() == Long.class) {
            return this.factory.Type().createReference(Long.TYPE);
        }
        if (this.getActualClass() == Character.class) {
            return this.factory.Type().createReference(Character.TYPE);
        }
        if (this.getActualClass() == Double.class) {
            return this.factory.Type().createReference(Double.TYPE);
        }
        if (this.getActualClass() == Boolean.class) {
            return this.factory.Type().createReference(Boolean.TYPE);
        }
        if (this.getActualClass() == Short.class) {
            return this.factory.Type().createReference(Short.TYPE);
        }
        if (this.getActualClass() == Byte.class) {
            return this.factory.Type().createReference(Byte.TYPE);
        }
        if (this.getActualClass() == Void.class) {
            return this.factory.Type().createReference(Void.TYPE);
        }
        return this;
    }

    @Override
    public Collection<CtFieldReference<?>> getDeclaredFields() {
        ArrayList l = new ArrayList();
        CtElement t = this.getDeclaration();
        if (t == null) {
            for (Field field : this.getActualClass().getDeclaredFields()) {
                l.add(this.getFactory().Field().createReference(field));
            }
            if (this.getActualClass().isAnnotation()) {
                for (AccessibleObject accessibleObject : this.getActualClass().getDeclaredMethods()) {
                    CtTypeReference<?> retRef = this.getFactory().Type().createReference(((Method)accessibleObject).getReturnType());
                    CtFieldReference<?> fr = this.getFactory().Field().createReference(this, retRef, ((Method)accessibleObject).getName());
                    l.add(fr);
                }
            }
        } else {
            return t.getDeclaredFields();
        }
        return l;
    }

    @Override
    public Collection<CtExecutableReference<?>> getDeclaredExecutables() {
        CtElement t = this.getDeclaration();
        if (t == null) {
            return RtHelper.getAllExecutables(this.getActualClass(), this.getFactory());
        }
        return t.getDeclaredExecutables();
    }

    @Override
    public Collection<CtFieldReference<?>> getAllFields() {
        CtElement t = this.getDeclaration();
        if (t == null) {
            return RtHelper.getAllFields(this.getActualClass(), this.getFactory());
        }
        return t.getAllFields();
    }

    @Override
    public Collection<CtExecutableReference<?>> getAllExecutables() {
        Class<T> c;
        ArrayList l = new ArrayList();
        CtElement t = this.getDeclaration();
        if (t == null) {
            c = this.getActualClass();
            for (Method method : c.getDeclaredMethods()) {
                l.add(this.getFactory().Method().createReference(method));
            }
            for (Executable executable : c.getDeclaredConstructors()) {
                CtExecutableReference consRef = this.getFactory().Constructor().createReference(executable);
                l.add(consRef);
            }
        } else {
            return t.getAllExecutables();
        }
        Class<T> sc = c.getSuperclass();
        l.addAll(this.getFactory().Type().createReference(sc).getAllExecutables());
        return l;
    }

    @Override
    public Set<ModifierKind> getModifiers() {
        CtElement t = this.getDeclaration();
        if (t != null) {
            return t.getModifiers();
        }
        Class<T> c = this.getActualClass();
        return RtHelper.getModifiers(c.getModifiers());
    }

    @Override
    public CtTypeReference<?> getSuperclass() {
        CtElement t = this.getDeclaration();
        if (t != null) {
            return t.getSuperclass();
        }
        Class<T> c = this.getActualClass();
        Class<T> sc = c.getSuperclass();
        if (sc == null) {
            return null;
        }
        return this.getFactory().Type().createReference(sc);
    }

    @Override
    public Set<CtTypeReference<?>> getSuperInterfaces() {
        CtElement t = this.getDeclaration();
        if (t != null) {
            return t.getSuperInterfaces();
        }
        Class<T> c = this.getActualClass();
        Class<?>[] sis = c.getInterfaces();
        if (sis != null && sis.length > 0) {
            TreeSet set = new TreeSet();
            for (Class<?> si : sis) {
                set.add(this.getFactory().Type().createReference(si));
            }
            return set;
        }
        return new TreeSet();
    }

    @Override
    public boolean isAnonymous() {
        try {
            Integer.parseInt(this.getSimpleName());
        }
        catch (NumberFormatException e) {
            return false;
        }
        return true;
    }

    public <C extends CtGenericElementReference> C addActualTypeArgument(CtTypeReference<?> actualTypeArgument) {
        if (this.actualTypeArguments == CtElementImpl.emptyList()) {
            this.actualTypeArguments = new ArrayList(2);
        }
        this.actualTypeArguments.add(actualTypeArgument);
        return (C)this;
    }

    @Override
    public boolean removeActualTypeArgument(CtTypeReference<?> actualTypeArgument) {
        return this.actualTypeArguments != CtElementImpl.emptyList() && this.actualTypeArguments.remove(actualTypeArgument);
    }

    @Override
    public boolean isInterface() {
        CtElement t = this.getDeclaration();
        if (t == null) {
            return this.getActualClass().isInterface();
        }
        return t.isInterface();
    }

    @Override
    public List<CtAnnotation<? extends Annotation>> getTypeAnnotations() {
        return Collections.unmodifiableList(this.annotations);
    }

    public <C extends CtTypeAnnotableReference> C setTypeAnnotations(List<CtAnnotation<? extends Annotation>> annotations) {
        this.annotations = annotations;
        return (C)this;
    }

    public <C extends CtTypeAnnotableReference> C addTypeAnnotation(CtAnnotation<? extends Annotation> annotation) {
        if (annotation == null) {
            return (C)this;
        }
        if (this.annotations == CtElementImpl.emptyList()) {
            this.annotations = new ArrayList<CtAnnotation<? extends Annotation>>(2);
        }
        this.annotations.add(annotation);
        return (C)this;
    }

    @Override
    public boolean removeTypeAnnotation(CtAnnotation<? extends Annotation> annotation) {
        return annotation != null && this.annotations.remove(annotation);
    }
}

