/*
 * Decompiled with CFR 0.152.
 */
package spoon.support.util;

import java.util.Collection;
import java.util.Comparator;
import java.util.LinkedList;

public class SortedList<E>
extends LinkedList<E> {
    private static final long serialVersionUID = 1L;
    Comparator<? super E> comparator;

    public SortedList(Comparator<? super E> comparator) {
        this.comparator = comparator;
    }

    @Override
    public boolean add(E o) {
        for (Object e : this) {
            if (this.comparator.compare(o, e) >= 0) continue;
            this.add(this.indexOf(e), o);
            return true;
        }
        return super.add(o);
    }

    @Override
    public boolean addAll(Collection<? extends E> c) {
        boolean ret = true;
        for (E e : c) {
            ret &= this.add(e);
        }
        return ret;
    }

    public Comparator<? super E> getComparator() {
        return this.comparator;
    }

    public void setComparator(Comparator<? super E> comparator) {
        this.comparator = comparator;
    }
}

