/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.fix.include.util;

import java.nio.ByteBuffer;
import net.openhft.compiler.CachedCompiler;
import net.openhft.fix.compiler.FieldLookup;
import net.openhft.fix.include.util.FixConstants;
import net.openhft.fix.include.v42.Components;
import net.openhft.fix.include.v42.Field;
import net.openhft.fix.include.v42.Fields;
import net.openhft.fix.include.v42.FixMessageType;
import net.openhft.fix.include.v42.Group;
import net.openhft.fix.include.v42.Header;
import net.openhft.fix.include.v42.Message;
import net.openhft.fix.include.v42.Messages;
import net.openhft.fix.include.v42.Trailer;
import net.openhft.lang.collection.HugeArray;
import net.openhft.lang.io.ByteBufferBytes;
import net.openhft.lang.io.Bytes;
import net.openhft.lang.model.Byteable;
import net.openhft.lang.model.DataValueGenerator;

public class FixConfig
implements Cloneable {
    private int fixVersionMajor;
    private int fixVersionMinor;
    private int fixVersionServicePack;
    private int currentFixVersion;
    private int fix4_2_0_mask = 420;
    private int fix5_0_0_mask = 500;
    private final DataValueGenerator dvg = new DataValueGenerator();
    private Trailer trailer;
    private Header header;
    private Messages messages;
    private Components components;
    private Fields fields;
    public static FixConfig SERVER_DEFAULT_4_2 = new FixConfig().setFixVersionMajor(4).setFixVersionMinor(2).setFixVersionServicePack(0).createServerFixFields();
    private Field[] fieldArr;

    public FixConfig clone() {
        try {
            return (FixConfig)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new AssertionError((Object)e);
        }
    }

    public FixConfig createServerFixHeader() {
        if ((this.currentFixVersion & this.fix4_2_0_mask) != 0) {
            try {
                this.load42DefaultHeader();
            }
            catch (Exception e) {
                throw new AssertionError((Object)e);
            }
        }
        return this;
    }

    private void load42DefaultHeader() throws Exception {
        String actual = new DataValueGenerator().generateNativeObject(FixMessageType.class);
        CachedCompiler cc = new CachedCompiler(null, null);
        Class aClass = cc.loadFromJava(FixMessageType.class.getName() + "$$Native", actual);
        FixMessageType fmt = aClass.asSubclass(FixMessageType.class).newInstance();
        ByteBufferBytes bytes = new ByteBufferBytes(ByteBuffer.allocate(0x100000));
        ((Byteable)fmt).bytes((Bytes)bytes, 0L);
        this.header = (Header)fmt;
        HugeArray<Field> array = this.header.setFieldSize(27).getField();
        Field field = null;
        for (int i = 0; i < FixConstants.headerFieldName.length; i = (int)((short)(i + 1))) {
            field = (Field)array.get((long)i);
            field.setName(FixConstants.headerFieldName[i]);
            if (i < 5) {
                field.setRequired("Y");
                continue;
            }
            field.setRequired("N");
        }
    }

    public FixConfig createServerFixMessages() {
        if ((this.currentFixVersion & this.fix4_2_0_mask) != 0) {
            this.load42DefaultMessages();
        }
        return this;
    }

    private void load42DefaultMessages() {
        this.messages = new Messages();
        HugeArray<Message> array = this.messages.setMessagesSize(46).getMessage();
        Message message = null;
        for (int i = 0; i < FixConstants.messsagesMsgName.length; i = (int)((short)(i + 1))) {
            message = (Message)array.get((long)i);
            message.setName(FixConstants.messsagesMsgName[i]);
            message.setMsgtype(FixConstants.messagesMsgType[i]);
            this.populateMessage(i, message);
        }
    }

    private void populateMessage(int msgNo, Message message) {
        HugeArray<Field> arrayField = null;
        HugeArray<Group> arrayGroup = null;
        HugeArray<Group> arrayInnerGroup = null;
        int[] fieldYesArray = null;
        Object fieldArray = null;
        int[] groupYesArray = null;
        String[] groupArray = null;
        int[] groupFieldSize = null;
        Object groupFieldYesArray = null;
        String[] groupField = null;
        int[] innerGroupFieldSize = null;
        String[] innerGroupField = null;
        String[] innerGroup = null;
        switch (msgNo) {
            case 0: {
                message.setMsgcat(FixConstants.messagesMsgCat[0]);
                arrayField = null;
                arrayField = message.setFieldSize(1).getField();
                ((Field)arrayField.get(0L)).setName("TestReqID");
                ((Field)arrayField.get(0L)).setRequired("N");
            }
            case 1: {
                message.setMsgcat(FixConstants.messagesMsgCat[0]);
                arrayField = null;
                arrayField = message.setFieldSize(1).getField();
                ((Field)arrayField.get(0L)).setName("TestReqID");
                ((Field)arrayField.get(0L)).setRequired("Y");
            }
            case 2: {
                message.setMsgcat(FixConstants.messagesMsgCat[0]);
                arrayField = null;
                arrayField = message.setFieldSize(FixConstants.messagesResendReq.length).getField();
                int i = 0;
                while ((long)i < arrayField.length()) {
                    ((Field)arrayField.get((long)i)).setName(FixConstants.messagesResendReq[i]);
                    ((Field)arrayField.get((long)i)).setRequired("Y");
                    i = (short)(i + 1);
                }
            }
            case 3: {
                message.setMsgcat(FixConstants.messagesMsgCat[0]);
                arrayField = null;
                arrayField = message.setFieldSize(FixConstants.messagesReject.length).getField();
                int i = 0;
                while ((long)i < arrayField.length()) {
                    ((Field)arrayField.get((long)i)).setName(FixConstants.messagesReject[i]);
                    if (i == 0) {
                        ((Field)arrayField.get((long)i)).setRequired("Y");
                    } else {
                        ((Field)arrayField.get((long)i)).setRequired("N");
                    }
                    i = (short)(i + 1);
                }
            }
            case 4: {
                message.setMsgcat(FixConstants.messagesMsgCat[0]);
                arrayField = null;
                arrayField = message.setFieldSize(FixConstants.messagesSeqReset.length).getField();
                int i = 0;
                while ((long)i < arrayField.length()) {
                    ((Field)arrayField.get((long)i)).setName(FixConstants.messagesSeqReset[i]);
                    if (i == 0) {
                        ((Field)arrayField.get((long)i)).setRequired("N");
                    } else {
                        ((Field)arrayField.get((long)i)).setRequired("Y");
                    }
                    i = (short)(i + 1);
                }
            }
            case 5: {
                message.setMsgcat(FixConstants.messagesMsgCat[0]);
                arrayField = null;
                arrayField = message.setFieldSize(FixConstants.messagesLogout.length).getField();
                int i = 0;
                while ((long)i < arrayField.length()) {
                    ((Field)arrayField.get((long)i)).setName(FixConstants.messagesLogout[i]);
                    ((Field)arrayField.get((long)i)).setRequired("N");
                    i = (short)(i + 1);
                }
            }
            case 6: {
                int j;
                message.setMsgcat(FixConstants.messagesMsgCat[1]);
                arrayField = null;
                arrayGroup = null;
                arrayField = message.setFieldSize(FixConstants.messagesIOI.length).getField();
                arrayGroup = message.setGroupSize(FixConstants.messagesIOIGroup.length).getGroup();
                int i = 0;
                while ((long)i < arrayField.length()) {
                    ((Field)arrayField.get((long)i)).setName(FixConstants.messagesIOI[i]);
                    if (i == 0 || i == 1 || i == 3 || i == 22 || i == 23) {
                        ((Field)arrayField.get((long)i)).setRequired("Y");
                    } else {
                        ((Field)arrayField.get((long)i)).setRequired("N");
                    }
                    i = (short)(i + 1);
                }
                i = 0;
                while ((long)i < arrayGroup.length()) {
                    ((Group)arrayGroup.get((long)i)).setName(FixConstants.messagesIOIGroup[i]);
                    ((Group)arrayGroup.get((long)i)).setRequired("N");
                    arrayField = null;
                    if (i == 0) {
                        arrayField = ((Group)arrayGroup.get((long)i)).setFieldSize(1).getField();
                        ((Field)arrayField.get(0L)).setName(FixConstants.messagesIOIGroupFields[0]);
                        ((Field)arrayField.get(0L)).setRequired("N");
                    } else {
                        arrayField = ((Group)arrayGroup.get((long)i)).setFieldSize(FixConstants.messagesIOIGroupFields.length).getField();
                        j = 0;
                        while ((long)j < arrayField.length()) {
                            ((Field)arrayField.get(0L)).setName(FixConstants.messagesIOIGroupFields[j + 1]);
                            ((Field)arrayField.get(0L)).setRequired("N");
                            j = (short)(j + 1);
                        }
                    }
                    i = (short)(i + 1);
                }
            }
            case 7: {
                message.setMsgcat(FixConstants.messagesMsgCat[1]);
                arrayField = null;
                arrayField = message.setFieldSize(FixConstants.messagesAdv.length).getField();
                int i = 0;
                while ((long)i < arrayField.length()) {
                    ((Field)arrayField.get((long)i)).setName(FixConstants.messagesAdv[i]);
                    if (i == 0 || i == 1 || i == 3 || i == 22 || i == 23) {
                        ((Field)arrayField.get((long)i)).setRequired("Y");
                    } else {
                        ((Field)arrayField.get((long)i)).setRequired("N");
                    }
                    i = (short)(i + 1);
                }
            }
            case 8: {
                message.setMsgcat(FixConstants.messagesMsgCat[1]);
                arrayField = null;
                arrayGroup = null;
                arrayField = message.setFieldSize(FixConstants.messageExecReport.length).getField();
                arrayGroup = message.setGroupSize(1).getGroup();
                int i = 0;
                while ((long)i < arrayField.length()) {
                    ((Field)arrayField.get((long)i)).setName(FixConstants.messageExecReport[i]);
                    if (i == 0 || i == 1 || i == 3 || i == 22 || i == 23) {
                        ((Field)arrayField.get((long)i)).setRequired("Y");
                    } else {
                        ((Field)arrayField.get((long)i)).setRequired("N");
                    }
                    i = (short)(i + 1);
                }
                ((Group)arrayGroup.get(0L)).setName("NoContraBrokers");
                ((Group)arrayGroup.get(0L)).setRequired("N");
                arrayField = null;
                arrayField = ((Group)arrayGroup.get(0L)).setFieldSize(FixConstants.messageExecReportGrpFlds.length).getField();
                int j2 = 0;
                while ((long)j2 < arrayField.length()) {
                    ((Field)arrayField.get(0L)).setName(FixConstants.messageExecReportGrpFlds[j2]);
                    ((Field)arrayField.get(0L)).setRequired("N");
                    j2 = (short)(j2 + 1);
                }
            }
            case 9: {
                message.setMsgcat(FixConstants.messagesMsgCat[1]);
                arrayField = null;
                arrayField = message.setFieldSize(FixConstants.messageOrderCancelRej.length).getField();
                int i = 0;
                while ((long)i < arrayField.length()) {
                    ((Field)arrayField.get((long)i)).setName(FixConstants.messageOrderCancelRej[i]);
                    if (i == 0 || i == 2 || i == 3 || i == 4 || i == 10) {
                        ((Field)arrayField.get((long)i)).setRequired("Y");
                    } else {
                        ((Field)arrayField.get((long)i)).setRequired("N");
                    }
                    i = (short)(i + 1);
                }
            }
            case 10: {
                message.setMsgcat(FixConstants.messagesMsgCat[0]);
                arrayField = null;
                arrayGroup = null;
                arrayField = message.setFieldSize(FixConstants.messageLogon.length).getField();
                arrayGroup = message.setGroupSize(1).getGroup();
                int i = 0;
                while ((long)i < arrayField.length()) {
                    ((Field)arrayField.get((long)i)).setName(FixConstants.messageLogon[i]);
                    if (i == 0 || i == 1) {
                        ((Field)arrayField.get((long)i)).setRequired("Y");
                    } else {
                        ((Field)arrayField.get((long)i)).setRequired("N");
                    }
                    i = (short)(i + 1);
                }
                ((Group)arrayGroup.get(0L)).setName("NoMsgTypes");
                ((Group)arrayGroup.get(0L)).setRequired("N");
                arrayField = null;
                arrayField = ((Group)arrayGroup.get(0L)).setFieldSize(FixConstants.messageLogonGrpFlds.length).getField();
                int j2 = 0;
                while ((long)j2 < arrayField.length()) {
                    ((Field)arrayField.get(0L)).setName(FixConstants.messageLogonGrpFlds[j2]);
                    ((Field)arrayField.get(0L)).setRequired("N");
                    j2 = (short)(j2 + 1);
                }
            }
            case 11: {
                int j;
                message.setMsgcat(FixConstants.messagesMsgCat[1]);
                arrayField = null;
                arrayGroup = null;
                arrayField = message.setFieldSize(FixConstants.messageNews.length).getField();
                arrayGroup = message.setGroupSize(FixConstants.messageNewsGrp.length).getGroup();
                int i = 0;
                while ((long)i < arrayField.length()) {
                    ((Field)arrayField.get((long)i)).setName(FixConstants.messageNews[i]);
                    if (i == 0) {
                        ((Field)arrayField.get((long)i)).setRequired("Y");
                    } else {
                        ((Field)arrayField.get((long)i)).setRequired("N");
                    }
                    i = (short)(i + 1);
                }
                i = 0;
                while ((long)i < arrayGroup.length()) {
                    ((Group)arrayGroup.get((long)i)).setName(FixConstants.messageNewsGrp[i]);
                    arrayField = null;
                    if (i == 0) {
                        ((Group)arrayGroup.get((long)i)).setRequired("N");
                        arrayField = ((Group)arrayGroup.get((long)i)).setFieldSize(2).getField();
                        j = 0;
                        while ((long)j < arrayField.length()) {
                            ((Field)arrayField.get((long)j)).setName(FixConstants.messageNewsGrpFlds[j]);
                            ((Field)arrayField.get((long)j)).setRequired("N");
                            j = (short)(j + 1);
                        }
                    } else if (i == 1) {
                        ((Group)arrayGroup.get((long)i)).setRequired("N");
                        arrayField = ((Group)arrayGroup.get((long)i)).setFieldSize(19).getField();
                        j = 0;
                        while ((long)j < arrayField.length()) {
                            ((Field)arrayField.get((long)j)).setName(FixConstants.messageNewsGrpFlds[j + 2]);
                            ((Field)arrayField.get((long)j)).setRequired("N");
                            j = (short)(j + 1);
                        }
                    } else if (i == 2) {
                        ((Group)arrayGroup.get((long)i)).setRequired("Y");
                        arrayField = ((Group)arrayGroup.get((long)i)).setFieldSize(3).getField();
                        j = 0;
                        while ((long)j < arrayField.length()) {
                            ((Field)arrayField.get((long)j)).setName(FixConstants.messageNewsGrpFlds[j + 21]);
                            if (j == 0) {
                                ((Field)arrayField.get((long)j)).setRequired("Y");
                            } else {
                                ((Field)arrayField.get((long)j)).setRequired("N");
                            }
                            j = (short)(j + 1);
                        }
                    }
                    i = (short)(i + 1);
                }
            }
            case 12: {
                int j;
                message.setMsgcat(FixConstants.messagesMsgCat[1]);
                arrayField = null;
                arrayGroup = null;
                arrayField = message.setFieldSize(FixConstants.messagesEmail.length).getField();
                arrayGroup = message.setGroupSize(FixConstants.messagesEmaiGrp.length).getGroup();
                int i = 0;
                while ((long)i < arrayField.length()) {
                    ((Field)arrayField.get((long)i)).setName(FixConstants.messagesEmail[i]);
                    if (i == 0 || i == 1 || i == 3) {
                        ((Field)arrayField.get((long)i)).setRequired("Y");
                    } else {
                        ((Field)arrayField.get((long)i)).setRequired("N");
                    }
                    i = (short)(i + 1);
                }
                i = 0;
                while ((long)i < arrayGroup.length()) {
                    ((Group)arrayGroup.get((long)i)).setName(FixConstants.messagesEmaiGrp[i]);
                    arrayField = null;
                    if (i == 0) {
                        ((Group)arrayGroup.get((long)i)).setRequired("N");
                        arrayField = ((Group)arrayGroup.get((long)i)).setFieldSize(2).getField();
                        j = 0;
                        while ((long)j < arrayField.length()) {
                            ((Field)arrayField.get((long)j)).setName(FixConstants.messagesEmaiGrpFlds[j]);
                            ((Field)arrayField.get((long)j)).setRequired("N");
                            j = (short)(j + 1);
                        }
                    } else if (i == 1) {
                        ((Group)arrayGroup.get((long)i)).setRequired("N");
                        arrayField = ((Group)arrayGroup.get((long)i)).setFieldSize(19).getField();
                        j = 0;
                        while ((long)j < arrayField.length()) {
                            ((Field)arrayField.get((long)j)).setName(FixConstants.messagesEmaiGrpFlds[j + 2]);
                            ((Field)arrayField.get((long)j)).setRequired("N");
                            j = (short)(j + 1);
                        }
                    } else if (i == 2) {
                        ((Group)arrayGroup.get((long)i)).setRequired("Y");
                        arrayField = ((Group)arrayGroup.get((long)i)).setFieldSize(3).getField();
                        j = 0;
                        while ((long)j < arrayField.length()) {
                            ((Field)arrayField.get((long)j)).setName(FixConstants.messagesEmaiGrpFlds[j + 21]);
                            if (j == 0) {
                                ((Field)arrayField.get((long)j)).setRequired("Y");
                            } else {
                                ((Field)arrayField.get((long)j)).setRequired("N");
                            }
                            j = (short)(j + 1);
                        }
                    }
                    i = (short)(i + 1);
                }
            }
            case 13: {
                int j;
                message.setMsgcat(FixConstants.messagesMsgCat[1]);
                arrayField = null;
                arrayGroup = null;
                arrayField = message.setFieldSize(FixConstants.messagesNOS.length).getField();
                arrayGroup = message.setGroupSize(FixConstants.messagesNOSGrp.length).getGroup();
                int i = 0;
                while ((long)i < arrayField.length()) {
                    ((Field)arrayField.get((long)i)).setName(FixConstants.messagesNOS[i]);
                    if (i == 0 || i == 6 || i == 12 || i == 32 || i == 34 || i == 37) {
                        ((Field)arrayField.get((long)i)).setRequired("Y");
                    } else {
                        ((Field)arrayField.get((long)i)).setRequired("N");
                    }
                    i = (short)(i + 1);
                }
                i = 0;
                while ((long)i < arrayGroup.length()) {
                    ((Group)arrayGroup.get((long)i)).setName(FixConstants.messagesNOSGrp[i]);
                    ((Group)arrayGroup.get((long)i)).setRequired("N");
                    arrayField = null;
                    if (i == 0) {
                        arrayField = ((Group)arrayGroup.get((long)i)).setFieldSize(2).getField();
                        j = 0;
                        while ((long)j < arrayField.length()) {
                            ((Field)arrayField.get((long)j)).setName(FixConstants.messagesNOSGrpFlds[j]);
                            ((Field)arrayField.get((long)j)).setRequired("N");
                            j = (short)(j + 1);
                        }
                    } else if (i == 1) {
                        arrayField = ((Group)arrayGroup.get((long)i)).setFieldSize(1).getField();
                        j = 0;
                        while ((long)j < arrayField.length()) {
                            ((Field)arrayField.get((long)j)).setName(FixConstants.messagesNOSGrpFlds[j + 2]);
                            ((Field)arrayField.get((long)j)).setRequired("N");
                            j = (short)(j + 1);
                        }
                    }
                    i = (short)(i + 1);
                }
            }
            case 14: {
                int j;
                message.setMsgcat(FixConstants.messagesMsgCat[1]);
                arrayField = null;
                arrayGroup = null;
                arrayField = message.setFieldSize(FixConstants.messagesNOL.length).getField();
                arrayGroup = message.setGroupSize(1).getGroup();
                int i = 0;
                while ((long)i < arrayField.length()) {
                    ((Field)arrayField.get((long)i)).setName(FixConstants.messagesNOL[i]);
                    if (i == 0 || i == 4 || i == 10) {
                        ((Field)arrayField.get((long)i)).setRequired("Y");
                    } else {
                        ((Field)arrayField.get((long)i)).setRequired("N");
                    }
                    i = (short)(i + 1);
                }
                ((Group)arrayGroup.get(0L)).setName("NoOrders");
                ((Group)arrayGroup.get(0L)).setRequired("Y");
                arrayField = null;
                arrayField = ((Group)arrayGroup.get(0L)).setFieldSize(FixConstants.messagesNOLOuterGrpFlds.length).getField();
                int j2 = 0;
                while ((long)j2 < arrayField.length()) {
                    ((Field)arrayField.get((long)j2)).setName(FixConstants.messagesNOLOuterGrpFlds[j2]);
                    if (j2 == 0 || j2 == 1 || j2 == 14 || j2 == 34) {
                        ((Field)arrayField.get((long)j2)).setRequired("Y");
                    } else {
                        ((Field)arrayField.get((long)j2)).setRequired("N");
                    }
                    j2 = (short)(j2 + 1);
                }
                arrayInnerGroup = ((Group)arrayGroup.get(0L)).setGroupSize(2).getGroup();
                i = 0;
                while ((long)i < arrayInnerGroup.length()) {
                    ((Group)arrayInnerGroup.get((long)i)).setName(FixConstants.messagesNOLInnerGrp[i]);
                    ((Group)arrayInnerGroup.get((long)i)).setRequired("N");
                    arrayField = null;
                    if (i == 0) {
                        arrayField = ((Group)arrayInnerGroup.get((long)i)).setFieldSize(2).getField();
                        j = 0;
                        while ((long)j < arrayField.length()) {
                            ((Field)arrayField.get((long)j)).setName(FixConstants.messagesNOLInnerGrpFlds[j]);
                            ((Field)arrayField.get((long)j)).setRequired("N");
                            j = (short)(j + 1);
                        }
                    } else if (i == 1) {
                        arrayField = ((Group)arrayInnerGroup.get((long)i)).setFieldSize(1).getField();
                        j = 0;
                        while ((long)j < arrayField.length()) {
                            ((Field)arrayField.get((long)j)).setName(FixConstants.messagesNOLInnerGrpFlds[j + 2]);
                            ((Field)arrayField.get((long)j)).setRequired("N");
                            j = (short)(j + 1);
                        }
                    }
                    i = (short)(i + 1);
                }
            }
            case 15: {
                message.setMsgcat(FixConstants.messagesMsgCat[1]);
                arrayField = null;
                arrayGroup = null;
                arrayField = message.setFieldSize(FixConstants.messagesOCR.length).getField();
                int i = 0;
                while ((long)i < arrayField.length()) {
                    ((Field)arrayField.get((long)i)).setName(FixConstants.messagesOCR[i]);
                    if (i == 0 || i == 2 || i == 7 || i == 27) {
                        ((Field)arrayField.get((long)i)).setRequired("Y");
                    } else {
                        ((Field)arrayField.get((long)i)).setRequired("N");
                    }
                    i = (short)(i + 1);
                }
            }
            case 16: {
                int j;
                message.setMsgcat(FixConstants.messagesMsgCat[1]);
                arrayField = null;
                arrayGroup = null;
                arrayField = message.setFieldSize(FixConstants.messagesOCR.length).getField();
                arrayGroup = message.setGroupSize(FixConstants.messagesOCRGrp.length).getGroup();
                int i = 0;
                while ((long)i < arrayField.length()) {
                    ((Field)arrayField.get((long)i)).setName(FixConstants.messagesOCR[i]);
                    if (i == 3 || i == 4 || i == 9 || i == 14 || i == 33 || i == 34 || i == 37) {
                        ((Field)arrayField.get((long)i)).setRequired("Y");
                    } else {
                        ((Field)arrayField.get((long)i)).setRequired("N");
                    }
                    i = (short)(i + 1);
                }
                i = 0;
                while ((long)i < arrayGroup.length()) {
                    ((Group)arrayGroup.get((long)i)).setName(FixConstants.messagesOCRGrp[i]);
                    ((Group)arrayGroup.get((long)i)).setRequired("N");
                    arrayField = null;
                    if (i == 0) {
                        arrayField = ((Group)arrayGroup.get((long)i)).setFieldSize(2).getField();
                        j = 0;
                        while ((long)j < arrayField.length()) {
                            ((Field)arrayField.get((long)j)).setName(FixConstants.messagesOCRGrpFlds[j]);
                            ((Field)arrayField.get((long)j)).setRequired("N");
                            j = (short)(j + 1);
                        }
                    } else if (i == 1) {
                        arrayField = ((Group)arrayGroup.get((long)i)).setFieldSize(1).getField();
                        j = 0;
                        while ((long)j < arrayField.length()) {
                            ((Field)arrayField.get((long)j)).setName(FixConstants.messagesOCRGrpFlds[j + 2]);
                            ((Field)arrayField.get((long)j)).setRequired("N");
                            j = (short)(j + 1);
                        }
                    }
                    i = (short)(i + 1);
                }
            }
            case 17: {
                message.setMsgcat(FixConstants.messagesMsgCat[1]);
                arrayField = null;
                arrayGroup = null;
                arrayField = message.setFieldSize(FixConstants.messagesOSR.length).getField();
                int i = 0;
                while ((long)i < arrayField.length()) {
                    ((Field)arrayField.get((long)i)).setName(FixConstants.messagesOSR[i]);
                    if (i == 1 || i == 5 || i == 2 || i == 4) {
                        ((Field)arrayField.get((long)i)).setRequired("Y");
                    } else {
                        ((Field)arrayField.get((long)i)).setRequired("N");
                    }
                    i = (short)(i + 1);
                }
            }
            case 18: {
                int j;
                message.setMsgcat(FixConstants.messagesMsgCat[1]);
                arrayField = null;
                arrayGroup = null;
                arrayField = message.setFieldSize(FixConstants.messagesAlloc.length).getField();
                arrayGroup = message.setGroupSize(FixConstants.messagesAllocOGrp.length).getGroup();
                int i = 0;
                while ((long)i < arrayField.length()) {
                    ((Field)arrayField.get((long)i)).setName(FixConstants.messagesAlloc[i]);
                    if (i == 0 || i == 1 || i == 5 || i == 6 || i == 25 || i == 28 || i == 31) {
                        ((Field)arrayField.get((long)i)).setRequired("Y");
                    } else {
                        ((Field)arrayField.get((long)i)).setRequired("N");
                    }
                    i = (short)(i + 1);
                }
                i = 0;
                while ((long)i < arrayGroup.length()) {
                    ((Group)arrayGroup.get((long)i)).setName(FixConstants.messagesAllocOGrp[i]);
                    ((Group)arrayGroup.get((long)i)).setRequired("N");
                    arrayField = null;
                    arrayField = ((Group)arrayGroup.get((long)i)).setFieldSize(FixConstants.messagesAllocOGrpFlds.length).getField();
                    j = 0;
                    while ((long)j < arrayField.length()) {
                        ((Field)arrayField.get((long)j)).setName(FixConstants.messagesAllocOGrpFlds[j]);
                        if (i == 2 && j == 2) {
                            ((Field)arrayField.get((long)j)).setRequired("Y");
                            arrayInnerGroup = ((Group)arrayGroup.get((long)i)).setGroupSize(1).getGroup();
                            ((Group)arrayInnerGroup.get(0L)).setName("NoMiscFees");
                            ((Group)arrayInnerGroup.get(0L)).setRequired("N");
                            arrayField = null;
                            arrayField = ((Group)arrayGroup.get((long)j)).setFieldSize(FixConstants.messagesAllocIGrpFlds.length).getField();
                            int k = 0;
                            while ((long)k < arrayField.length()) {
                                ((Field)arrayField.get((long)k)).setName(FixConstants.messagesAllocIGrpFlds[j]);
                                ((Field)arrayField.get((long)k)).setRequired("N");
                                k = (short)(k + 1);
                            }
                        } else {
                            ((Field)arrayField.get((long)j)).setRequired("N");
                        }
                        j = (short)(j + 1);
                    }
                    i = (short)(i + 1);
                }
            }
            case 19: {
                fieldYesArray = null;
                fieldArray = null;
                groupYesArray = null;
                groupArray = null;
                groupFieldSize = null;
                groupFieldYesArray = null;
                groupField = null;
                innerGroupFieldSize = null;
                innerGroupField = null;
                innerGroup = null;
                this.addMessageInfo(message, FixConstants.messagesMsgCat[1], new int[]{0, 1}, FixConstants.messagesListCancelReq, groupYesArray, groupArray, groupFieldSize, (int[][])groupFieldYesArray, groupField, innerGroupFieldSize, innerGroupField, innerGroup);
            }
            case 20: {
                fieldYesArray = null;
                fieldArray = null;
                groupYesArray = null;
                groupArray = null;
                groupFieldSize = null;
                groupFieldYesArray = null;
                groupField = null;
                innerGroupFieldSize = null;
                innerGroupField = null;
                innerGroup = null;
                this.addMessageInfo(message, FixConstants.messagesMsgCat[1], new int[]{0, 3}, FixConstants.messagesListExec, groupYesArray, groupArray, groupFieldSize, (int[][])groupFieldYesArray, groupField, innerGroupFieldSize, innerGroupField, innerGroup);
            }
            case 21: {
                fieldYesArray = null;
                fieldArray = null;
                groupYesArray = null;
                groupArray = null;
                groupFieldSize = null;
                groupFieldYesArray = null;
                groupField = null;
                innerGroupFieldSize = null;
                innerGroupField = null;
                innerGroup = null;
                this.addMessageInfo(message, FixConstants.messagesMsgCat[1], new int[]{0}, FixConstants.messagesListStatusReq, groupYesArray, groupArray, groupFieldSize, (int[][])groupFieldYesArray, groupField, innerGroupFieldSize, innerGroupField, innerGroup);
            }
            case 22: {
                fieldYesArray = new int[]{0, 1, 3, 4, 9};
                fieldArray = null;
                groupYesArray = new int[]{0};
                groupArray = FixConstants.messagesListStatusGrp;
                groupFieldSize = new int[]{FixConstants.messagesListStatusGrpFld.length};
                groupFieldYesArray = new int[][]{{0, 1, 2, 3, 4, 5}};
                groupField = FixConstants.messagesListStatusGrpFld;
                innerGroupFieldSize = null;
                innerGroupField = null;
                innerGroup = null;
                this.addMessageInfo(message, FixConstants.messagesMsgCat[1], fieldYesArray, FixConstants.messagesListStatusReq, groupYesArray, groupArray, groupFieldSize, (int[][])groupFieldYesArray, groupField, innerGroupFieldSize, innerGroupField, innerGroup);
            }
            case 23: {
                fieldYesArray = new int[]{2, 3, 5};
                fieldArray = null;
                groupYesArray = null;
                groupArray = null;
                groupFieldSize = null;
                groupFieldYesArray = null;
                groupField = null;
                innerGroupFieldSize = null;
                innerGroupField = null;
                innerGroup = null;
                this.addMessageInfo(message, FixConstants.messagesMsgCat[1], fieldYesArray, FixConstants.messagesAllocationAck, groupYesArray, groupArray, groupFieldSize, (int[][])groupFieldYesArray, groupField, innerGroupFieldSize, innerGroupField, innerGroup);
            }
            case 24: {
                fieldYesArray = new int[]{0, 1, 2, 3, 22};
                fieldArray = null;
                groupYesArray = null;
                groupArray = null;
                groupFieldSize = null;
                groupFieldYesArray = null;
                groupField = null;
                innerGroupFieldSize = null;
                innerGroupField = null;
                innerGroup = null;
                this.addMessageInfo(message, FixConstants.messagesMsgCat[1], fieldYesArray, FixConstants.messagesDNT, groupYesArray, groupArray, groupFieldSize, (int[][])groupFieldYesArray, groupField, innerGroupFieldSize, innerGroupField, innerGroup);
            }
            case 25: {
                fieldYesArray = new int[]{0};
                fieldArray = null;
                groupYesArray = new int[]{0};
                groupArray = FixConstants.messagesQuoteReqGrp;
                groupFieldSize = new int[]{FixConstants.messagesQuoteReqGrpFld.length};
                groupFieldYesArray = new int[][]{{0}};
                groupField = FixConstants.messagesQuoteReqGrpFld;
                innerGroupFieldSize = null;
                innerGroupField = null;
                innerGroup = null;
                this.addMessageInfo(message, FixConstants.messagesMsgCat[1], fieldYesArray, FixConstants.messagesQuoteReq, groupYesArray, groupArray, groupFieldSize, (int[][])groupFieldYesArray, groupField, innerGroupFieldSize, innerGroupField, innerGroup);
            }
            case 26: {
                fieldYesArray = new int[]{1, 4};
                fieldArray = null;
                groupYesArray = null;
                groupArray = null;
                groupFieldSize = null;
                groupFieldYesArray = null;
                groupField = null;
                innerGroupFieldSize = null;
                innerGroupField = null;
                innerGroup = null;
                this.addMessageInfo(message, FixConstants.messagesMsgCat[1], fieldYesArray, FixConstants.messagesQuote, groupYesArray, groupArray, groupFieldSize, (int[][])groupFieldYesArray, groupField, innerGroupFieldSize, innerGroupField, innerGroup);
            }
            case 27: {
                fieldYesArray = new int[]{0, 1, 2, 3, 4, 5, 14};
                fieldArray = null;
                groupYesArray = null;
                groupArray = null;
                groupFieldSize = null;
                groupFieldYesArray = null;
                groupField = null;
                innerGroupFieldSize = null;
                innerGroupField = null;
                innerGroup = null;
                this.addMessageInfo(message, FixConstants.messagesMsgCat[1], fieldYesArray, FixConstants.messageSettlementInst, groupYesArray, groupArray, groupFieldSize, (int[][])groupFieldYesArray, groupField, innerGroupFieldSize, innerGroupField, innerGroup);
            }
            case 28: {
                fieldYesArray = new int[]{0, 1, 2};
                fieldArray = null;
                groupYesArray = new int[]{0, 1};
                groupArray = FixConstants.messagesMarketDataReqGrp;
                groupFieldSize = new int[]{FixConstants.messagesMarketDataReqGrpFld.length};
                groupFieldYesArray = new int[][]{{0}, {0}};
                groupField = FixConstants.messagesMarketDataReqGrpFld;
                innerGroupFieldSize = null;
                innerGroupField = null;
                innerGroup = null;
                this.addMessageInfo(message, FixConstants.messagesMsgCat[1], fieldYesArray, FixConstants.messagesMarketDataReq, groupYesArray, groupArray, groupFieldSize, (int[][])groupFieldYesArray, groupField, innerGroupFieldSize, innerGroupField, innerGroup);
            }
            case 29: {
                fieldYesArray = new int[]{1};
                fieldArray = null;
                groupYesArray = new int[]{0};
                groupArray = FixConstants.messagesMarketDataSSFReqGrp;
                groupFieldSize = new int[]{FixConstants.messagesMarketDataSSFReqGrpFld.length};
                groupFieldYesArray = new int[][]{{0, 1}};
                groupField = FixConstants.messagesMarketDataSSFReqGrpFld;
                innerGroupFieldSize = null;
                innerGroupField = null;
                innerGroup = null;
                this.addMessageInfo(message, FixConstants.messagesMsgCat[1], fieldYesArray, FixConstants.messagesMarketDataSSFReq, groupYesArray, groupArray, groupFieldSize, (int[][])groupFieldYesArray, groupField, innerGroupFieldSize, innerGroupField, innerGroup);
            }
            case 30: {
                fieldYesArray = null;
                fieldArray = null;
                groupYesArray = new int[]{0};
                groupArray = FixConstants.messagesMarketDataINCRReqGrp;
                groupFieldSize = new int[]{FixConstants.messagesMarketDataINCRReqGrpFld.length};
                groupFieldYesArray = new int[][]{{0}};
                groupField = FixConstants.messagesMarketDataINCRReqGrpFld;
                innerGroupFieldSize = null;
                innerGroupField = null;
                innerGroup = null;
                this.addMessageInfo(message, FixConstants.messagesMsgCat[1], fieldYesArray, FixConstants.messagesMarketDataINCRReq, groupYesArray, groupArray, groupFieldSize, (int[][])groupFieldYesArray, groupField, innerGroupFieldSize, innerGroupField, innerGroup);
            }
            case 31: {
                fieldYesArray = new int[]{0};
                fieldArray = null;
                groupYesArray = null;
                groupArray = null;
                groupFieldSize = null;
                groupFieldYesArray = null;
                groupField = null;
                innerGroupFieldSize = null;
                innerGroupField = null;
                innerGroup = null;
                this.addMessageInfo(message, FixConstants.messagesMsgCat[1], fieldYesArray, FixConstants.messagesMarketDataReqRej, groupYesArray, groupArray, groupFieldSize, (int[][])groupFieldYesArray, groupField, innerGroupFieldSize, innerGroupField, innerGroup);
            }
            case 32: {
                fieldYesArray = new int[]{1, 2};
                fieldArray = null;
                groupYesArray = new int[]{0};
                groupArray = FixConstants.messagesQuoteCancelGrp;
                groupFieldSize = new int[]{FixConstants.messagesQuoteCancelGrpFlds.length};
                groupFieldYesArray = new int[][]{{0}};
                groupField = FixConstants.messagesQuoteCancelGrpFlds;
                innerGroupFieldSize = null;
                innerGroupField = null;
                innerGroup = null;
                this.addMessageInfo(message, FixConstants.messagesMsgCat[1], fieldYesArray, FixConstants.messagesQuoteCancel, groupYesArray, groupArray, groupFieldSize, (int[][])groupFieldYesArray, groupField, innerGroupFieldSize, innerGroupField, innerGroup);
            }
            case 33: {
                fieldYesArray = new int[]{1};
                fieldArray = null;
                groupYesArray = null;
                groupArray = null;
                groupFieldSize = null;
                groupFieldYesArray = null;
                groupField = null;
                innerGroupFieldSize = null;
                innerGroupField = null;
                innerGroup = null;
                this.addMessageInfo(message, FixConstants.messagesMsgCat[1], fieldYesArray, FixConstants.messagesQuoteStmtReq, groupYesArray, groupArray, groupFieldSize, (int[][])groupFieldYesArray, groupField, innerGroupFieldSize, innerGroupField, innerGroup);
            }
            case 34: {
                fieldYesArray = new int[]{2};
                fieldArray = null;
                groupYesArray = null;
                groupArray = FixConstants.messagesQuoteAckGrp;
                groupFieldSize = new int[]{FixConstants.messagesQuoteAckGrpFlds.length};
                groupFieldYesArray = null;
                groupField = FixConstants.messagesQuoteAckGrpFlds;
                innerGroupFieldSize = null;
                innerGroupField = FixConstants.messagesIQuoteAckGrpFlds;
                innerGroup = FixConstants.messagesIQuoteAckGrp;
                this.addMessageInfo(message, FixConstants.messagesMsgCat[1], fieldYesArray, FixConstants.messagesQuoteAck, groupYesArray, groupArray, groupFieldSize, (int[][])groupFieldYesArray, groupField, innerGroupFieldSize, innerGroupField, innerGroup);
            }
            case 35: {
                fieldYesArray = new int[]{2};
                fieldArray = null;
                groupYesArray = null;
                groupArray = FixConstants.messagesSecDefReqGrp;
                groupFieldSize = new int[]{FixConstants.messagesSecDefReqGrpFlds.length};
                groupFieldYesArray = null;
                groupField = FixConstants.messagesSecDefReqGrpFlds;
                innerGroupFieldSize = null;
                innerGroupField = null;
                innerGroup = null;
                this.addMessageInfo(message, FixConstants.messagesMsgCat[1], fieldYesArray, FixConstants.messagesSecDefReq, groupYesArray, groupArray, groupFieldSize, (int[][])groupFieldYesArray, groupField, innerGroupFieldSize, innerGroupField, innerGroup);
            }
            case 36: {
                fieldYesArray = new int[]{0, 1, 3};
                fieldArray = null;
                groupYesArray = null;
                groupArray = FixConstants.messagesSecDefGrp;
                groupFieldSize = new int[]{FixConstants.messagesSecDefGrpFlds.length};
                groupFieldYesArray = null;
                groupField = FixConstants.messagesSecDefGrpFlds;
                innerGroupFieldSize = null;
                innerGroupField = null;
                innerGroup = null;
                this.addMessageInfo(message, FixConstants.messagesMsgCat[1], fieldYesArray, FixConstants.messagesSecDef, groupYesArray, groupArray, groupFieldSize, (int[][])groupFieldYesArray, groupField, innerGroupFieldSize, innerGroupField, innerGroup);
            }
            case 37: {
                fieldYesArray = new int[]{0, 1, 3};
                fieldArray = null;
                groupYesArray = null;
                groupArray = null;
                groupFieldSize = null;
                groupFieldYesArray = null;
                groupField = null;
                innerGroupFieldSize = null;
                innerGroupField = null;
                innerGroup = null;
                this.addMessageInfo(message, FixConstants.messagesMsgCat[1], fieldYesArray, FixConstants.messagesSecStatusReq, groupYesArray, groupArray, groupFieldSize, (int[][])groupFieldYesArray, groupField, innerGroupFieldSize, innerGroupField, innerGroup);
            }
            case 38: {
                fieldYesArray = new int[]{1};
                fieldArray = null;
                groupYesArray = null;
                groupArray = null;
                groupFieldSize = null;
                groupFieldYesArray = null;
                groupField = null;
                innerGroupFieldSize = null;
                innerGroupField = null;
                innerGroup = null;
                this.addMessageInfo(message, FixConstants.messagesMsgCat[1], fieldYesArray, FixConstants.messagesSecStatus, groupYesArray, groupArray, groupFieldSize, (int[][])groupFieldYesArray, groupField, innerGroupFieldSize, innerGroupField, innerGroup);
            }
            case 39: {
                fieldYesArray = new int[]{0, 4};
                fieldArray = null;
                groupYesArray = null;
                groupArray = null;
                groupFieldSize = null;
                groupFieldYesArray = null;
                groupField = null;
                innerGroupFieldSize = null;
                innerGroupField = null;
                innerGroup = null;
                this.addMessageInfo(message, FixConstants.messagesMsgCat[1], fieldYesArray, FixConstants.messagesTSSReq, groupYesArray, groupArray, groupFieldSize, (int[][])groupFieldYesArray, groupField, innerGroupFieldSize, innerGroupField, innerGroup);
            }
            case 40: {
                fieldYesArray = new int[]{1, 5};
                fieldArray = null;
                groupYesArray = null;
                groupArray = null;
                groupFieldSize = null;
                groupFieldYesArray = null;
                groupField = null;
                innerGroupFieldSize = null;
                innerGroupField = null;
                innerGroup = null;
                this.addMessageInfo(message, FixConstants.messagesMsgCat[1], fieldYesArray, FixConstants.messagesTSS, groupYesArray, groupArray, groupFieldSize, (int[][])groupFieldYesArray, groupField, innerGroupFieldSize, innerGroupField, innerGroup);
            }
            case 41: {
                fieldYesArray = new int[]{1};
                fieldArray = null;
                groupYesArray = new int[]{0};
                groupArray = FixConstants.messagesMassQGrp;
                groupFieldSize = new int[]{FixConstants.messagesMassQGrpFlds.length};
                groupFieldYesArray = null;
                groupField = FixConstants.messagesMassQGrpFlds;
                innerGroupFieldSize = null;
                innerGroupField = FixConstants.messagesIMassQGrpFlds;
                innerGroup = FixConstants.messagesIMassQGrp;
                this.addMessageInfo(message, FixConstants.messagesMsgCat[1], fieldYesArray, FixConstants.messagesMassQ, groupYesArray, groupArray, groupFieldSize, (int[][])groupFieldYesArray, groupField, innerGroupFieldSize, innerGroupField, innerGroup);
            }
            case 42: {
                fieldYesArray = new int[]{1, 3};
                fieldArray = null;
                groupYesArray = null;
                groupArray = null;
                groupFieldSize = null;
                groupFieldYesArray = null;
                groupField = null;
                innerGroupFieldSize = null;
                innerGroupField = null;
                innerGroup = null;
                this.addMessageInfo(message, FixConstants.messagesMsgCat[1], fieldYesArray, FixConstants.messagesBMRej, groupYesArray, groupArray, groupFieldSize, (int[][])groupFieldYesArray, groupField, innerGroupFieldSize, innerGroupField, innerGroup);
            }
            case 43: {
                fieldYesArray = new int[]{1, 2, 4, 21, 22};
                fieldArray = null;
                groupYesArray = null;
                groupArray = FixConstants.messagesBidReqGrp;
                groupFieldSize = new int[]{FixConstants.messagesBidReqGrpFld.length};
                groupFieldYesArray = null;
                groupField = FixConstants.messagesBidReqGrpFld;
                innerGroupFieldSize = null;
                innerGroupField = null;
                innerGroup = null;
                this.addMessageInfo(message, FixConstants.messagesMsgCat[1], fieldYesArray, FixConstants.messagesBidReq, groupYesArray, groupArray, groupFieldSize, (int[][])groupFieldYesArray, groupField, innerGroupFieldSize, innerGroupField, innerGroup);
            }
            case 44: {
                fieldYesArray = null;
                fieldArray = null;
                groupYesArray = new int[]{0, 1};
                groupArray = FixConstants.messagesBidResGrp;
                groupFieldSize = new int[]{FixConstants.messagesBidResGrpFld.length};
                groupFieldYesArray = null;
                groupField = FixConstants.messagesBidResGrpFld;
                innerGroupFieldSize = null;
                innerGroupField = null;
                innerGroup = null;
                this.addMessageInfo(message, FixConstants.messagesMsgCat[1], fieldYesArray, FixConstants.messagesBidRes, groupYesArray, groupArray, groupFieldSize, (int[][])groupFieldYesArray, groupField, innerGroupFieldSize, innerGroupField, innerGroup);
            }
            case 45: {
                fieldYesArray = null;
                fieldArray = null;
                groupYesArray = new int[]{0, 22};
                groupArray = FixConstants.messagesLSPriceGrp;
                groupFieldSize = new int[]{FixConstants.messagesLSPriceGrpFld.length};
                groupFieldYesArray = null;
                groupField = FixConstants.messagesLSPriceGrpFld;
                innerGroupFieldSize = null;
                innerGroupField = null;
                innerGroup = null;
                this.addMessageInfo(message, FixConstants.messagesMsgCat[1], fieldYesArray, FixConstants.messagesLSPrice, groupYesArray, groupArray, groupFieldSize, (int[][])groupFieldYesArray, groupField, innerGroupFieldSize, innerGroupField, innerGroup);
            }
        }
    }

    private void addMessageInfo(Message message, String messageCat, int[] fieldYesArray, String[] fieldArray, int[] groupYesArray, String[] groupArray, int[] groupFieldSize, int[][] groupFieldYesArray, String[] groupField, int[] innerGroupFieldSize, String[] innerGroupField, String[] innerGroup) {
        int j;
        HugeArray<Field> arrayField = null;
        HugeArray<Group> arrayGroup = null;
        message.setMsgcat(messageCat);
        arrayField = message.setFieldSize(fieldArray.length).getField();
        int i = 0;
        while ((long)i < arrayField.length()) {
            ((Field)arrayField.get((long)i)).setName(fieldArray[i]);
            for (j = 0; j < fieldYesArray.length; j = (int)((short)(j + 1))) {
                if (i == j) {
                    ((Field)arrayField.get((long)i)).setRequired("Y");
                    break;
                }
                ((Field)arrayField.get((long)i)).setRequired("N");
            }
            i = (short)(i + 1);
        }
        if (groupArray != null) {
            arrayGroup = message.setGroupSize(groupArray.length).getGroup();
            i = 0;
            while ((long)i < arrayGroup.length()) {
                ((Group)arrayGroup.get((long)i)).setName(groupArray[i]);
                for (j = 0; j < groupYesArray.length; j = (int)((short)(j + 1))) {
                    if (i == j) {
                        ((Group)arrayGroup.get((long)i)).setRequired("Y");
                        break;
                    }
                    ((Group)arrayGroup.get((long)i)).setRequired("N");
                }
                arrayField = null;
                int groupFieldCounter = 0;
                int[] arrayYesCounter = groupFieldYesArray[i];
                arrayField = ((Group)arrayGroup.get((long)i)).setFieldSize(groupFieldSize[i]).getField();
                int j2 = groupFieldCounter;
                while ((long)j2 < arrayField.length()) {
                    ((Field)arrayField.get((long)j2)).setName(groupField[j2]);
                    int k = 0;
                    while (j2 < arrayYesCounter.length) {
                        if (j2 == k) {
                            ((Field)arrayField.get((long)j2)).setRequired("Y");
                            break;
                        }
                        ((Field)arrayField.get((long)j2)).setRequired("N");
                        k = (short)(k + 1);
                    }
                    ((Field)arrayField.get((long)j2)).setRequired("N");
                    groupFieldCounter = (short)(groupFieldCounter + 1);
                    j2 = (short)(j2 + 1);
                }
                this.addGroupToGroup((Group)arrayGroup.get((long)i), innerGroupFieldSize, innerGroupField, innerGroup);
                i = (short)(i + 1);
            }
        }
    }

    private void addGroupToGroup(Group group, int[] innerGroupFieldSize, String[] innerGroupField, String[] innerGroup) {
        HugeArray<Group> arrayInnerGroup = null;
        HugeArray<Field> arrayField = null;
        if (innerGroupFieldSize == null) {
            return;
        }
        arrayInnerGroup = group.setGroupSize(innerGroup.length).getGroup();
        for (int i = 0; i < innerGroup.length; i = (int)((short)(i + 1))) {
            ((Group)arrayInnerGroup.get((long)i)).setName(innerGroup[i]);
            ((Group)arrayInnerGroup.get((long)i)).setRequired("N");
            arrayField = null;
            arrayField = group.setFieldSize(innerGroupField.length).getField();
            int k = 0;
            while ((long)k < arrayField.length()) {
                ((Field)arrayField.get((long)k)).setName(innerGroupField[k]);
                ((Field)arrayField.get((long)k)).setRequired("N");
                k = (short)(k + 1);
            }
        }
    }

    public FixConfig createServerFixTrailer() {
        if ((this.currentFixVersion & this.fix4_2_0_mask) != 0) {
            this.load42DefaultTrailer();
        }
        return this;
    }

    private void load42DefaultTrailer() {
        this.trailer = new Trailer();
        HugeArray<Field> array = this.trailer.setFieldSize(3).getField();
        Field field = null;
        for (int i = 0; i < FixConstants.trailerFieldName.length; i = (int)((short)(i + 1))) {
            field = (Field)array.get((long)i);
            field.setName(FixConstants.trailerFieldName[i]);
            if (i == 2) {
                field.setRequired("Y");
                continue;
            }
            field.setRequired("N");
        }
    }

    private FixConfig createServerFixComponents() {
        return this;
    }

    public FixConfig createServerFixFields() {
        if ((this.currentFixVersion & this.fix4_2_0_mask) != 0) {
            this.load42DefaultFields();
        }
        return this;
    }

    public Field[] getFieldArr() {
        return this.fieldArr;
    }

    private void load42DefaultFields() {
        this.fieldArr = new Field[FixConstants.fieldsNumber.length];
        for (int i = 0; i < FixConstants.fieldsNumber.length; i = (int)((short)(i + 1))) {
            this.fieldArr[i] = new Field();
            this.fieldArr[i].setNumber(FixConstants.fieldsNumber[i]);
            this.fieldArr[i].setName(FixConstants.fieldsName[i]);
            this.fieldArr[i].setType(FieldLookup.fieldFor(FixConstants.fieldsTypeOrdering[i]));
        }
    }

    public int getFixVersionMajor() {
        return this.fixVersionMajor;
    }

    public FixConfig setFixVersionMajor(int fixVersionMajor) {
        this.fixVersionMajor = fixVersionMajor;
        return this;
    }

    public int getFixVersionMinor() {
        return this.fixVersionMinor;
    }

    public FixConfig setFixVersionMinor(int fixVersionMinor) {
        this.fixVersionMinor = fixVersionMinor;
        return this;
    }

    public int getFixVersionServicePack() {
        return this.fixVersionServicePack;
    }

    public FixConfig setFixVersionServicePack(int fixVersionServicePack) {
        this.fixVersionServicePack = fixVersionServicePack;
        this.setCurrentFixVersion();
        return this;
    }

    private void setCurrentFixVersion() {
        this.currentFixVersion = this.fixVersionMajor | this.fixVersionMinor | this.fixVersionServicePack;
    }

    public Trailer getTrailer() {
        return this.trailer;
    }

    public Header getHeader() {
        return this.header;
    }

    public Messages getMessages() {
        return this.messages;
    }

    public Components getComponents() {
        return this.components;
    }

    public Fields getFields() {
        return this.fields;
    }
}

