/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.fix.include.util;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.concurrent.atomic.AtomicInteger;
import net.openhft.fix.include.util.FixConfig;
import net.openhft.fix.include.util.FixPoolFactory;
import net.openhft.fix.include.v42.FixMessage;
import net.openhft.lang.io.NativeBytes;

public class FixMessagePool
implements FixPoolFactory<FixMessage> {
    private FixMessageContainer[] fixMessageArr;
    private volatile int objGetPosition;
    private int objectPutPosition;
    private final int mask;
    private final long BASE_ADDR;
    private final long ARR_INDEX;
    private final long TAIL_ADJUSTMENT;
    private FixConfig fixConfig = new FixConfig();
    private ThreadLocal<FixMessageContainer> fixLocal = new ThreadLocal();

    public FixMessagePool(FixPoolFactory<FixMessage> fixPoolFactory, int poolSize, boolean useDefault) {
        int currentSize;
        if (fixPoolFactory == null) {
            fixPoolFactory = this;
        }
        for (currentSize = 1; currentSize < poolSize; currentSize <<= 1) {
        }
        poolSize = currentSize;
        this.fixMessageArr = new FixMessageContainer[poolSize];
        for (int i = 0; i < poolSize; ++i) {
            this.fixMessageArr[i] = new FixMessageContainer((FixMessage)fixPoolFactory.create(useDefault));
        }
        this.mask = poolSize - 1;
        this.objectPutPosition = poolSize;
        this.BASE_ADDR = NativeBytes.UNSAFE.arrayBaseOffset(FixMessageContainer[].class);
        this.ARR_INDEX = NativeBytes.UNSAFE.arrayIndexScale(FixMessageContainer[].class);
        this.TAIL_ADJUSTMENT = 31 - Integer.numberOfLeadingZeros((int)this.ARR_INDEX);
    }

    public FixMessageContainer getFixMessageContainer() {
        int localTakePointer;
        FixMessageContainer localObject = this.fixLocal.get();
        if (localObject != null && localObject.state.compareAndSet(0, 1)) {
            return localObject;
        }
        while (this.objectPutPosition != (localTakePointer = this.objGetPosition)) {
            int index = localTakePointer & this.mask;
            FixMessageContainer fixMsgContainer = this.fixMessageArr[index];
            if (fixMsgContainer == null || !NativeBytes.UNSAFE.compareAndSwapObject(this.fixMessageArr, (long)(index << (int)this.TAIL_ADJUSTMENT) + this.BASE_ADDR, fixMsgContainer, null)) continue;
            this.objGetPosition = localTakePointer + 1;
            if (!fixMsgContainer.state.compareAndSet(0, 1)) continue;
            this.fixLocal.set(fixMsgContainer);
            return fixMsgContainer;
        }
        return null;
    }

    public void putFixMessageContainer(FixMessageContainer fixMsgContainer) throws Exception {
        int localPosition = this.objectPutPosition;
        long index = (long)((localPosition & this.mask) << (int)this.TAIL_ADJUSTMENT) + this.BASE_ADDR;
        if (!fixMsgContainer.state.compareAndSet(1, 0)) {
            throw new Exception("Not a valid position address");
        }
        NativeBytes.UNSAFE.putOrderedObject(this.fixMessageArr, index, fixMsgContainer);
        this.objectPutPosition = localPosition + 1;
    }

    @Override
    public FixMessage create(boolean useDefault) {
        FixMessage fm = new FixMessage(FixConfig.SERVER_DEFAULT_4_2.clone().setFixVersionMajor(4).setFixVersionMinor(2).setFixVersionServicePack(0).createServerFixFields().getFieldArr());
        return fm;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.fixMessageArr);
        out.writeInt(this.objGetPosition);
        out.writeInt(this.objectPutPosition);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.fixMessageArr = (FixMessageContainer[])in.readObject();
        this.objGetPosition = in.readInt();
        this.objectPutPosition = in.readInt();
    }

    public static class FixMessageContainer
    implements Externalizable {
        private FixMessage fixMessage;
        public static final int AVAILABLE_STATE = 0;
        public static final int IN_USE_STATE = 1;
        private AtomicInteger state = new AtomicInteger(0);

        public FixMessageContainer(FixMessage fixMessage) {
            this.fixMessage = fixMessage;
        }

        public FixMessage getFixMessage() {
            return this.fixMessage;
        }

        @Override
        public void writeExternal(ObjectOutput out) throws IOException {
            out.writeObject(this.fixMessage);
        }

        @Override
        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            this.fixMessage = (FixMessage)in.readObject();
        }
    }
}

