/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.fix.include.v42;

import net.openhft.fix.include.util.FixConfig;
import net.openhft.fix.include.util.FixMessagePool;
import net.openhft.fix.include.v42.Components;
import net.openhft.fix.include.v42.Fields;
import net.openhft.fix.include.v42.FixMessage;
import net.openhft.fix.include.v42.Header;
import net.openhft.fix.include.v42.Messages;
import net.openhft.fix.include.v42.Trailer;
import net.openhft.lang.model.DataValueGenerator;

public class FIXMessageBuilder
implements Cloneable {
    private Header header;
    private Messages messages;
    private Trailer trailer;
    private Components comp;
    private Fields fields;
    private final DataValueGenerator dvg = new DataValueGenerator();
    private FixConfig fixConfig;
    private int poolSize = 10;

    public FIXMessageBuilder clone() {
        try {
            return (FIXMessageBuilder)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new AssertionError((Object)e);
        }
    }

    public FixMessagePool initFixMessagePool(boolean useDefault, int poolSize) {
        this.poolSize = poolSize;
        if (useDefault) {
            return new FixMessagePool(null, poolSize, useDefault);
        }
        return null;
    }

    public FIXMessageBuilder createHeader(int fieldCount) {
        this.header = (Header)this.dvg.nativeInstance(Header.class);
        this.header.setFieldSize(fieldCount).getField();
        return this;
    }

    public FIXMessageBuilder createMessages(int messagesSize, int fieldSize, int groupSize) {
        this.messages = (Messages)this.dvg.nativeInstance(Messages.class);
        this.messages.setMessagesSize(messagesSize).setFieldSize(fieldSize).setGroupSize(groupSize).getMessage();
        return this;
    }

    public FIXMessageBuilder createTrailer(int fieldSize) {
        this.trailer = (Trailer)this.dvg.nativeInstance(Trailer.class);
        this.trailer.getField();
        return this;
    }

    public FIXMessageBuilder createComponents() {
        return this;
    }

    public FIXMessageBuilder createFields(int fieldSize, int valueSize) {
        this.fields = (Fields)this.dvg.nativeInstance(Fields.class);
        this.fields.setFieldSize(fieldSize).setValueSize(valueSize);
        return this;
    }

    public Header getHeader() {
        return this.header;
    }

    public Messages getMessages() {
        return this.messages;
    }

    public Trailer getTrailer() {
        return this.trailer;
    }

    public Components getComp() {
        return this.comp;
    }

    public Fields getFields() {
        return this.fields;
    }

    public static void main(String ... args) throws Exception {
        int fixMsgCount = 5;
        FixMessagePool fmp = new FIXMessageBuilder().initFixMessagePool(true, fixMsgCount);
        FixMessagePool.FixMessageContainer fmc = fmp.getFixMessageContainer();
        FixMessage fm = fmc.getFixMessage();
        fm.getField(12).getFieldData().writeUTF("StringTestoeriupwouropweiur");
        System.out.println("-->" + fm.getFixString());
        fmp.putFixMessageContainer(fmc);
    }
}

