/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.fix.include.v42;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import net.openhft.fix.include.util.FixConstants;
import net.openhft.fix.include.v42.FIXMessageBuilder;
import net.openhft.fix.include.v42.Field;
import net.openhft.fix.include.v42.FixMessageInterface;

public class FixMessage
implements FixMessageInterface {
    protected int major = 4;
    protected int minor = 2;
    protected int servicepack = 0;
    protected CharSequence type = "FIX";
    private StringBuilder fixMsgOutput;
    private char delim = (char)124;
    private char equalsChar = (char)61;
    private Field[] field;

    public FixMessage(FIXMessageBuilder fixMsgBuilder) {
    }

    public Field[] getField() {
        return this.field;
    }

    public FixMessage(Field[] field) {
        this.field = field;
    }

    @Override
    public int getMajor() {
        return this.major;
    }

    @Override
    public int getMinor() {
        return this.minor;
    }

    @Override
    public int getServicepack() {
        return this.servicepack;
    }

    @Override
    public CharSequence getType() {
        return this.type;
    }

    public Field getField(int fieldLocation) {
        if (fieldLocation >= 0 && fieldLocation < this.field.length) {
            return this.field[fieldLocation - 1];
        }
        return null;
    }

    public String getFixString() {
        int msgSize = 0;
        this.fixMsgOutput = new StringBuilder();
        this.fixMsgOutput.setLength(0);
        this.fixMsgOutput.append(FixConstants.fieldsNumber[7]);
        this.fixMsgOutput.append(this.equalsChar);
        this.fixMsgOutput.append(this.type);
        this.fixMsgOutput.append(this.major);
        this.fixMsgOutput.append(this.minor);
        this.fixMsgOutput.append(this.servicepack);
        this.fixMsgOutput.append(this.delim);
        if (this.field != null) {
            for (int i = 0; i < this.field.length; ++i) {
                if (this.field[i].getFieldDataPostion() <= 0 || i == 8) continue;
                System.out.println(this.field[i].getFieldDataPostion());
                this.fixMsgOutput.append(this.field[i].getNumber());
                this.fixMsgOutput.append(this.equalsChar);
                this.fixMsgOutput.append(this.field[i].getFieldData().readUTF());
                this.fixMsgOutput.append(this.delim);
                msgSize += this.field[i].getFieldDataPostion();
            }
            this.fixMsgOutput.append(this.field[8].getNumber());
            this.fixMsgOutput.append(this.equalsChar);
            this.fixMsgOutput.append(msgSize);
            this.fixMsgOutput.append(this.delim);
        }
        return this.fixMsgOutput.toString();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeInt(this.major);
        out.writeInt(this.minor);
        out.writeInt(this.servicepack);
        out.writeUTF((String)this.type);
        out.writeObject(this.fixMsgOutput);
        out.writeChar(this.delim);
    }

    public int getCheckSum() {
        int checksum = 0;
        if (this.field != null) {
            for (int i = 0; i < this.field.length; ++i) {
                checksum = (int)((long)checksum + this.field[i].getFieldData().position());
            }
        }
        return checksum % 256;
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.major = in.readInt();
        this.minor = in.readInt();
        this.servicepack = in.readInt();
        this.type = in.readUTF();
        this.fixMsgOutput = (StringBuilder)in.readObject();
        this.delim = in.readChar();
    }

    public int isValid() {
        int[] validTagArray = new int[]{8, 9, 34, 35, 49, 56, 10};
        for (int i = 0; i < validTagArray.length; ++i) {
            if (this.field[validTagArray[i] - 1].getFieldData().position() >= 1L) continue;
            return 0;
        }
        return 1;
    }

    public void reset() {
        if (this.field != null) {
            for (int i = 0; i < this.field.length; ++i) {
                this.field[i].reset();
            }
        }
    }
}

