/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.fix.include.v42;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import net.openhft.fix.compiler.FieldLookup;
import net.openhft.fix.include.util.FixConstants;
import net.openhft.fix.include.util.FixMessagePool;
import net.openhft.fix.include.v42.FIXMessageBuilder;
import net.openhft.fix.include.v42.Field;
import net.openhft.fix.include.v42.FixMessage;
import net.openhft.fix.model.FixField;
import net.openhft.lang.io.ByteBufferBytes;
import net.openhft.lang.io.Bytes;
import net.openhft.lang.io.DirectBytes;
import net.openhft.lang.io.DirectStore;
import net.openhft.lang.io.StopCharTester;
import net.openhft.lang.io.StopCharTesters;

public class FixMessageReader {
    private CharSequence fixMsgChars;
    private Bytes fixMsgBytes;
    private final int FIELD_SIZE = FixConstants.fieldsNumber.length;
    private StringBuilder tempStringValue = new StringBuilder();
    private final byte FIELD_TERMINATOR = 1;
    private byte VERSION_CHECKED = 0;
    private FixMessage fixMsg;

    public FixMessageReader(FixMessage fixMsg) {
        this.fixMsg = fixMsg;
    }

    public FixMessage getFixMessage() {
        return this.fixMsg;
    }

    public void setFixMessage(FixMessage fixMsg) {
        this.fixMsg = fixMsg;
    }

    public void setFixBytes(ByteBufferBytes fixMsgBufBytes) {
        if (this.fixMsgBytes != null) {
            this.fixMsgBytes.clear();
        }
        this.fixMsgBytes = fixMsgBufBytes.flip();
    }

    public void setFixBytes(String fixMsgChars) {
        this.fixMsgChars = fixMsgChars;
        byte[] msgBytes = fixMsgChars.replace('|', '\u0001').getBytes();
        ByteBufferBytes byteBufBytes = new ByteBufferBytes(ByteBuffer.allocate(msgBytes.length).order(ByteOrder.nativeOrder()));
        byteBufBytes.write(msgBytes);
        if (this.fixMsgBytes != null) {
            this.fixMsgBytes.clear();
        }
        this.fixMsgBytes = byteBufBytes.flip();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void parseFixMsgBytes() throws Exception {
        long limit;
        long limit2;
        if (this.fixMsgBytes == null) {
            throw new Exception("Bytes is null or not preceded by setFixBytes()");
        }
        for (limit2 = limit = this.fixMsgBytes.limit(); limit2 > this.fixMsgBytes.position() && this.fixMsgBytes.readByte(limit2 - 1L) != 1; --limit2) {
        }
        this.fixMsgBytes.limit(limit2);
        boolean tmpSelf = this.fixMsgBytes.selfTerminating();
        try {
            this.fixMsgBytes.selfTerminating(true);
            while (this.fixMsgBytes.remaining() > 0L) {
                int fieldNum = (int)this.fixMsgBytes.parseLong();
                long pos = this.fixMsgBytes.position();
                this.searchForTheEndOfField(this.fixMsgBytes);
                long end = this.fixMsgBytes.position() - 1L;
                this.fixMsgBytes.limit(end);
                this.fixMsgBytes.position(pos);
                this.updateFixMessageField(fieldNum, this.fixMsgBytes);
                this.fixMsgBytes.limit(limit);
                this.fixMsgBytes.position(end + 1L);
            }
            this.fixMsgBytes.limit(limit);
            this.fixMsgBytes.position(limit2);
        }
        finally {
            this.fixMsgBytes.selfTerminating(tmpSelf);
        }
    }

    private void searchForTheEndOfField(Bytes bytes) {
        while (bytes.readByte() != 1) {
        }
    }

    private void updateFixMessageField(int fieldID, Bytes fieldValue) {
        if (this.fixMsg.getField(fieldID).getFieldData().position() != 0L) {
            this.fixMsg.getField(fieldID).getFieldData().writeByte((int)Field.getMultiValueDelim());
        }
        this.fixMsg.getField(fieldID).setFieldData((ByteBufferBytes)fieldValue);
    }

    private void updateFixMessageFields(int fieldID, Bytes fieldValue) throws Exception {
        this.fixMsg.getField(fieldID).setName(FixConstants.fieldsName[fieldID]);
        this.fixMsg.getField(fieldID).setNumber(fieldID);
        FixField ff = FieldLookup.fieldFor(FixConstants.fieldsTypeOrdering[fieldID + 1]);
        if (ff.isChar()) {
            this.fixMsg.getField(fieldID).setType(FixField.Boolean);
            if (this.fixMsg.getField(fieldID).getFieldData().position() != 0L) {
                this.fixMsg.getField(fieldID).getFieldData().writeByte((int)Field.getMultiValueDelim());
            }
            this.fixMsg.getField(fieldID).getFieldData().writeChar((int)fieldValue.readChar());
        } else if (ff.isDouble()) {
            this.fixMsg.getField(fieldID).setType(FixField.Double);
            if (this.fixMsg.getField(fieldID).getFieldData().position() != 0L) {
                this.fixMsg.getField(fieldID).getFieldData().writeByte((int)Field.getMultiValueDelim());
            }
            this.fixMsg.getField(fieldID).getFieldData().writeDouble(fieldValue.parseDouble());
        } else if (ff.isInt()) {
            this.fixMsg.getField(fieldID).setType(FixField.Int);
            if (this.fixMsg.getField(fieldID).getFieldData().position() != 0L) {
                this.fixMsg.getField(fieldID).getFieldData().writeByte((int)Field.getMultiValueDelim());
            }
            this.fixMsg.getField(fieldID).getFieldData().writeInt24((int)fieldValue.parseLong());
        } else if (ff.isLong()) {
            this.fixMsg.getField(fieldID).setType(FixField.Length);
            if (this.fixMsg.getField(fieldID).getFieldData().position() != 0L) {
                this.fixMsg.getField(fieldID).getFieldData().writeByte((int)Field.getMultiValueDelim());
            }
            this.fixMsg.getField(fieldID).getFieldData().writeLong(fieldValue.parseLong());
        } else if (ff.isString()) {
            this.fixMsg.getField(fieldID).setType(FixField.String);
            if (this.fixMsg.getField(fieldID).getFieldData().position() != 0L) {
                this.fixMsg.getField(fieldID).getFieldData().writeByte((int)Field.getMultiValueDelim());
            }
            this.tempStringValue.setLength(0);
            fieldValue.parseUTF(this.tempStringValue, (StopCharTester)StopCharTesters.ALL);
            if (this.VERSION_CHECKED == 0 && fieldID == 8) {
                if (this.tempStringValue.toString().equalsIgnoreCase("FIX.4.2")) {
                    this.VERSION_CHECKED = 0;
                } else {
                    throw new Exception("Only FIX.4.2 supported");
                }
            }
            this.fixMsg.getField(fieldID).getFieldData().write(this.tempStringValue.toString().getBytes());
        }
    }

    public static void main(String[] args) throws Exception {
        String sampleFixMessage = "8=FIX.4.2|9=154|35=6|49=BRKR|56=INVMGR|34=238|52=19980604-07:59:56|23=115686|28=N|55=FIA.MI|54=2|27=250000|44=7900.000000|25=H|10=231|";
        int fixMsgCount = Runtime.getRuntime().availableProcessors();
        FixMessagePool fmp = new FIXMessageBuilder().initFixMessagePool(true, fixMsgCount);
        FixMessagePool.FixMessageContainer fmc = fmp.getFixMessageContainer();
        FixMessage fm = fmc.getFixMessage();
        FixMessageReader fmr = new FixMessageReader(fm);
        DirectBytes nativeBytes = new DirectStore((long)sampleFixMessage.length()).bytes();
        nativeBytes.write(sampleFixMessage.replace('|', '\u0001').getBytes());
        byte[] msgBytes = sampleFixMessage.replace('|', '\u0001').getBytes();
        ByteBufferBytes byteBufBytes = new ByteBufferBytes(ByteBuffer.allocate(msgBytes.length).order(ByteOrder.nativeOrder()));
        byteBufBytes.write(msgBytes);
        int counter = 0;
        int runs = 300000;
        long start = System.nanoTime();
        for (int i = 0; i < runs; ++i) {
            fmr.setFixBytes(byteBufBytes);
            fmr.parseFixMsgBytes();
            ++counter;
        }
        long time = System.nanoTime() - start;
        System.out.printf("Average parse time was %.2f us, fields per message %.2f%n", (double)(time / (long)runs) / 1000.0, (double)counter / (double)runs);
    }
}

