/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.hashing;

import java.io.Serializable;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import net.openhft.hashing.Access;
import net.openhft.hashing.ByteBufferAccess;
import net.openhft.hashing.CharSequenceAccess;
import net.openhft.hashing.CityHash_1_1;
import net.openhft.hashing.HotSpotPrior7u6StringHash;
import net.openhft.hashing.ModernHotSpotStringHash;
import net.openhft.hashing.MurmurHash_3;
import net.openhft.hashing.StringHash;
import net.openhft.hashing.UnknownJvmStringHash;
import net.openhft.hashing.UnsafeAccess;
import org.jetbrains.annotations.NotNull;

public abstract class LongHashFunction
implements Serializable {
    private static final long serialVersionUID = 0L;
    static final boolean NATIVE_LITTLE_ENDIAN = ByteOrder.nativeOrder() == ByteOrder.LITTLE_ENDIAN;
    static final byte TRUE_BYTE_VALUE = UnsafeAccess.UNSAFE.getByte(new boolean[]{true}, UnsafeAccess.BOOLEAN_BASE);
    static final byte FALSE_BYTE_VALUE = UnsafeAccess.UNSAFE.getByte(new boolean[]{false}, UnsafeAccess.BOOLEAN_BASE);
    private static StringHash stringHash;

    public static LongHashFunction city_1_1() {
        return CityHash_1_1.asLongHashFunctionWithoutSeed();
    }

    public static LongHashFunction city_1_1(long seed) {
        return CityHash_1_1.asLongHashFunctionWithSeed(seed);
    }

    public static LongHashFunction city_1_1(long seed0, long seed1) {
        return CityHash_1_1.asLongHashFunctionWithTwoSeeds(seed0, seed1);
    }

    public static LongHashFunction murmur_3() {
        return MurmurHash_3.asLongHashFunctionWithoutSeed();
    }

    public static LongHashFunction murmur_3(long seed) {
        return MurmurHash_3.asLongHashFunctionWithSeed(seed);
    }

    private static void checkArrayOffs(int arrayLength, int off, int len) {
        if (len < 0 || off < 0 || off + len > arrayLength || off + len < 0) {
            throw new IndexOutOfBoundsException();
        }
    }

    protected LongHashFunction() {
    }

    public abstract long hashLong(long var1);

    public abstract long hashInt(int var1);

    public abstract long hashShort(short var1);

    public abstract long hashChar(char var1);

    public abstract long hashByte(byte var1);

    public abstract long hashVoid();

    public abstract <T> long hash(T var1, Access<T> var2, long var3, long var5);

    private long unsafeHash(Object input, long off, long len) {
        return this.hash(input, UnsafeAccess.INSTANCE, off, len);
    }

    public long hashBoolean(boolean input) {
        return this.hashByte(input ? TRUE_BYTE_VALUE : FALSE_BYTE_VALUE);
    }

    public long hashBooleans(@NotNull boolean[] input) {
        return this.hashBooleans(input, 0, input.length);
    }

    public long hashBooleans(@NotNull boolean[] input, int off, int len) {
        LongHashFunction.checkArrayOffs(input.length, off, len);
        return this.unsafeHash(input, UnsafeAccess.BOOLEAN_BASE + (long)off, len);
    }

    public long hashBytes(@NotNull byte[] input) {
        return this.hashBytes(input, 0, input.length);
    }

    public long hashBytes(@NotNull byte[] input, int off, int len) {
        LongHashFunction.checkArrayOffs(input.length, off, len);
        return this.unsafeHash(input, UnsafeAccess.BYTE_BASE + (long)off, len);
    }

    public long hashBytes(ByteBuffer input) {
        return this.hashBytes(input, input.position(), input.remaining());
    }

    public long hashBytes(@NotNull ByteBuffer input, int off, int len) {
        LongHashFunction.checkArrayOffs(input.capacity(), off, len);
        return this.hash(input, ByteBufferAccess.INSTANCE, off, len);
    }

    public long hashMemory(long address, long len) {
        return this.unsafeHash(null, address, len);
    }

    public long hashChars(@NotNull char[] input) {
        return this.hashChars(input, 0, input.length);
    }

    public long hashChars(@NotNull char[] input, int off, int len) {
        LongHashFunction.checkArrayOffs(input.length, off, len);
        return this.unsafeHash(input, UnsafeAccess.CHAR_BASE + (long)off * 2L, (long)len * 2L);
    }

    public long hashChars(@NotNull String input) {
        return stringHash.longHash(input, this, 0, input.length());
    }

    public long hashChars(@NotNull String input, int off, int len) {
        LongHashFunction.checkArrayOffs(input.length(), off, len);
        return stringHash.longHash(input, this, off, len);
    }

    public long hashChars(@NotNull StringBuilder input) {
        return this.hashNativeChars(input);
    }

    public long hashChars(@NotNull StringBuilder input, int off, int len) {
        return this.hashNativeChars(input, off, len);
    }

    long hashNativeChars(CharSequence input) {
        return this.hashNativeChars(input, 0, input.length());
    }

    long hashNativeChars(CharSequence input, int off, int len) {
        LongHashFunction.checkArrayOffs(input.length(), off, len);
        return this.hash(input, CharSequenceAccess.nativeCharSequenceAccess(), (long)off * 2L, (long)len * 2L);
    }

    public long hashShorts(@NotNull short[] input) {
        return this.hashShorts(input, 0, input.length);
    }

    public long hashShorts(@NotNull short[] input, int off, int len) {
        LongHashFunction.checkArrayOffs(input.length, off, len);
        return this.unsafeHash(input, UnsafeAccess.SHORT_BASE + (long)off * 2L, (long)len * 2L);
    }

    public long hashInts(@NotNull int[] input) {
        return this.hashInts(input, 0, input.length);
    }

    public long hashInts(@NotNull int[] input, int off, int len) {
        LongHashFunction.checkArrayOffs(input.length, off, len);
        return this.unsafeHash(input, UnsafeAccess.INT_BASE + (long)off * 4L, (long)len * 4L);
    }

    public long hashLongs(@NotNull long[] input) {
        return this.hashLongs(input, 0, input.length);
    }

    public long hashLongs(@NotNull long[] input, int off, int len) {
        LongHashFunction.checkArrayOffs(input.length, off, len);
        return this.unsafeHash(input, UnsafeAccess.LONG_BASE + (long)off * 8L, (long)len * 8L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static {
        try {
            stringHash = System.getProperty("java.vm.name").contains("HotSpot") ? (System.getProperty("java.version").compareTo("1.7.0_06") >= 0 ? ModernHotSpotStringHash.INSTANCE : HotSpotPrior7u6StringHash.INSTANCE) : HotSpotPrior7u6StringHash.INSTANCE;
        }
        catch (Throwable throwable) {
        }
        finally {
            if (stringHash == null) {
                stringHash = UnknownJvmStringHash.INSTANCE;
            }
        }
    }
}

