/*
 * Decompiled with CFR 0.152.
 */
package net.openid.appauth;

import androidx.annotation.NonNull;
import net.openid.appauth.Preconditions;
import net.openid.appauth.browser.AnyBrowserMatcher;
import net.openid.appauth.browser.BrowserMatcher;
import net.openid.appauth.connectivity.ConnectionBuilder;
import net.openid.appauth.connectivity.DefaultConnectionBuilder;

public class AppAuthConfiguration {
    public static final AppAuthConfiguration DEFAULT = new Builder().build();
    @NonNull
    private final BrowserMatcher mBrowserMatcher;
    @NonNull
    private final ConnectionBuilder mConnectionBuilder;

    private AppAuthConfiguration(@NonNull BrowserMatcher browserMatcher, @NonNull ConnectionBuilder connectionBuilder) {
        this.mBrowserMatcher = browserMatcher;
        this.mConnectionBuilder = connectionBuilder;
    }

    @NonNull
    public BrowserMatcher getBrowserMatcher() {
        return this.mBrowserMatcher;
    }

    @NonNull
    public ConnectionBuilder getConnectionBuilder() {
        return this.mConnectionBuilder;
    }

    public static class Builder {
        private BrowserMatcher mBrowserMatcher = AnyBrowserMatcher.INSTANCE;
        private ConnectionBuilder mConnectionBuilder = DefaultConnectionBuilder.INSTANCE;

        @NonNull
        public Builder setBrowserMatcher(@NonNull BrowserMatcher browserMatcher) {
            Preconditions.checkNotNull(browserMatcher, "browserMatcher cannot be null");
            this.mBrowserMatcher = browserMatcher;
            return this;
        }

        @NonNull
        public Builder setConnectionBuilder(@NonNull ConnectionBuilder connectionBuilder) {
            Preconditions.checkNotNull(connectionBuilder, "connectionBuilder cannot be null");
            this.mConnectionBuilder = connectionBuilder;
            return this;
        }

        @NonNull
        public AppAuthConfiguration build() {
            return new AppAuthConfiguration(this.mBrowserMatcher, this.mConnectionBuilder);
        }
    }
}

