/*
 * Decompiled with CFR 0.152.
 */
package net.openid.appauth.browser;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import net.openid.appauth.browser.DelimitedVersion;

public class VersionRange {
    public static final VersionRange ANY_VERSION = new VersionRange(null, null);
    private DelimitedVersion mLowerBound;
    private DelimitedVersion mUpperBound;

    public static VersionRange atLeast(String version) {
        return VersionRange.atLeast(DelimitedVersion.parse(version));
    }

    public static VersionRange atLeast(DelimitedVersion version) {
        return new VersionRange(version, null);
    }

    public static VersionRange atMost(String version) {
        return VersionRange.atMost(DelimitedVersion.parse(version));
    }

    public static VersionRange atMost(DelimitedVersion version) {
        return new VersionRange(null, version);
    }

    public static VersionRange between(String lowerBound, String upperBound) {
        return new VersionRange(DelimitedVersion.parse(lowerBound), DelimitedVersion.parse(upperBound));
    }

    public VersionRange(@Nullable DelimitedVersion lowerBound, @Nullable DelimitedVersion upperBound) {
        this.mLowerBound = lowerBound;
        this.mUpperBound = upperBound;
    }

    public boolean matches(@NonNull String version) {
        return this.matches(DelimitedVersion.parse(version));
    }

    public boolean matches(@NonNull DelimitedVersion version) {
        if (this.mLowerBound != null && this.mLowerBound.compareTo(version) > 0) {
            return false;
        }
        return this.mUpperBound == null || this.mUpperBound.compareTo(version) >= 0;
    }

    public String toString() {
        if (this.mLowerBound == null) {
            if (this.mUpperBound == null) {
                return "any version";
            }
            return this.mUpperBound.toString() + " or lower";
        }
        if (this.mUpperBound != null) {
            return "between " + this.mLowerBound + " and " + this.mUpperBound;
        }
        return this.mLowerBound.toString() + " or higher";
    }
}

