/*
 * Decompiled with CFR 0.152.
 */
package net.optionfactory.spring.thymeleaf.dialects;

import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.ParseException;
import java.util.function.Supplier;

public class Money {
    private static final BigDecimal HUNDRED = new BigDecimal(100);
    private final Supplier<DecimalFormatSymbols> symbolsStrategy;

    public Money(Supplier<DecimalFormatSymbols> symbolsStrategy) {
        this.symbolsStrategy = symbolsStrategy;
    }

    public long parseCents(String value) {
        DecimalFormat decimalFormat = new DecimalFormat("#,##0.##", this.symbolsStrategy.get());
        decimalFormat.setParseBigDecimal(true);
        try {
            BigDecimal euros = (BigDecimal)decimalFormat.parse(value);
            return euros.multiply(new BigDecimal(100)).longValue();
        }
        catch (ParseException ex) {
            throw new IllegalArgumentException("Specificare una cifra valida (es. 1234,56)");
        }
    }

    public String formatCents(long cents) {
        return this.formatCents(cents, false);
    }

    public String formatCents(long cents, boolean hideCents) {
        BigDecimal bd = new BigDecimal(cents).divide(HUNDRED);
        return this.format(bd, hideCents);
    }

    public String format(BigDecimal bd) {
        return this.format(bd, false);
    }

    public String format(BigDecimal bd, boolean hideCents) {
        DecimalFormatSymbols symbols = this.symbolsStrategy.get();
        return hideCents ? new DecimalFormat("#,###", symbols).format(bd) : new DecimalFormat("#,##0.00", symbols).format(bd);
    }

    public static class ItalianSymbols
    implements Supplier<DecimalFormatSymbols> {
        @Override
        public DecimalFormatSymbols get() {
            DecimalFormatSymbols s = new DecimalFormatSymbols();
            s.setDecimalSeparator(',');
            s.setGroupingSeparator('.');
            return s;
        }
    }
}

