/*
 * Decompiled with CFR 0.152.
 */
package net.orbyfied.j8.util.functional;

import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.BiPredicate;
import java.util.function.Function;
import java.util.function.Supplier;
import net.orbyfied.j8.util.functional.Operation;

public interface EntryOperation<R, K, V>
extends Operation<R> {
    public R with();

    public R without();

    public V get();

    public boolean has();

    public K key();

    public V val();

    public static <R, K, V> Builder<R, K, V> builder() {
        return new Builder();
    }

    public static <R, K, V> EntryOperation<R, K, V> ofMapEntry(final R ret, final Map<K, V> map, final K k, final V v) {
        return new EntryOperation<R, K, V>(){

            @Override
            public R with() {
                map.put(k, v);
                return ret;
            }

            @Override
            public R without() {
                map.remove(k, v);
                return ret;
            }

            @Override
            public V get() {
                return map.get(k);
            }

            @Override
            public boolean has() {
                return map.containsKey(k);
            }

            @Override
            public K key() {
                return k;
            }

            @Override
            public V val() {
                return v;
            }

            @Override
            public R skip() {
                return ret;
            }
        };
    }

    public static <R, V> EntryOperation<R, V, V> ofListEntry(final R ret, final List<V> list, final V val) {
        return new EntryOperation<R, V, V>(){

            @Override
            public R with() {
                list.add(val);
                return ret;
            }

            @Override
            public R without() {
                list.add(val);
                return ret;
            }

            @Override
            public V get() {
                return val;
            }

            @Override
            public boolean has() {
                return list.contains(val);
            }

            @Override
            public V key() {
                return val;
            }

            @Override
            public V val() {
                return val;
            }

            @Override
            public R skip() {
                return ret;
            }
        };
    }

    public static class Builder<R, K, V> {
        Supplier<R> returner;
        K key;
        V val;
        BiConsumer<K, V> doWith;
        BiConsumer<K, V> doWithout;
        Function<K, V> doGet;
        BiPredicate<K, V> doHas;

        public Builder<R, K, V> returns(R ret) {
            this.returner = () -> ret;
            return this;
        }

        public Builder<R, K, V> returns(Supplier<R> ret) {
            this.returner = ret;
            return this;
        }

        public Builder<R, K, V> key(K k) {
            this.key = k;
            return this;
        }

        public Builder<R, K, V> value(V v) {
            this.val = v;
            return this;
        }

        public Builder<R, K, V> doWith(BiConsumer<K, V> doWith) {
            this.doWith = doWith;
            return this;
        }

        public Builder<R, K, V> doWithout(BiConsumer<K, V> doWithout) {
            this.doWithout = doWithout;
            return this;
        }

        public Builder<R, K, V> doGet(Function<K, V> doGet) {
            this.doGet = doGet;
            return this;
        }

        public Builder<R, K, V> doHas(BiPredicate<K, V> doHas) {
            this.doHas = doHas;
            return this;
        }

        public EntryOperation<R, K, V> build() {
            return new EntryOperation<R, K, V>(){

                @Override
                public R with() {
                    doWith.accept(key, val);
                    return returner.get();
                }

                @Override
                public R without() {
                    doWithout.accept(key, val);
                    return returner.get();
                }

                @Override
                public V get() {
                    return doGet.apply(key);
                }

                @Override
                public boolean has() {
                    return doHas.test(key, val);
                }

                @Override
                public K key() {
                    return key;
                }

                @Override
                public V val() {
                    return val;
                }

                @Override
                public R skip() {
                    return returner.get();
                }
            };
        }
    }
}

