/*
 * Decompiled with CFR 0.152.
 */
package net.orbyfied.j8.util.logging;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import net.orbyfied.j8.util.logging.LogLevel;
import net.orbyfied.j8.util.logging.LogPipeline;
import net.orbyfied.j8.util.logging.LogRecord;
import net.orbyfied.j8.util.logging.LogText;
import net.orbyfied.j8.util.logging.Logger;
import net.orbyfied.j8.util.logging.io.LogOutput;

public class LoggerGroup {
    public static final LoggerGroup GLOBAL = new LoggerGroup("global");
    final String name;
    LoggerWorker worker = new LoggerWorker();
    AtomicBoolean active = new AtomicBoolean(false);
    AtomicBoolean waiting = new AtomicBoolean(false);
    Object lock = new Object();
    Deque<LogRecord> queue = new ArrayDeque<LogRecord>();
    LogPipeline pipeline = new LogPipeline();
    List<Configure> configures = new ArrayList<Configure>();
    List<Logger> loggers = new ArrayList<Logger>();
    Map<String, Logger> loggersByName = new HashMap<String, Logger>();

    public LoggerGroup(String name) {
        this.name = name;
        this.setActive(true);
    }

    public LoggerGroup addConfigure(Configure configure) {
        this.configures.add(configure);
        return this;
    }

    public LoggerGroup removeConfigure(Configure configure) {
        this.configures.remove(configure);
        return this;
    }

    public Logger getByName(String name) {
        return this.loggersByName.get(name);
    }

    public Logger create(String name) {
        Logger logger = new Logger(this, name);
        this.add(logger);
        return logger;
    }

    public LoggerGroup add(Logger logger) {
        this.loggers.add(logger);
        this.loggersByName.put(logger.name, logger);
        return this;
    }

    public LoggerGroup remove(Logger logger) {
        if (logger == null) {
            return this;
        }
        this.loggers.remove(logger);
        this.loggersByName.remove(logger.name);
        return this;
    }

    public LoggerGroup remove(String name) {
        return this.remove(this.getByName(name));
    }

    protected void applyConfig(Logger logger) {
        logger.outputs.add(LogOutput.STDOUT);
        for (Configure configure : this.configures) {
            configure.configure(this, logger);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void queue(LogRecord record) {
        Object object = this.queue;
        synchronized (object) {
            this.queue.add(record);
        }
        if (this.waiting.get()) {
            object = this.lock;
            synchronized (object) {
                this.lock.notifyAll();
            }
        }
    }

    private void activate() {
        this.worker.start();
    }

    private void deactivate() {
        try {
            this.worker.stop();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public LoggerGroup setActive(boolean b) {
        this.active.set(b);
        if (b) {
            this.activate();
        } else {
            this.deactivate();
        }
        return this;
    }

    class LoggerWorker
    extends Thread {
        LoggerWorker() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (LoggerGroup.this.active.get()) {
                try {
                    Object object = LoggerGroup.this.lock;
                    synchronized (object) {
                        LoggerGroup.this.waiting.set(true);
                        LoggerGroup.this.lock.wait();
                    }
                }
                catch (Exception e) {
                    LoggerGroup.this.waiting.set(false);
                    e.printStackTrace();
                }
                LoggerGroup.this.waiting.set(false);
                if (LoggerGroup.this.queue.size() == 0) continue;
                while (LoggerGroup.this.queue.size() != 0) {
                    LogRecord record = LoggerGroup.this.queue.poll();
                    Logger logger = record.getLogger();
                    LogText text = record.getText();
                    LogLevel level = record.getLevel();
                    List<Object> message = record.getMessage();
                    String stage = record.stage;
                    LogText tLogger = text.sub("logger");
                    tLogger.put("[");
                    tLogger.put("logger-tag", logger.tag);
                    if (stage != null) {
                        tLogger.put("/");
                        tLogger.put("logger-stage", stage);
                    }
                    tLogger.put("]");
                    LogText tLevel = text.sub("level");
                    tLevel.put("[");
                    level.getTagger().accept(record, tLevel);
                    tLevel.put("]");
                    LogText tMessage = text.sub("message");
                    tMessage.put(" ");
                    int l = message.size();
                    for (int i = 0; i < l; ++i) {
                        tMessage.put(Integer.toString(i), Objects.toString(message.get(i)));
                    }
                    if (text.newLine()) {
                        text.lockNewline();
                        text.put("newline", Character.valueOf('\n'));
                    }
                    record.setCancelled(false);
                    logger.pipeline.push(record);
                    if (record.isCancelled()) continue;
                    record.setCancelled(false);
                    LoggerGroup.this.pipeline.push(record);
                    if (record.isCancelled()) continue;
                    for (LogOutput output : logger.outputs) {
                        output.queue(record);
                    }
                }
            }
        }
    }

    public static interface Configure {
        public void configure(LoggerGroup var1, Logger var2);
    }
}

