/*
 * Decompiled with CFR 0.152.
 */
package net.orbyfied.j8.util.logging.formatting.attr;

import java.awt.Color;
import net.orbyfied.j8.util.logging.formatting.AnsiAttr;

public abstract class ColorAttr
extends AnsiAttr {
    protected String[] color;
    protected Object col;

    public ColorAttr(char c) {
        if (c > '\u00ff') {
            throw new IllegalArgumentException("invalid color char/number, range: [0-255]");
        }
        this.col = Character.valueOf(c);
        this.color = new String[]{String.valueOf(c)};
    }

    public ColorAttr(int r, int g, int b) {
        ColorAttr.uValidateColorComponents(r, g, b);
        this.col = new Color(r, g, b);
        this.color = new String[]{String.valueOf(r), String.valueOf(g), String.valueOf(b)};
    }

    public ColorAttr(Color color) {
        this(color.getRed(), color.getGreen(), color.getBlue());
    }

    public Object getColorAsObject() {
        return this.col;
    }

    public boolean isRGB() {
        return this.color.length == 3;
    }

    public abstract String seqPrefix(Object ... var1);

    public String sequence() {
        if (this.isRGB()) {
            return this.color[0] + ";" + this.color[1] + ";" + this.color[2];
        }
        return this.color[0];
    }

    @Override
    public String code(Object ... args) {
        return this.seqPrefix(args) + this.sequence();
    }

    private static void uValidateColorComponents(int r, int g, int b) {
        if (r < 0 || r > 255 || g < 0 || g > 255 || b < 0 || b > 255) {
            throw new IllegalArgumentException("invalid color range; expected [0-255] for all 3 components, got: " + r + ", " + g + ", " + b);
        }
    }
}

