/*
 * Decompiled with CFR 0.152.
 */
package net.orbyfied.j8.util.math.expr;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.function.Supplier;
import net.orbyfied.j8.util.Reader;
import net.orbyfied.j8.util.Sequence;
import net.orbyfied.j8.util.StringReader;
import net.orbyfied.j8.util.math.expr.Context;
import net.orbyfied.j8.util.math.expr.ExpressionFunction;
import net.orbyfied.j8.util.math.expr.ExpressionNode;
import net.orbyfied.j8.util.math.expr.ExpressionValue;
import net.orbyfied.j8.util.math.expr.Operator;
import net.orbyfied.j8.util.math.expr.StringLocation;
import net.orbyfied.j8.util.math.expr.Token;
import net.orbyfied.j8.util.math.expr.error.ExprInterpreterException;
import net.orbyfied.j8.util.math.expr.error.ExprParserException;
import net.orbyfied.j8.util.math.expr.error.SyntaxError;
import net.orbyfied.j8.util.math.expr.node.AssignNode;
import net.orbyfied.j8.util.math.expr.node.BinOpNode;
import net.orbyfied.j8.util.math.expr.node.CallNode;
import net.orbyfied.j8.util.math.expr.node.ConstantNode;
import net.orbyfied.j8.util.math.expr.node.IndexNode;
import net.orbyfied.j8.util.math.expr.node.ReturnContextNode;
import net.orbyfied.j8.util.math.expr.node.UnaryOpNode;

public class ExpressionParser {
    private static final Set<Character> DIGITS_2 = Set.of(Character.valueOf('0'), Character.valueOf('1'));
    private static final Set<Character> DIGITS_8 = Set.of(Character.valueOf('0'), Character.valueOf('1'), Character.valueOf('2'), Character.valueOf('3'), Character.valueOf('4'), Character.valueOf('5'), Character.valueOf('6'), Character.valueOf('7'));
    private static final Set<Character> DIGITS_10 = Set.of(Character.valueOf('0'), Character.valueOf('1'), Character.valueOf('2'), Character.valueOf('3'), Character.valueOf('4'), Character.valueOf('5'), Character.valueOf('6'), Character.valueOf('7'), Character.valueOf('8'), Character.valueOf('9'));
    private static final Set<Character> DIGITS_16 = Set.of(Character.valueOf('0'), Character.valueOf('1'), Character.valueOf('2'), Character.valueOf('3'), Character.valueOf('4'), Character.valueOf('5'), Character.valueOf('6'), Character.valueOf('7'), Character.valueOf('8'), Character.valueOf('9'), Character.valueOf('A'), Character.valueOf('B'), Character.valueOf('C'), Character.valueOf('D'), Character.valueOf('E'), Character.valueOf('F'));
    List<Token<?>> tokens = new ArrayList();
    StringReader strReader;
    String fn = "<in>";
    ExpressionNode astNode;
    Reader<Token<?>> tokenReader;

    void tokenize() {
        char c;
        if (this.strReader == null) {
            return;
        }
        while ((c = this.strReader.current()) != '\uffff') {
            int si;
            if (this.isWhitespace(c)) {
                this.strReader.next();
                continue;
            }
            if (this.isDigit(c, 10)) {
                si = this.strReader.index();
                this.tokens.add(this.collectNumberLiteral().located(this.fn, this.strReader, si, this.strReader.index()));
                continue;
            }
            Token tk = null;
            si = this.strReader.index();
            Operator op = null;
            switch (c) {
                case '+': {
                    op = Operator.PLUS;
                    break;
                }
                case '-': {
                    if (this.strReader.peek(1) == '>') {
                        tk = new Token(Token.Type.ARROW);
                        this.strReader.next();
                        break;
                    }
                    op = Operator.MINUS;
                    break;
                }
                case '/': {
                    op = Operator.DIVIDE;
                    break;
                }
                case '*': {
                    op = Operator.MULTIPLY;
                    break;
                }
                case '^': {
                    op = Operator.POW;
                }
            }
            if (op != null) {
                this.tokens.add(new Token<Operator>(Token.Type.OPERATOR, op).located(new StringLocation(this.fn, this.strReader, si, this.strReader.index())));
                this.strReader.next();
                continue;
            }
            si = this.strReader.index();
            if (tk == null) {
                switch (c) {
                    case '(': {
                        tk = new Token(Token.Type.LEFT_PARENTHESIS);
                        break;
                    }
                    case ')': {
                        tk = new Token(Token.Type.RIGHT_PARENTHESIS);
                        break;
                    }
                    case ',': {
                        tk = new Token(Token.Type.COMMA);
                        break;
                    }
                    case '.': {
                        tk = new Token(Token.Type.DOT);
                        break;
                    }
                    case '=': {
                        tk = new Token(Token.Type.ASSIGN);
                        break;
                    }
                    case ':': {
                        tk = new Token(Token.Type.COLON);
                    }
                }
            }
            if (tk != null) {
                this.tokens.add(tk.located(new StringLocation(this.fn, this.strReader, si, this.strReader.index())));
                this.strReader.next();
                continue;
            }
            if (this.isFirstIdChar(c)) {
                si = this.strReader.index();
                Token itk = this.collectIdentifier();
                this.tokens.add((switch (itk.getValueAs(String.class)) {
                    case "func" -> new Token(Token.Type.KW_FUNC);
                    default -> itk;
                }).located(new StringLocation(this.fn, this.strReader, si, this.strReader.index() - 1)));
                continue;
            }
            throw new ExprParserException("unknown symbol while tokenizing").located(new StringLocation(this.fn, this.strReader, this.strReader.index(), this.strReader.index()));
        }
    }

    boolean isFirstIdChar(char c) {
        char c1 = Character.toUpperCase(c);
        return c1 >= 'A' && c1 <= 'Z' || c == '_';
    }

    boolean isIdChar(char c) {
        return this.isFirstIdChar(c) || this.isDigit(c, 10);
    }

    Token<String> collectIdentifier() {
        String id = this.strReader.collect(this::isIdChar);
        return new Token<String>(Token.Type.IDENTIFIER, id);
    }

    Token<Double> collectNumberLiteral() {
        double v;
        int si = this.strReader.index();
        int radix = 10;
        if (this.strReader.current() == '0') {
            char n = this.strReader.next();
            this.strReader.next();
            if (n == 'x') {
                radix = 16;
            } else if (n == 'o') {
                radix = 8;
            } else if (n == 'b') {
                radix = 2;
            } else {
                this.strReader.prev(2);
            }
        }
        boolean[] hasPoint = new boolean[1];
        int finalRadix = radix;
        String ns = this.strReader.collect(c1 -> this.isDigit(c1.charValue(), finalRadix) || c1.charValue() == '.', c1 -> c1.charValue() == '_', c1 -> {
            if (c1.charValue() == '.') {
                hasPoint[0] = true;
            }
        });
        try {
            v = hasPoint[0] ? Double.parseDouble(ns) : (double)Long.parseLong(ns, radix);
        }
        catch (NumberFormatException e) {
            throw new ExprParserException("NumberFormatError: " + e.getMessage()).located(new StringLocation(this.fn, this.strReader.getString(), si, this.strReader.index() - 1));
        }
        return new Token<Double>(Token.Type.NUMBER_LITERAL, v);
    }

    private boolean isWhitespace(char c) {
        return c == ' ' || c == '\n' || c == '\t';
    }

    private boolean isDigit(char c, int radix) {
        char c1 = Character.toUpperCase(c);
        return switch (radix) {
            case 2 -> DIGITS_2.contains(Character.valueOf(c1));
            case 8 -> DIGITS_8.contains(Character.valueOf(c1));
            case 10 -> DIGITS_10.contains(Character.valueOf(c1));
            case 16 -> DIGITS_16.contains(Character.valueOf(c1));
            default -> false;
        };
    }

    private ExpressionNode node$BinOp(Supplier<ExpressionNode> supplier, Set<Operator> ops) {
        Token<?> tok;
        if (this.tokenReader.current() == null) {
            throw new SyntaxError("expected expression");
        }
        ExpressionNode left = supplier.get();
        while ((tok = this.tokenReader.current()) != null && tok.getType() == Token.Type.OPERATOR && ops.contains((Object)tok.getValueAs(Operator.class))) {
            Operator op = (Operator)((Object)tok.getValueAs());
            this.tokenReader.next();
            if (this.tokenReader.current() == null) {
                throw new SyntaxError("expected expression as second operand").located(new StringLocation(tok.loc, tok.loc.startIndex + 1, tok.loc.endIndex + 1));
            }
            ExpressionNode right = supplier.get();
            left = new BinOpNode(op, left, right).located(tok.loc);
        }
        return left;
    }

    private ConstantNode val$FuncDef() {
        Token<?> t1;
        ArrayList<String> paramNames = new ArrayList<String>();
        ArrayList<String> paramTypes = new ArrayList<String>();
        while ((t1 = this.tokenReader.current()) != null && t1.type != Token.Type.RIGHT_PARENTHESIS) {
            this.tokenReader.next();
            if (this.tokenReader.current() == null) {
                throw new SyntaxError("expected ')' to close function call");
            }
            if (this.tokenReader.current().type == Token.Type.RIGHT_PARENTHESIS) break;
            if (this.tokenReader.current().type == Token.Type.COMMA) continue;
            paramNames.add(this.tokenReader.current().getValueAs(String.class));
            Token<?> tk = this.tokenReader.peek(1);
            if (tk != null && tk.type == Token.Type.COLON) {
                this.tokenReader.next(2);
                if (this.tokenReader.current() == null || this.tokenReader.current().type != Token.Type.IDENTIFIER) {
                    throw new SyntaxError("expected identifier to denote type after ':'").located(new StringLocation(tk.loc, tk.loc.getStartIndex() + 1, tk.loc.getEndIndex() + 1));
                }
                String id = (String)this.tokenReader.current().getValueAs();
                paramTypes.add(id);
                continue;
            }
            paramTypes.add(null);
        }
        this.tokenReader.next();
        ExpressionNode body = this.node$Expr();
        return new ConstantNode(ExpressionFunction.make((ctx, args) -> {
            Context c = ctx.child(true);
            if (args.length < paramNames.size() || args.length > paramNames.size()) {
                throw new ExprInterpreterException("Expected " + paramNames.size() + " parameters, got " + args.length);
            }
            int l = args.length;
            for (int i = 0; i < l; ++i) {
                c.setValueStrict(new ExpressionValue<String>(ExpressionValue.Type.STRING, (String)paramNames.get(i)), args[i]);
            }
            return body.evaluate(c);
        }, paramTypes));
    }

    private ExpressionNode node$Expr() {
        if (this.tokenReader.current() != null && this.tokenReader.current().type == Token.Type.KW_FUNC) {
            StringLocation s = this.tokenReader.current().loc;
            this.tokenReader.next();
            return this.val$FuncDef().located(StringLocation.cover(s, this.tokenReader.peek((int)-1).loc));
        }
        return this.node$BinOp(this::node$Term, Set.of(Operator.PLUS, Operator.MINUS));
    }

    private ExpressionNode node$Term() {
        return this.node$BinOp(this::node$Factor, Set.of(Operator.MULTIPLY, Operator.DIVIDE, Operator.POW));
    }

    private ExpressionNode node$Factor() {
        ExpressionNode node = null;
        Token<?> tok = this.tokenReader.current();
        if (tok != null) {
            ExpressionNode tn;
            if (tok.getType() == Token.Type.OPERATOR && Set.of(Operator.MINUS).contains((Object)tok.getValueAs(Operator.class))) {
                StringLocation loc1 = this.tokenReader.current().loc;
                this.tokenReader.next();
                if (this.tokenReader.current() == null) {
                    throw new SyntaxError("expected expression after unary operator").located(new StringLocation(loc1, loc1.startIndex + 1, loc1.endIndex + 1));
                }
                ExpressionNode fac = this.node$Factor();
                node = new UnaryOpNode(tok.getValueAs(Operator.class), fac).located(loc1);
            }
            if (tok.getType() == Token.Type.IDENTIFIER) {
                Token<?> tk1;
                IndexNode indexNode = new IndexNode(new ReturnContextNode(), new ConstantNode(new ExpressionValue(ExpressionValue.Type.STRING, tok.getValueAs())));
                Token<?> tko = this.tokenReader.current();
                while ((tk1 = this.tokenReader.next()) != null && tk1.getType() == Token.Type.DOT) {
                    StringLocation loc1 = this.tokenReader.current().loc;
                    this.tokenReader.next();
                    if (this.tokenReader.current() == null) {
                        throw new SyntaxError("expected identifier as index").located(new StringLocation(loc1, loc1.endIndex + 1, loc1.endIndex + 1));
                    }
                    if (this.tokenReader.current().type != Token.Type.IDENTIFIER) {
                        throw new SyntaxError("expected identifier as index").located(this.tokenReader.current().loc);
                    }
                    Token<?> idTok = this.tokenReader.current();
                    String id = (String)idTok.getValueAs();
                    indexNode = (IndexNode)new IndexNode(indexNode, new ConstantNode(new ExpressionValue<String>(ExpressionValue.Type.STRING, id)).located(idTok.loc)).located(tk1.loc);
                }
                node = indexNode;
            }
            if ((tn = this.node$Number()) != null) {
                node = tn;
            }
            if (tok.getType() == Token.Type.LEFT_PARENTHESIS) {
                this.tokenReader.next();
                tn = this.node$Expr();
                if (tn != null) {
                    if (this.tokenReader.current().getType() == Token.Type.RIGHT_PARENTHESIS) {
                        node = tn;
                        this.tokenReader.next();
                    } else {
                        throw new SyntaxError("expected ')' to end expression");
                    }
                }
            }
            if (this.tokenReader.current() != null && this.tokenReader.current().type == Token.Type.LEFT_PARENTHESIS) {
                Token<?> t1;
                StringLocation sl = this.tokenReader.current().loc;
                ArrayList<ExpressionNode> parameters = new ArrayList<ExpressionNode>();
                while ((t1 = this.tokenReader.current()) != null && t1.type != Token.Type.RIGHT_PARENTHESIS) {
                    StringLocation loc1 = t1.loc;
                    this.tokenReader.next();
                    if (this.tokenReader.current() == null) {
                        throw new SyntaxError("expected ')' to close function call").located(new StringLocation(loc1, loc1.endIndex + 1, loc1.endIndex + 1));
                    }
                    if (this.tokenReader.current().type == Token.Type.RIGHT_PARENTHESIS) break;
                    if (this.tokenReader.current().type == Token.Type.COMMA) {
                        this.tokenReader.next();
                    }
                    parameters.add(this.node$Expr());
                }
                node = new CallNode(node, parameters).located(StringLocation.cover(sl, this.tokenReader.current().loc));
                this.tokenReader.next();
            }
            if (this.tokenReader.current() != null && this.tokenReader.current().type == Token.Type.ASSIGN) {
                if (!(node instanceof IndexNode)) {
                    throw new SyntaxError("invalid indexing for assignment").located(this.tokenReader.current().loc);
                }
                this.tokenReader.next();
                ExpressionNode value = this.node$Expr();
                node = new AssignNode(((IndexNode)node).src, ((IndexNode)node).index, value);
            }
            return node;
        }
        throw new SyntaxError("expected NUMBER_LITERAL, OPERATOR or IDENTIFIER, got " + this.tokenReader.current()).located(this.tokenReader.current().loc);
    }

    private ExpressionNode node$Number() {
        Token<?> tok = this.tokenReader.current();
        if (tok != null && tok.getType() == Token.Type.NUMBER_LITERAL) {
            this.tokenReader.next();
            return new ConstantNode(new ExpressionValue<Double>(ExpressionValue.Type.NUMBER, tok.getValueAs(Double.class)));
        }
        return null;
    }

    void parseTokens(List<Token<?>> tokens) {
        this.tokenReader = new Reader(Sequence.ofList(tokens));
        this.astNode = this.node$Expr();
    }

    void parseAll() {
        if (this.strReader == null || this.tokens == null) {
            return;
        }
        this.parseTokens(this.tokens);
    }

    public ExpressionParser resetParsed() {
        this.tokens = new ArrayList();
        this.astNode = null;
        this.strReader = null;
        return this;
    }

    public ExpressionParser forString(String name) {
        this.resetParsed();
        this.strReader = new StringReader(name, 0);
        return this;
    }

    public ExpressionParser forReader(StringReader reader) {
        this.resetParsed();
        this.strReader = reader;
        return this;
    }

    public ExpressionParser inFile(String fn) {
        this.fn = fn;
        return this;
    }

    public ExpressionValue<?> doString(Context ctx, String str) {
        this.forString(str).lex().parse();
        return this.astNode.evaluate(ctx);
    }

    public ExpressionParser lex() {
        this.tokenize();
        return this;
    }

    public ExpressionParser parse() {
        this.parseAll();
        return this;
    }

    public ExpressionNode getAstNode() {
        return this.astNode;
    }

    public StringReader getStrReader() {
        return this.strReader;
    }

    public List<Token<?>> getTokens() {
        return this.tokens;
    }
}

