/*
 * Decompiled with CFR 0.152.
 */
package net.orbyfied.j8.util.math.expr;

import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Objects;
import java.util.function.Function;
import net.orbyfied.j8.util.math.expr.ExpressionFunction;
import net.orbyfied.j8.util.math.expr.error.ExprInterpreterException;

public class ExpressionValue<T> {
    public static final ExpressionValue<Void> NIL = new ExpressionValue<Object>(Type.NIL, null);
    final Type type;
    T val;

    public static ExpressionValue<?> newTable() {
        return new ExpressionValue(Type.TABLE, new HashMap());
    }

    public static ExpressionValue<?> tableSet(ExpressionValue<?> t, Object k, Object v) {
        t.checkType(Type.TABLE);
        t.getValueAs(HashMap.class).put(ExpressionValue.of(k), ExpressionValue.of(v));
        return t;
    }

    public static ExpressionValue<?> tableGet(ExpressionValue<?> t, Object k) {
        t.checkType(Type.TABLE);
        return (ExpressionValue)t.getValueAs(HashMap.class).get(ExpressionValue.of(k));
    }

    public static boolean tableHas(ExpressionValue<?> t, Object k) {
        t.checkType(Type.TABLE);
        return t.getValueAs(HashMap.class).containsKey(ExpressionValue.of(k));
    }

    public static int tableSize(ExpressionValue<?> t) {
        t.checkType(Type.TABLE);
        return t.getValueAs(HashMap.class).size();
    }

    public static ExpressionValue<?> of(Object val) {
        if (val instanceof ExpressionValue) {
            return (ExpressionValue)val;
        }
        if (val == null) {
            return NIL;
        }
        if (val instanceof String) {
            return new ExpressionValue<Object>(Type.STRING, val);
        }
        if (val instanceof Number) {
            return new ExpressionValue<Double>(Type.NUMBER, ((Number)val).doubleValue());
        }
        if (val instanceof ExpressionFunction) {
            return new ExpressionValue<Object>(Type.FUNCTION, val);
        }
        return null;
    }

    public static ExpressionValue<?> ofDouble(double d) {
        return new ExpressionValue<Double>(Type.NUMBER, d);
    }

    public ExpressionValue(Type type) {
        this.type = type;
    }

    public ExpressionValue(Type type, T val) {
        this(type);
        this.val = val;
    }

    public Type getType() {
        return this.type;
    }

    public T getValue() {
        return this.val;
    }

    public <V> V getValueAs() {
        return (V)this.val;
    }

    public <V> V getValueAs(Class<V> vClass) {
        return (V)this.val;
    }

    public boolean isNil() {
        return this.type == Type.NIL;
    }

    public ExpressionValue<T> checkNonNil() {
        if (this.isNil()) {
            throw new ExprInterpreterException("got a nil value");
        }
        return this;
    }

    public ExpressionValue<T> checkType(Type type) {
        if (this.type != type) {
            throw new ExprInterpreterException("expected " + type.name + ", got a " + this.type.name + " value");
        }
        return this;
    }

    public void setValue(T val) {
        this.val = val;
    }

    public boolean checkBool() {
        if (this.isNil()) {
            return false;
        }
        if (this.getType() == Type.NUMBER) {
            return this.getValueAs(Double.class) != 0.0;
        }
        return this.getValueAs(Boolean.class);
    }

    public ExpressionValue<T> structIndex(ExpressionValue<?> key) {
        return switch (this.type) {
            case Type.TABLE -> this.getValueAs(HashMap.class).getOrDefault(key, NIL);
            case Type.ARRAY -> (ExpressionValue<CallSite>)this.getValueAs(ArrayList.class).get(key.getValueAs(Double.class).intValue());
            case Type.STRING -> new ExpressionValue<CallSite>(Type.STRING, (CallSite)((Object)("" + this.getValueAs(String.class).charAt(key.getValueAs(Double.class).intValue()))));
            default -> throw new ExprInterpreterException("attempt to index a " + this.type.name + " value");
        };
    }

    public void structAssign(ExpressionValue<?> key, ExpressionValue<?> value) {
        switch (this.type) {
            case TABLE: {
                this.getValueAs(HashMap.class).put(key, value);
                break;
            }
            case ARRAY: {
                int idx = key.getValueAs(Double.class).intValue();
                ArrayList list = this.getValueAs(ArrayList.class);
                if (idx == list.size()) {
                    list.add(value);
                    break;
                }
                list.set(idx, value);
                break;
            }
            default: {
                throw new ExprInterpreterException("attempt to index a " + this.type + " value");
            }
        }
    }

    public ExpressionValue<T> tableSet(Object k, Object v) {
        this.checkType(Type.TABLE);
        this.getValueAs(HashMap.class).put(ExpressionValue.of(k), ExpressionValue.of(v));
        return this;
    }

    public ExpressionValue<?> tableGet(Object k) {
        this.checkType(Type.TABLE);
        return this.getValueAs(HashMap.class).getOrDefault(ExpressionValue.of(k), NIL);
    }

    public boolean tableHas(Object k) {
        this.checkType(Type.TABLE);
        return this.getValueAs(HashMap.class).containsKey(ExpressionValue.of(k));
    }

    public int tableSize() {
        this.checkType(Type.TABLE);
        return this.getValueAs(HashMap.class).size();
    }

    public String toString() {
        return this.type.toString.apply(this);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ExpressionValue that = (ExpressionValue)o;
        return this.type == that.type && Objects.equals(this.val, that.val);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.type, this.val});
    }

    public static enum Type {
        NUMBER("number", Double.TYPE, v -> Double.toString((Double)v.getValueAs())),
        STRING("string", String.class, v -> "\"" + v.getValueAs(String.class) + "\""),
        TABLE("table", HashMap.class, v -> v.getValueAs().toString()),
        ARRAY("array", ArrayList.class, v -> v.getValueAs(ArrayList.class).toString()),
        FUNCTION("function", ExpressionFunction.class, v -> "function"),
        USER("userdata", Object.class, v -> v.getValue().toString()),
        NIL("nil", Void.TYPE, v -> "nil");

        String name;
        Class<?> rtType;
        Function<ExpressionValue<?>, String> toString;

        private Type(String name, Class<?> rtType, Function<ExpressionValue<?>, String> toString) {
            this.name = name;
            this.rtType = rtType;
            this.toString = toString;
        }

        public String getName() {
            return this.name;
        }

        public Class<?> getRuntimeType() {
            return this.rtType;
        }
    }
}

