/*
 * Decompiled with CFR 0.152.
 */
package net.orbyfied.j8.util.math.expr;

import net.orbyfied.j8.util.StringReader;

public class StringLocation {
    public static final StringLocation EMPTY = null;
    String fn;
    String str;
    int startIndex;
    int endIndex;
    int ln = -1;

    public static StringLocation cover(StringLocation s, StringLocation e) {
        if (s == null || e == null) {
            return null;
        }
        return new StringLocation(s.fn, s.str, Math.min(s.startIndex, e.startIndex), Math.max(s.endIndex, e.endIndex));
    }

    public StringLocation(StringLocation loc, int startIndex, int endIndex) {
        this.fn = loc.fn;
        this.str = loc.str;
        this.startIndex = startIndex;
        this.endIndex = endIndex;
    }

    public StringLocation(String fn, String str, int startIndex, int endIndex) {
        this.str = str;
        this.fn = fn;
        this.startIndex = startIndex;
        this.endIndex = endIndex;
    }

    public StringLocation atLine(int ln) {
        this.ln = ln;
        return this;
    }

    public int getLn() {
        return this.ln;
    }

    public StringLocation(String fn, StringReader str, int startIndex, int endIndex) {
        this.str = str.getString();
        this.fn = fn;
        this.startIndex = startIndex;
        this.endIndex = endIndex;
    }

    public int getStartIndex() {
        return this.startIndex;
    }

    public int getEndIndex() {
        return this.endIndex;
    }

    public String getFilename() {
        return this.fn;
    }

    public String getString() {
        return this.str;
    }

    public String toString() {
        return "(" + this.startIndex + ":" + this.endIndex + (String)(this.ln == -1 ? "" : " ln " + this.ln) + ") in " + this.fn;
    }

    private String ac(String c, boolean fmt) {
        if (!fmt) {
            return "";
        }
        return "\u001b[" + c + "m";
    }

    public String toStringFancy(int off, boolean f) {
        StringBuilder b = new StringBuilder();
        b.append(this.ac("31", f)).append("(").append(this.startIndex).append(":").append(this.endIndex).append(") in ").append(this.fn).append(this.ac("0", f));
        if (this.endIndex >= this.str.length()) {
            this.str = this.str + " ";
        }
        int l = this.str.length();
        int ss = Math.max(0, Math.min(l, this.startIndex - off));
        int se = Math.max(0, Math.min(l, this.startIndex));
        int bs = Math.max(0, Math.min(l, this.startIndex));
        int be = Math.max(0, Math.min(l, this.endIndex + 1));
        int es = Math.max(0, Math.min(l, this.endIndex + 1));
        int ee = Math.max(0, Math.min(l, this.endIndex + off));
        b.append(this.ac("0", f) + this.ac("90", f)).append("...").append(this.ac("0", f) + this.ac("37", f)).append(this.str.substring(ss, se)).append(this.ac("0", f) + this.ac("31", f) + this.ac("4", f)).append(this.str.substring(bs, be)).append(this.ac("0", f) + this.ac("37", f)).append(this.str.substring(es, ee)).append(this.ac("0", f) + this.ac("90", f)).append("...");
        return b.toString();
    }
}

