/*
 * Decompiled with CFR 0.152.
 */
package net.orbyfied.j8.util.math.expr.node;

import net.orbyfied.j8.util.math.expr.Context;
import net.orbyfied.j8.util.math.expr.ExpressionNode;
import net.orbyfied.j8.util.math.expr.ExpressionValue;
import net.orbyfied.j8.util.math.expr.Operator;
import net.orbyfied.j8.util.math.expr.error.ExprInterpreterException;

public class BinOpNode
extends ExpressionNode {
    ExpressionNode left;
    ExpressionNode right;
    Operator op;

    public BinOpNode(Operator op, ExpressionNode left, ExpressionNode right) {
        super(ExpressionNode.Type.BIN_OP);
        this.op = op;
        this.left = left;
        this.right = right;
    }

    @Override
    public ExpressionValue<?> evaluate(Context ctx) {
        double l = (Double)this.left.evaluate(ctx).checkNonNil().getValueAs();
        double r = (Double)this.right.evaluate(ctx).checkNonNil().getValueAs();
        double o = 0.0;
        switch (this.op) {
            case PLUS: {
                o = l + r;
                break;
            }
            case MINUS: {
                o = l - r;
                break;
            }
            case MULTIPLY: {
                o = l * r;
                break;
            }
            case DIVIDE: {
                o = l / r;
                break;
            }
            case POW: {
                o = Math.pow(l, r);
                break;
            }
            default: {
                throw new ExprInterpreterException("operator not implemented: " + this.op.name());
            }
        }
        return new ExpressionValue<Double>(ExpressionValue.Type.NUMBER, o);
    }

    @Override
    protected String getDataAsString() {
        return "(" + this.left + ")" + this.op.getString() + "(" + this.right + ")";
    }
}

