/*
 * Decompiled with CFR 0.152.
 */
package net.orbyfied.j8.util.math.expr.node;

import net.orbyfied.j8.util.math.expr.Context;
import net.orbyfied.j8.util.math.expr.ExpressionNode;
import net.orbyfied.j8.util.math.expr.ExpressionValue;
import net.orbyfied.j8.util.math.expr.error.ExprInterpreterException;

public class IndexNode
extends ExpressionNode {
    public ExpressionNode src;
    public ExpressionNode index;

    public IndexNode(ExpressionNode src, ExpressionNode key) {
        super(ExpressionNode.Type.INDEX);
        this.src = src;
        this.index = key;
    }

    @Override
    public ExpressionValue<?> evaluate(Context context) {
        ExpressionNode src = this.src;
        ExpressionValue<?> srcVal = src.evaluate(context);
        if (srcVal == null || srcVal.isNil()) {
            throw new ExprInterpreterException("attempt to index a nil value").located(this.getLocation());
        }
        ExpressionValue<?> indexVal = this.index.evaluate(context);
        try {
            return srcVal.structIndex(indexVal);
        }
        catch (ExprInterpreterException e) {
            throw e.located(this.getLocation());
        }
    }

    @Override
    protected String getDataAsString() {
        return "(" + this.src + ")[" + this.index + "]";
    }
}

