/*
 * Decompiled with CFR 0.152.
 */
package net.orbyfied.osf.bootstrap;

import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import net.orbyfied.j8.util.Reader;
import net.orbyfied.j8.util.Sequence;
import net.orbyfied.j8.util.StringReader;
import net.orbyfied.osf.bootstrap.ArgParseException;
import net.orbyfied.osf.util.Values;

public class ArgParser {
    Map<String, Class<?>> spec = new HashMap();
    List<Class<?>> posSpec = new ArrayList();
    List<String> reqArgs = new ArrayList<String>();
    Map<Class<?>, Function<StringReader, Object>> parsers = new HashMap();

    public ArgParser() {
        this.withParser(Boolean.class, reader -> Boolean.parseBoolean(reader.collect()));
        this.withParser(Float.class, reader -> Float.valueOf(Float.parseFloat(reader.collect())));
        this.withParser(Double.class, reader -> Double.parseDouble(reader.collect()));
        this.withParser(Integer.class, reader -> Integer.parseInt(reader.collect()));
        this.withParser(Long.class, reader -> Long.parseLong(reader.collect()));
        this.withParser(String.class, StringReader::collect);
        this.withParser(Path.class, reader -> Path.of(reader.collect(), new String[0]));
    }

    public ArgParser withArgument(String name, Class<?> type, boolean required) {
        this.withArgument(name, type);
        if (name != null && required) {
            this.reqArgs.add(name);
        }
        return this;
    }

    public ArgParser withArgument(String name, Class<?> type) {
        if (name == null) {
            this.posSpec.add(type);
        } else {
            this.spec.put(name, type);
        }
        return this;
    }

    public <T> ArgParser withParser(Class<T> type, Function<StringReader, T> function) {
        this.parsers.put(type, function);
        return this;
    }

    public Values parseArgsUnchecked(List<String> args) {
        String str;
        Values values = new Values();
        ArrayList<Object> positionedValues = new ArrayList<Object>(this.posSpec.size());
        Values externValues = new Values();
        values.setFlat("#pos", positionedValues);
        values.setFlat("#ext", externValues);
        Reader<String> argReader = new Reader<String>(Sequence.ofList(args));
        int pi = 0;
        while ((str = argReader.current()) != null) {
            if (str.startsWith("--")) {
                Object val;
                String key = str.substring(2);
                Class<?> type = this.spec.get(key);
                if (type == null) {
                    throw new ArgParseException("unknown named arg '" + key + "' " + pi + " ('" + str + "' @ " + argReader.index() + ")");
                }
                parser = this.parsers.get(type);
                if (parser == null) {
                    throw new ArgParseException("dont know how to parse type '" + type.getName() + "'");
                }
                valStr = argReader.next();
                if (valStr == null) {
                    throw new ArgParseException("expected value of type '" + type.getName() + "' for arg '" + key + "'");
                }
                try {
                    val = parser.apply(new StringReader(valStr));
                }
                catch (Exception e) {
                    throw new ArgParseException("error while parsing arg '" + key + "' of type '" + type.getName() + "'", e);
                }
                values.setFlat(key, val);
            } else if (str.startsWith("-")) {
                char op = str.charAt(1);
                String name = str.substring(2);
                switch (op) {
                    case 'D': 
                    case 'E': {
                        valStr = argReader.next();
                        if (valStr == null) {
                            throw new ArgParseException("expected value for extern value spec '" + name + "'");
                        }
                        externValues.setFlat(name, valStr);
                        values.setFlat("#E" + name, valStr);
                    }
                }
            } else {
                Object val;
                if (pi >= this.posSpec.size()) {
                    throw new ArgParseException("unexpected positioned arg " + pi + " ('" + str + "' @ " + argReader.index() + ")");
                }
                Class<?> type = this.posSpec.get(pi);
                parser = this.parsers.get(type);
                if (parser == null) {
                    throw new ArgParseException("dont know how to parse type '" + type.getName() + "'");
                }
                try {
                    val = parser.apply(new StringReader(str));
                }
                catch (Exception e) {
                    throw new ArgParseException("error while parsing positioned arg " + pi + " of type '" + type.getName() + "'", e);
                }
                values.setFlat("#" + pi, val);
                positionedValues.add(val);
                ++pi;
            }
            argReader.next();
        }
        return values;
    }

    public Values checkRequired(Values values) {
        for (String rKey : this.reqArgs) {
            if (values.contains(rKey)) continue;
            throw new ArgParseException("required arg '" + rKey + "' is not present");
        }
        return values;
    }

    public Values parseArgs(List<String> args) {
        return this.checkRequired(this.parseArgsUnchecked(args));
    }

    public Values parseConsoleArgs(String[] oldArgs) {
        String arg;
        ArrayList<String> args = new ArrayList<String>();
        Reader<String> argReader = new Reader<String>(Sequence.ofList(Arrays.asList(oldArgs)));
        StringBuilder buf = new StringBuilder();
        while ((arg = argReader.current()) != null) {
            if (arg.startsWith("\"") || arg.startsWith("'")) {
                buf.append(arg, 1, arg.length());
            } else if (arg.endsWith("\"") || arg.endsWith("'")) {
                buf.append(" ").append(arg, 0, arg.length() - 1);
                args.add(buf.toString());
                buf = new StringBuilder();
            } else {
                args.add(arg);
            }
            argReader.next();
        }
        return this.parseArgs(args);
    }

    public <T> T parseValue(String str, Class<?> tClass) {
        if (str == null) {
            return null;
        }
        Function<StringReader, Object> func = this.parsers.get(tClass);
        if (func == null) {
            throw new UnsupportedOperationException("dont know how to parse type '" + tClass.getName() + "'");
        }
        return (T)func.apply(new StringReader(str));
    }

    public String getExtern(Values values, String name) {
        if (values == null) {
            return null;
        }
        return (String)values.getFlat("#ext", Values.class).getFlat(name);
    }

    public <T> T getExtern(Values values, String name, Class<T> tClass) {
        if (values == null) {
            return null;
        }
        String str = (String)values.getFlat("#ext", Values.class).getFlat(name);
        return this.parseValue(str, tClass);
    }
}

