/*
 * Decompiled with CFR 0.152.
 */
package net.orbyfied.osf.bootstrap;

import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.file.Path;
import java.util.function.BiConsumer;
import java.util.function.Supplier;
import net.orbyfied.osf.bootstrap.ArgParser;
import net.orbyfied.osf.bootstrap.ServerBootstrapException;
import net.orbyfied.osf.bootstrap.YamlConfig;
import net.orbyfied.osf.server.Server;
import net.orbyfied.osf.util.Values;

public class ServerBootstrap {
    private Path workDir = Path.of("./", new String[0]);
    private ArgParser argParser = new ArgParser();
    private Values args = new Values();
    Values mainConfig = new Values();
    private SocketAddress defaultAddress;
    private Integer defaultPort;
    private Server server;

    public ServerBootstrap withArgumentParser(ArgParser parser) {
        this.argParser = parser;
        return this;
    }

    public ServerBootstrap configureDefaultArguments() {
        this.argParser.withArgument("work-dir", Path.class, false).withArgument("connect", String.class, false);
        return this;
    }

    public ServerBootstrap configureArguments(BiConsumer<ServerBootstrap, ArgParser> consumer) {
        consumer.accept(this, this.argParser);
        return this;
    }

    public ServerBootstrap useConsoleArguments(String[] cmdArgs) {
        try {
            this.args.putAll(this.argParser.parseConsoleArgs(cmdArgs));
        }
        catch (Exception e) {
            throw new ServerBootstrapException("Error while parsing console args", e);
        }
        this.workDir = this.args.getOrDefaultFlat("work-dir", Path.of("./", new String[0]));
        return this;
    }

    public Values argumentValues() {
        return this.args;
    }

    public ServerBootstrap loadMainConfiguration(String file, Class<?> ref, String defaultResourceName) {
        try {
            this.mainConfig.putAll(YamlConfig.copyDefaultsAndLoad(this.workDir.resolve(file), ref, defaultResourceName));
        }
        catch (Exception e) {
            throw new ServerBootstrapException("Error while loading main configuration\n [file: " + file + ", defaults: " + defaultResourceName + "]", e);
        }
        return this;
    }

    public Values getMainConfiguration() {
        return this.mainConfig;
    }

    public ServerBootstrap withConfigurationValue(Object key, Object value) {
        this.args.setFlat(key, value);
        return this;
    }

    public Server getServer() {
        return this.server;
    }

    public ServerBootstrap withServer(Server server) {
        this.server = server;
        return this;
    }

    public ServerBootstrap withServer(Supplier<Server> constructor) {
        try {
            this.withServer(constructor.get());
            return this;
        }
        catch (Exception e) {
            throw new ServerBootstrapException("Error while constructing server", e);
        }
    }

    public ServerBootstrap withDefaultAddress(SocketAddress address) {
        this.defaultAddress = address;
        return this;
    }

    public ServerBootstrap withDefaultPort(int port) {
        this.defaultPort = port;
        return this;
    }

    public ServerBootstrap bootstrap() {
        if (this.server == null) {
            throw new ServerBootstrapException("No server was created");
        }
        try {
            SocketAddress address = null;
            String adrStr = this.args.getOrDefaultFlat("connect", (String)this.mainConfig.getFlat("address"));
            if (adrStr != null) {
                String[] parts = adrStr.split(":");
                if (parts.length < 1) {
                    throw new ServerBootstrapException("Invalid host address specified: " + adrStr);
                }
                String host = parts[0];
                Integer port = null;
                if (parts.length > 1) {
                    port = Integer.parseInt(parts[1]);
                } else if (this.defaultPort == null) {
                    if (this.defaultAddress == null) {
                        throw new ServerBootstrapException("No host address port was specified");
                    }
                    address = this.defaultAddress;
                } else {
                    port = this.defaultPort;
                }
                if (port != null) {
                    address = new InetSocketAddress(host, (int)port);
                }
            } else {
                if (this.defaultAddress == null) {
                    throw new ServerBootstrapException("No host address was specified");
                }
                address = this.defaultAddress;
            }
            this.server.open(address);
        }
        catch (Exception e) {
            throw new ServerBootstrapException("Error while connecting server", e);
        }
        try {
            this.server.prepare();
        }
        catch (Exception e) {
            throw new ServerBootstrapException("Error while preparing server", e);
        }
        try {
            this.server.start();
        }
        catch (Exception e) {
            throw new ServerBootstrapException("Error while activating server", e);
        }
        return this;
    }

    public ServerBootstrap awaitClose() {
        this.server.serverSocketWorker().await();
        return this;
    }
}

