/*
 * Decompiled with CFR 0.152.
 */
package net.orbyfied.osf.bootstrap;

import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import net.orbyfied.osf.util.Values;
import org.yaml.snakeyaml.Yaml;

public class YamlConfig {
    private static final Yaml yaml = new Yaml();

    public static Values copyDefaultsAndLoad(Path file, Class<?> src, String rp) {
        if (!((String)rp).startsWith("/")) {
            rp = "/" + (String)rp;
        }
        try {
            if (Files.exists(file, new LinkOption[0])) {
                Map values = (Map)yaml.load(Files.newInputStream(file, new OpenOption[0]));
                InputStream dIn = src.getResourceAsStream((String)rp);
                if (dIn == null) {
                    throw new IllegalArgumentException("Could not open configuration defaults " + (String)rp + " in the JAR of " + src);
                }
                Map defaultValues = (Map)yaml.load(dIn);
                Integer cv = (Integer)values.get("=version");
                Integer dv = (Integer)defaultValues.get("=version");
                if (cv != null && dv != null && cv < dv) {
                    YamlConfig.copyAbsentDefaults(values, defaultValues);
                    CompletableFuture.runAsync(() -> {
                        try {
                            OutputStream stream = Files.newOutputStream(file, new OpenOption[0]);
                            yaml.dump(values, new OutputStreamWriter(stream));
                            stream.flush();
                            stream.close();
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    });
                }
                return new Values(values);
            }
            Files.createDirectories(file.getParent(), new FileAttribute[0]);
            Files.createFile(file, new FileAttribute[0]);
            OutputStream fos = Files.newOutputStream(file, new OpenOption[0]);
            InputStream ris = src.getResourceAsStream((String)rp);
            ris.transferTo(fos);
            fos.flush();
            ris.close();
            fos.close();
            InputStream fis = Files.newInputStream(file, new OpenOption[0]);
            Map vals = (Map)yaml.load(fis);
            fis.close();
            return new Values(vals);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static void copyAbsentDefaults(Map current, Map<?, ?> defaults) {
        for (Map.Entry<?, ?> entry : defaults.entrySet()) {
            Object k = entry.getKey();
            Object v = entry.getValue();
            if (!current.containsKey(k)) {
                current.put(k, v);
                continue;
            }
            Object cv = current.get(k);
            if (!(cv instanceof Map)) continue;
            Map mc = (Map)cv;
            if (!(v instanceof Map)) continue;
            Map md = (Map)v;
            YamlConfig.copyAbsentDefaults(mc, md);
        }
    }
}

