/*
 * Decompiled with CFR 0.152.
 */
package net.orbyfied.osf.db;

import net.orbyfied.osf.db.DatabaseManager;
import net.orbyfied.osf.db.DatabaseType;
import net.orbyfied.osf.db.Login;
import net.orbyfied.osf.db.QueryPool;

public abstract class Database {
    protected final String name;
    protected final DatabaseManager manager;
    protected final DatabaseType type;
    public final QueryPool universalQueryPool;

    public Database(DatabaseManager manager, String name, DatabaseType type) {
        this.manager = manager;
        this.name = name;
        this.type = type;
        this.universalQueryPool = this.queryPool();
    }

    public abstract boolean isOpen();

    public DatabaseType type() {
        return this.type;
    }

    public DatabaseManager manager() {
        return this.manager;
    }

    public String name() {
        return this.name;
    }

    public void login(Login login) {
        this.type.login(this, login);
    }

    public void close() {
        this.type.close(this);
    }

    public QueryPool queryPool() {
        return new QueryPool(null).current(this);
    }
}

