/*
 * Decompiled with CFR 0.152.
 */
package net.orbyfied.osf.db;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import net.orbyfied.j8.registry.Identifier;
import net.orbyfied.osf.db.Database;
import net.orbyfied.osf.db.DatabaseType;
import net.orbyfied.osf.db.QueryPool;
import net.orbyfied.osf.util.logging.EventLog;
import net.orbyfied.osf.util.logging.Logging;

public class DatabaseManager {
    public static final EventLog LOGGER = Logging.getEventLog("Databases");
    final ArrayList<Database> db = new ArrayList();
    final HashMap<String, Database> dbByName = new HashMap();
    final ArrayList<DatabaseType<Database>> dbt = new ArrayList();
    final HashMap<Identifier, DatabaseType<Database>> dbtById = new HashMap();

    public DatabaseManager() {
        this.addType(DatabaseType.MONGO_DB);
    }

    public List<Database> databases() {
        return Collections.unmodifiableList(this.db);
    }

    public List<DatabaseType<Database>> types() {
        return Collections.unmodifiableList(this.dbt);
    }

    public <D extends Database> D getDatabase(String name) {
        return (D)this.dbByName.get(name);
    }

    public DatabaseManager addDatabase(Database database) {
        this.db.add(database);
        this.dbByName.put(database.name, database);
        return this;
    }

    public <D extends Database> DatabaseManager addDatabase(String name, BiFunction<DatabaseManager, String, D> constructor, Consumer<D> consumer) {
        Database db = (Database)constructor.apply(this, name);
        this.addDatabase(db);
        if (consumer != null) {
            consumer.accept(db);
        }
        return this;
    }

    public DatabaseManager addType(DatabaseType type) {
        this.dbt.add(type);
        this.dbtById.put(type.id, type);
        return this;
    }

    public QueryPool queryPool() {
        return new QueryPool(null);
    }
}

