/*
 * Decompiled with CFR 0.152.
 */
package net.orbyfied.osf.db;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import net.orbyfied.j8.util.functional.TriFunction;
import net.orbyfied.osf.db.Database;
import net.orbyfied.osf.db.DatabaseType;
import net.orbyfied.osf.util.Values;

public class DatabaseQuery<R, D extends Database> {
    Executor executor = Executors.newFixedThreadPool(2);
    final String op;
    final DatabaseType<D> type;
    final TriFunction<DatabaseQuery<R, D>, D, Values, R> func;

    public DatabaseQuery(String op, DatabaseType<D> type, TriFunction<DatabaseQuery<R, D>, D, Values, R> func) {
        this.op = op;
        this.type = type;
        this.func = func;
    }

    public DatabaseType<D> getType() {
        return this.type;
    }

    public String getOperation() {
        return this.op;
    }

    public R doSync(D db, Values vals) {
        Values fvals = vals == null ? new Values() : vals;
        return this.func.apply(this, db, fvals);
    }

    public CompletableFuture<R> doAsync(D db, Values vals) {
        Values fvals = vals == null ? new Values() : vals;
        return CompletableFuture.supplyAsync(() -> this.func.apply(this, db, fvals), this.executor);
    }
}

