/*
 * Decompiled with CFR 0.152.
 */
package net.orbyfied.osf.db;

import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.concurrent.CompletableFuture;
import net.orbyfied.j8.util.functional.TriFunction;
import net.orbyfied.osf.db.Database;
import net.orbyfied.osf.db.DatabaseQuery;
import net.orbyfied.osf.db.DatabaseType;
import net.orbyfied.osf.util.Values;

public class QueryPool {
    Values env = new Values();
    Int2ObjectOpenHashMap<DatabaseQuery<Object, Database>> queries = new Int2ObjectOpenHashMap();
    Database database;
    DatabaseType<Database> currentType;
    QueryPool parent;

    public static int getHash(String op, DatabaseType<?> type) {
        return op.hashCode() * 31 | System.identityHashCode(type);
    }

    QueryPool(QueryPool parent) {
        this.parent = parent;
    }

    public QueryPool current(Database database) {
        this.database = database;
        this.currentType = database != null ? database.type : null;
        return this;
    }

    public QueryPool fork() {
        return new QueryPool(this).current(this.database);
    }

    public <R, D extends Database> DatabaseQuery<R, D> getQuery(int h) {
        DatabaseQuery<Object, Database> query = this.queries.get(h);
        if (query != null) {
            return query;
        }
        if (this.parent != null) {
            return this.parent.getQuery(h);
        }
        return null;
    }

    public <R, D extends Database> DatabaseQuery<R, D> getQuery(String op, DatabaseType<D> type) {
        int h = QueryPool.getHash(op, type);
        return this.getQuery(h);
    }

    public <R, D extends Database> DatabaseQuery<R, D> getQuery(String op) {
        return this.getQuery(op, this.currentType);
    }

    public QueryPool putQuery(DatabaseQuery<?, ? extends Database> query) {
        this.queries.put(QueryPool.getHash(query.op, query.type), (DatabaseQuery<Object, Database>)query);
        return this;
    }

    public <R, D extends Database> QueryPool putQuery(String op, DatabaseType<D> type, TriFunction<DatabaseQuery<R, D>, D, Values, R> func) {
        return this.putQuery(new DatabaseQuery<R, D>(op, type, func));
    }

    public <R> R querySync(String op, DatabaseType<Database> type, Values vals) {
        return this.getQuery(op, type).doSync(this.database, vals);
    }

    public <R> CompletableFuture<R> queryAsync(String op, DatabaseType<Database> type, Values vals) {
        return this.getQuery(op, type).doAsync(this.database, vals);
    }

    public <R> R querySync(String op, Values vals) {
        return this.getQuery(op, this.currentType).doSync(this.database, vals);
    }

    public <R> R querySync(String op, Object ... vals) {
        return this.getQuery(op, this.currentType).doSync(this.database, Values.ofVarargs(vals));
    }

    public <R> R querySync(String op, Values values, Object ... vals) {
        return this.getQuery(op, this.currentType).doSync(this.database, Values.ofVarargs(values, vals));
    }

    public <R> CompletableFuture<R> queryAsync(String op, Values vals) {
        return this.getQuery(op, this.currentType).doAsync(this.database, vals);
    }

    public <R> CompletableFuture<R> queryAsync(String op, Object ... vals) {
        return this.getQuery(op, this.currentType).doAsync(this.database, Values.ofVarargs(vals));
    }

    public <R> CompletableFuture<R> queryAsync(String op, Values values, Object ... vals) {
        return this.getQuery(op, this.currentType).doAsync(this.database, Values.ofVarargs(values, vals));
    }
}

