/*
 * Decompiled with CFR 0.152.
 */
package net.orbyfied.osf.db.impl;

import com.mongodb.client.MongoCollection;
import com.mongodb.client.model.Filters;
import com.mongodb.client.model.UpdateOptions;
import com.mongodb.client.model.Updates;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.Map;
import net.orbyfied.osf.db.Database;
import net.orbyfied.osf.db.DatabaseItem;
import org.bson.Document;
import org.bson.conversions.Bson;

public class MongoDatabaseItem
extends DatabaseItem {
    Object key;
    MongoCollection<Document> collection;
    String keyName;
    Object2ObjectOpenHashMap<String, Object> changes = new Object2ObjectOpenHashMap();
    Document document;

    public MongoDatabaseItem(Database database, String keyName, MongoCollection<Document> collection, Object key) {
        super(database);
        this.keyName = keyName;
        this.collection = collection;
        this.key = key;
    }

    public Bson createFilter() {
        return Filters.eq((String)this.keyName, (Object)this.key);
    }

    @Override
    public Object key() {
        return this.key;
    }

    @Override
    public void set(String key, Object val) {
        this.changes.put(key, val);
        if (this.document != null) {
            this.document.put(key, val);
        }
    }

    @Override
    public <T> T get(String key, Class<T> type) {
        return (T)this.document.get((Object)key, type);
    }

    @Override
    public MongoDatabaseItem push() {
        Bson[] bsons = new Bson[this.changes.size()];
        int i = 0;
        for (Map.Entry entry : this.changes.entrySet()) {
            bsons[i] = Updates.set((String)((String)entry.getKey()), entry.getValue());
            ++i;
        }
        Bson update = Updates.combine((Bson[])bsons);
        this.changes.clear();
        this.collection.updateOne(this.createFilter(), update, new UpdateOptions().upsert(true));
        return this;
    }

    @Override
    public MongoDatabaseItem pull() {
        this.document = (Document)this.collection.find(this.createFilter()).first();
        return this;
    }
}

