/*
 * Decompiled with CFR 0.152.
 */
package net.orbyfied.osf.db.impl;

import com.mongodb.ConnectionString;
import com.mongodb.MongoClientSettings;
import com.mongodb.client.MongoClient;
import com.mongodb.client.MongoClients;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.orbyfied.j8.registry.Identifier;
import net.orbyfied.osf.db.Database;
import net.orbyfied.osf.db.DatabaseManager;
import net.orbyfied.osf.db.DatabaseType;
import net.orbyfied.osf.db.Login;
import net.orbyfied.osf.db.impl.MongoDatabase;
import net.orbyfied.osf.util.Values;
import net.orbyfied.osf.util.logging.EventLog;

public class MongoDatabaseType
extends DatabaseType<MongoDatabase> {
    public static final Identifier ID = Identifier.of("mongodb");

    public MongoDatabaseType() {
        super(ID);
        Logger logger = Logger.getLogger("org.mongodb.driver");
        logger.setLevel(Level.OFF);
    }

    @Override
    protected void login(MongoDatabase database, Login login) {
        EventLog logger = DatabaseManager.LOGGER;
        try {
            MongoClient mongoClient;
            logger.info("database_login", "Logging in database '" + database.name() + "' of type " + ID, new Object[0]);
            if (!(login instanceof Login.URILogin)) {
                throw new IllegalArgumentException("login must be a URILogin");
            }
            Login.URILogin ul = (Login.URILogin)login;
            ConnectionString connectionString = new ConnectionString(ul.getURI());
            MongoClientSettings settings = MongoClientSettings.builder().applyConnectionString(connectionString).build();
            database.client = mongoClient = MongoClients.create((MongoClientSettings)settings);
            database.db = mongoClient.getDatabase(ul.getDatabase());
            logger.ok("database_login", "Successfully logged in database '" + database.name() + "'", new Object[0]);
        }
        catch (Exception e) {
            logger.err("database_login", "Error while logging in database '" + database.name() + "'", e);
            e.printStackTrace();
        }
    }

    @Override
    protected void close(MongoDatabase database) {
        database.client.close();
    }

    @Override
    protected void putEnv(Database db, Values values) {
    }
}

