/*
 * Decompiled with CFR 0.152.
 */
package net.orbyfied.osf.network;

import java.util.concurrent.atomic.AtomicBoolean;
import net.orbyfied.osf.network.NetworkManager;
import net.orbyfied.osf.network.Packet;
import net.orbyfied.osf.network.handler.HandlerNode;
import net.orbyfied.osf.util.logging.EventLog;
import net.orbyfied.osf.util.logging.Logging;

public abstract class NetworkHandler<S extends NetworkHandler> {
    protected static final EventLog LOGGER = Logging.getEventLog("NetworkHandler");
    protected Object owner;
    protected final NetworkManager manager;
    protected final NetworkHandler parent;
    protected HandlerNode node = new HandlerNode(null);
    protected AtomicBoolean active = new AtomicBoolean(true);
    protected WorkerThread workerThread;
    private final S self;

    public NetworkHandler(NetworkManager manager, NetworkHandler parent) {
        this.manager = manager;
        this.parent = parent;
        this.self = this;
    }

    public S owned(Object owner) {
        this.owner = owner;
        return this.self;
    }

    public HandlerNode node() {
        return this.node;
    }

    public NetworkManager manager() {
        return this.manager;
    }

    public S start() {
        if (this.workerThread == null) {
            this.workerThread = this.createWorkerThread();
        }
        if (this.workerThread == null) {
            return this.self;
        }
        this.active.set(true);
        this.workerThread.start();
        return this.self;
    }

    public S stop() {
        this.active.set(false);
        return this.self;
    }

    public S fatalClose() {
        return this.self;
    }

    public boolean active() {
        return this.active.get();
    }

    protected abstract WorkerThread createWorkerThread();

    protected void handle(Packet packet) {
        if (this.parent != null) {
            this.parent.handle(packet);
        }
    }

    protected abstract boolean canHandleAsync(Packet var1);

    protected abstract void scheduleHandleAsync(Packet var1);

    public abstract class WorkerThread
    extends Thread {
        static int id = 0;

        public WorkerThread() {
            super("NHWorker-" + id++);
        }

        @Override
        public void run() {
            try {
                this.runSafe();
            }
            catch (Throwable t) {
                NetworkHandler.this.fatalClose();
                LOGGER.err("socket_worker_loop", this.getName() + ": Error in socket worker network loop", new Object[0]);
                t.printStackTrace();
            }
            NetworkHandler.this.active.set(false);
        }

        public abstract void runSafe() throws Throwable;
    }
}

