/*
 * Decompiled with CFR 0.152.
 */
package net.orbyfied.osf.network;

import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.orbyfied.j8.registry.Identifier;
import net.orbyfied.j8.util.reflect.Reflector;
import net.orbyfied.osf.network.Packet;
import net.orbyfied.osf.network.PacketType;
import net.orbyfied.osf.util.logging.Logging;

public class NetworkManager {
    private static final Reflector reflector = new Reflector("NetworkManager");
    Int2ObjectOpenHashMap<PacketType<? extends Packet>> packetTypesById = new Int2ObjectOpenHashMap();
    ArrayList<PacketType<? extends Packet>> packetTypes = new ArrayList();

    public NetworkManager register(PacketType<? extends Packet> type) {
        this.packetTypesById.put(type.identifier().hashCode(), type);
        this.packetTypes.add(type);
        return this;
    }

    public PacketType<? extends Packet> getByIdentifier(Identifier id) {
        return this.packetTypesById.get(id.hashCode());
    }

    public PacketType<? extends Packet> getByHash(int id) {
        return this.packetTypesById.get(id);
    }

    public List<PacketType<? extends Packet>> getPacketTypes() {
        return Collections.unmodifiableList(this.packetTypes);
    }

    public NetworkManager compilePacketClass(Class<? extends Packet> klass) {
        try {
            Field field = reflector.reflectDeclaredField(klass, "TYPE");
            PacketType type = (PacketType)reflector.reflectGetField(field, null);
            this.register(type);
            return this;
        }
        catch (Exception e) {
            e.printStackTrace(Logging.ERR);
            return this;
        }
    }
}

