/*
 * Decompiled with CFR 0.152.
 */
package net.orbyfied.osf.network;

import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import net.orbyfied.j8.registry.Identifier;
import net.orbyfied.osf.network.Packet;
import net.orbyfied.osf.network.Packets;

public class PacketType<P extends Packet> {
    final Class<P> type;
    final Identifier id;
    Packets.Serializer<P> serializer;
    Packets.Deserializer<P> deserializer;

    public PacketType(Class<P> type, Identifier id) {
        this.type = type;
        this.id = id;
    }

    public PacketType(Class<P> type, String id) {
        this.type = type;
        this.id = Identifier.of(id);
    }

    public Identifier identifier() {
        return this.id;
    }

    public Class<? extends Packet> getPacketClass() {
        return this.type;
    }

    public Packets.Serializer<P> serializer() {
        return this.serializer;
    }

    public PacketType<P> serializer(Packets.Serializer<P> serializer) {
        this.serializer = serializer;
        return this;
    }

    public Packets.Deserializer<P> deserializer() {
        return this.deserializer;
    }

    public PacketType<P> deserializer(Packets.Deserializer<P> deserializer) {
        this.deserializer = deserializer;
        return this;
    }

    public P deserialize(ObjectInputStream stream) throws Throwable {
        if (this.deserializer != null) {
            return this.deserializer.deserialize(this, stream);
        }
        return null;
    }

    public void serialize(P packet, ObjectOutputStream stream) throws Throwable {
        if (this.serializer != null) {
            this.serializer.serialize(this, packet, stream);
        }
    }
}

