/*
 * Decompiled with CFR 0.152.
 */
package net.orbyfied.osf.network.handler;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.orbyfied.j8.util.functional.TriPredicate;
import net.orbyfied.osf.network.NetworkHandler;
import net.orbyfied.osf.network.Packet;
import net.orbyfied.osf.network.PacketType;
import net.orbyfied.osf.network.handler.ChainAction;
import net.orbyfied.osf.network.handler.HandlerResult;
import net.orbyfied.osf.network.handler.NodeAction;

public class HandlerNode {
    final HandlerNode parent;
    List<HandlerNode> children = new ArrayList<HandlerNode>();
    Map<PacketType<? extends Packet>, HandlerNode> childDirectPredicateType = new HashMap<PacketType<? extends Packet>, HandlerNode>();
    TriPredicate<NetworkHandler, HandlerNode, Packet> predicate;
    PacketType<? extends Packet> directPredicateType;
    List<Handler<? extends Packet>> handlers = new ArrayList<Handler<? extends Packet>>();

    public HandlerNode(HandlerNode parent) {
        this.parent = parent;
    }

    public HandlerNode childWhen(TriPredicate<NetworkHandler, HandlerNode, Packet> predicate) {
        HandlerNode node = new HandlerNode(this);
        node.predicate = predicate;
        this.children.add(node);
        return node;
    }

    public HandlerNode childForType(PacketType<? extends Packet> type) {
        HandlerNode node = new HandlerNode(this);
        node.directPredicateType = type;
        node.predicate = (handler, node1, packet) -> packet.type() == type;
        this.children.add(node);
        this.childDirectPredicateType.put(type, node);
        return node;
    }

    public <P extends Packet> HandlerNode withHandler(Handler<P> handler) {
        this.handlers.add(handler);
        return this;
    }

    public void remove() {
        if (this.parent != null) {
            this.parent.children.remove(this);
            if (this.directPredicateType != null) {
                this.parent.childDirectPredicateType.remove(this.directPredicateType);
            }
        }
    }

    public HandlerResult handle(NetworkHandler handler, Packet packet) {
        HandlerResult result;
        if (packet == null) {
            return new HandlerResult(ChainAction.HALT);
        }
        for (Handler<? extends Packet> h : this.handlers) {
            result = h.handle(handler, this, packet);
            if (result.chain() == ChainAction.HALT) {
                return result;
            }
            if (result.nodeAction() != NodeAction.REMOVE) continue;
            this.remove();
        }
        HandlerNode child = this.childDirectPredicateType.get(packet.type());
        if (child != null && (result = child.handle(handler, packet)).chain() == ChainAction.HALT) {
            return result;
        }
        for (HandlerNode node : this.children) {
            if (!node.predicate.test(handler, node, packet) || (result = node.handle(handler, packet)).chain() != ChainAction.HALT) continue;
            return result;
        }
        return new HandlerResult(ChainAction.CONTINUE);
    }

    public static interface Handler<P extends Packet> {
        public HandlerResult handle(NetworkHandler var1, HandlerNode var2, P var3);
    }
}

